/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.nestjs;

import com.intellij.javascript.microservices.nestjs.NestJSMethodDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002JH\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\n0\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/microservices/nestjs/NestJSIndexingHandler;", "Lcom/intellij/lang/javascript/index/FrameworkIndexingHandler;", "<init>", "()V", "getMarkers", "", "", "elementToIndex", "Lcom/intellij/psi/PsiElement;", "shouldCreateStubForCallExpression", "", "node", "Lcom/intellij/lang/ASTNode;", "shouldCreateStubForLiteral", "isDecoratorArgument", "literalExpressionNode", "isMappingDecoratorCall", "callNode", "isMappingDecorator", "referenceName", "checkCallExpression", "check", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "hasQualifier", "isNestJSControllerClass", "psiElement", "intellij.javascript.langInjection"})
@SourceDebugExtension(value={"SMAP\nNestJSIndexingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestJSIndexingHandler.kt\ncom/intellij/javascript/microservices/nestjs/NestJSIndexingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,116:1\n1586#2:117\n1661#2,3:118\n18#3:121\n18#3:122\n13225#4,2:123\n*S KotlinDebug\n*F\n+ 1 NestJSIndexingHandler.kt\ncom/intellij/javascript/microservices/nestjs/NestJSIndexingHandler\n*L\n92#1:117\n92#1:118,3\n108#1:121\n109#1:122\n112#1:123,2\n*E\n"})
public final class NestJSIndexingHandler
extends FrameworkIndexingHandler {
    @NotNull
    public List<String> getMarkers(@NotNull PsiElement elementToIndex) {
        Intrinsics.checkNotNullParameter((Object)elementToIndex, (String)"elementToIndex");
        if (this.isNestJSControllerClass(elementToIndex)) {
            return CollectionsKt.listOf((Object)"NESTJS_CONTROLLER_CLASS");
        }
        List list = super.getMarkers(elementToIndex);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMarkers(...)");
        return list;
    }

    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.isMappingDecoratorCall(node);
    }

    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.isDecoratorArgument(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDecoratorArgument(ASTNode literalExpressionNode) {
        ASTNode treeParent;
        ASTNode aSTNode = treeParent = literalExpressionNode.getTreeParent();
        ASTNode aSTNode2 = aSTNode;
        if (aSTNode == null) return false;
        if ((aSTNode2 = aSTNode2.getElementType()) == null) {
            return false;
        }
        ASTNode parentType = aSTNode2;
        if (!Intrinsics.areEqual((Object)parentType, (Object)JSElementTypes.ARGUMENT_LIST)) return false;
        ASTNode aSTNode3 = treeParent.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"getTreeParent(...)");
        if (!this.isMappingDecoratorCall(aSTNode3)) return false;
        return true;
    }

    private final boolean isMappingDecoratorCall(ASTNode callNode) {
        ASTNode aSTNode = callNode.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)JSElementTypes.ES6_DECORATOR) && this.checkCallExpression(callNode, (Function2<? super String, ? super Boolean, Boolean>)((Function2)(arg_0, arg_1) -> NestJSIndexingHandler.isMappingDecoratorCall$lambda$0(this, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMappingDecorator(String referenceName) {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual((Object)referenceName, (Object)"Controller")) return true;
        Iterable $this$map$iv = (Iterable)NestJSMethodDecorator.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NestJSMethodDecorator nestJSMethodDecorator = (NestJSMethodDecorator)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDecoratorName());
        }
        if (!((List)destination$iv$iv).contains(referenceName)) return false;
        return true;
    }

    private final boolean checkCallExpression(ASTNode callNode, Function2<? super String, ? super Boolean, Boolean> check) {
        if (!Intrinsics.areEqual((Object)callNode.getElementType(), (Object)JSElementTypes.CALL_EXPRESSION)) {
            return false;
        }
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression((ASTNode)callNode);
        if (methodExpression == null || !Intrinsics.areEqual((Object)methodExpression.getElementType(), (Object)JSElementTypes.REFERENCE_EXPRESSION)) {
            return false;
        }
        String string = JSReferenceExpressionImpl.getReferenceName((ASTNode)methodExpression);
        if (string == null) {
            return false;
        }
        String referenceName = string;
        boolean hasQualifier = JSReferenceExpressionImpl.getQualifierNode((ASTNode)methodExpression) != null;
        return (Boolean)check.invoke((Object)referenceName, (Object)hasQualifier);
    }

    private final boolean isNestJSControllerClass(PsiElement psiElement) {
        boolean bl;
        JSClass jSClass;
        PsiElement $this$asSafely$iv = psiElement;
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof TypeScriptClass)) {
            psiElement2 = null;
        }
        TypeScriptClass typeScriptClass = (TypeScriptClass)psiElement2;
        if (typeScriptClass != null) {
            jSClass = (JSClass)typeScriptClass;
        } else {
            PsiElement $this$asSafely$iv2 = psiElement;
            boolean $i$f$asSafely2 = false;
            PsiElement psiElement3 = $this$asSafely$iv2;
            if (!(psiElement3 instanceof ES6Class)) {
                psiElement3 = null;
            }
            ES6Class eS6Class = (ES6Class)psiElement3;
            if (eS6Class != null) {
                jSClass = (JSClass)eS6Class;
            } else {
                return false;
            }
        }
        JSClass jsClass = jSClass;
        ES6Decorator[] eS6DecoratorArray = jsClass.getAttributeList();
        if (eS6DecoratorArray != null && (eS6DecoratorArray = eS6DecoratorArray.getDecorators()) != null) {
            boolean bl2;
            block9: {
                ES6Decorator[] $this$any$iv = eS6DecoratorArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ES6Decorator element$iv;
                    ES6Decorator it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getDecoratorName(), (Object)"Controller")) continue;
                    bl2 = true;
                    break block9;
                }
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isMappingDecoratorCall$lambda$0(NestJSIndexingHandler this$0, String refName, boolean hasQualifier) {
        Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
        return !hasQualifier && this$0.isMappingDecorator(refName);
    }
}

