/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jpa.jpb.model.db;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.javaee.jpa.jpb.model.db.IdeaDataStore;
import com.intellij.javaee.jpa.jpb.model.db.util.DataSourceDependentCacheManager;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javaee/jpa/jpb/model/db/DataStoreUtils;", "", "<init>", "()V", "Companion", "intellij.javaee.jpa.jpb.model.db"})
public final class DataStoreUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\rJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/javaee/jpa/jpb/model/db/DataStoreUtils$Companion;", "", "<init>", "()V", "createReverseEngineeringDataStores", "", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "supportedTypes", "", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "myCreateReverseEngineeringDataStores", "createDataStore", "Lcom/intellij/javaee/jpa/jpb/model/db/IdeaDataStore;", "myCreateDataStore", "createDataStores", "createLocalDataSource", "dbType", "findDatabaseDriver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "getIdeaDriverId", "", "getDataSourcePassword", "Lcom/intellij/credentialStore/OneTimeString;", "info", "Lcom/intellij/database/model/DasDataSource;", "getDefaultSchemaName", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "intellij.javaee.jpa.jpb.model.db"})
    @SourceDebugExtension(value={"SMAP\nDataStoreUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStoreUtils.kt\ncom/intellij/javaee/jpa/jpb/model/db/DataStoreUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1642#2,10:216\n1915#2:226\n1916#2:228\n1652#2:229\n2792#2,2:230\n2794#2:233\n1#3:227\n1#3:232\n*S KotlinDebug\n*F\n+ 1 DataStoreUtils.kt\ncom/intellij/javaee/jpa/jpb/model/db/DataStoreUtils$Companion\n*L\n48#1:216,10\n48#1:226\n48#1:228\n48#1:229\n89#1:230,2\n89#1:233\n48#1:227\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DataStore> createReverseEngineeringDataStores(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Set<? extends DbType> supportedTypes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter(supportedTypes, (String)"supportedTypes");
            String cacheKey = "reDataStores_" + dataSource.getUniqueId() + CollectionsKt.joinToString$default((Iterable)supportedTypes, (CharSequence)"_", (CharSequence)"_", null, (int)0, null, null, (int)60, null);
            return (List)DataSourceDependentCacheManager.Companion.getInstance(project).getCachedValue(cacheKey, dataSource, () -> Companion.createReverseEngineeringDataStores$lambda$0(project, dataSource, supportedTypes));
        }

        /*
         * WARNING - void declaration
         */
        private final List<DataStore> myCreateReverseEngineeringDataStores(Project project, LocalDataSource dataSource, Set<? extends DbType> supportedTypes) {
            Object schemaName;
            IdeaDataStore ideaDataStore = this.createDataStore(project, dataSource, supportedTypes);
            if (ideaDataStore == null) {
                return CollectionsKt.emptyList();
            }
            IdeaDataStore mainDataStore = ideaDataStore;
            Object[] objectArray = new DataStore[]{mainDataStore};
            List allStores = CollectionsKt.mutableListOf((Object[])objectArray);
            JBIterable jBIterable = ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((DasDataSource)((DasDataSource)dataSource)).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(DasNamespace.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable dbSchemas = jBIterable;
            if (dbSchemas.size() == 1) {
                Object object = dbSchemas.first();
                Intrinsics.checkNotNull((Object)object);
                String string = ((DasNamespace)object).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                schemaName = string;
                DbProperties dbProperties = mainDataStore.getDbProperties();
                Intrinsics.checkNotNullExpressionValue((Object)dbProperties, (String)"getDbProperties(...)");
                if (!StringsKt.equals((String)this.getDefaultSchemaName(dbProperties), (String)schemaName, (boolean)true)) {
                    mainDataStore.setImplicitSchemaName((String)schemaName);
                }
            }
            if (dbSchemas.size() > 1) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                schemaName = (Iterable)dbSchemas;
                List list = allStores;
                boolean $i$f$mapNotNull = false;
                void var9_10 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    DbProperties additionalDbProperties;
                    String schemaName2;
                    String ideaDbName;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    DasNamespace ideaSchema = (DasNamespace)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)ideaSchema.getName(), (String)"getName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)DasUtil.getCatalog((DasObject)((DasObject)ideaSchema)), (String)"getCatalog(...)");
                    String dsUniqueId = mainDataStore.getDsUniqueId();
                    String dbAndSchemaNameSuffix = (String)(StringsKt.isBlank((CharSequence)ideaDbName) ? "" : "_" + ideaDbName) + "_" + schemaName2;
                    IdeaDataStore schemaDataStore = new IdeaDataStore(project, dsUniqueId + "_" + dbAndSchemaNameSuffix, mainDataStore.getName() + "_" + dbAndSchemaNameSuffix);
                    DbProperties mainDbProperties = mainDataStore.getDbProperties();
                    String string = mainDbProperties.getUrl();
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNullExpressionValue((Object)DbProperties.create((String)string, (DbType)mainDbProperties.getType()), (String)"create(...)");
                    additionalDbProperties.addParameter("currentSchema", schemaName2);
                    schemaDataStore.setDbProperties(additionalDbProperties.setUser(mainDbProperties.getUser()).setPasswordProvider(mainDbProperties.getPasswordProvider()));
                    schemaDataStore.setCustomSchemaName(schemaName2);
                    schemaDataStore.setDsUniqueId(dsUniqueId);
                    if (((CharSequence)ideaDbName).length() > 0) {
                        schemaDataStore.setIdeaDbName(ideaDbName);
                    }
                    IdeaDataStore it$iv$iv = schemaDataStore;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list.addAll((List)destination$iv$iv);
            }
            return allStores;
        }

        @Nullable
        public final IdeaDataStore createDataStore(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Set<? extends DbType> supportedTypes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter(supportedTypes, (String)"supportedTypes");
            String cacheKey = "dataStore_" + dataSource.getUniqueId() + CollectionsKt.joinToString$default((Iterable)supportedTypes, (CharSequence)"_", (CharSequence)"_", null, (int)0, null, null, (int)60, null);
            return (IdeaDataStore)((Object)DataSourceDependentCacheManager.Companion.getInstance(project).getCachedValue(cacheKey, dataSource, () -> Companion.createDataStore$lambda$0(project, dataSource, supportedTypes)));
        }

        private final IdeaDataStore myCreateDataStore(Project project, LocalDataSource dataSource, Set<? extends DbType> supportedTypes) {
            String string;
            block16: {
                Object object;
                block15: {
                    if (!((Collection)supportedTypes).isEmpty()) {
                        boolean unsupportedDbType;
                        block14: {
                            Iterable $this$none$iv = supportedTypes;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                v0 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    boolean bl;
                                    DbType dbType = (DbType)element$iv;
                                    boolean bl2 = false;
                                    if (dbType.getUrlPrefix() != null) {
                                        String it;
                                        boolean bl3 = false;
                                        String string2 = dataSource.getUrl();
                                        bl = Intrinsics.areEqual((Object)(string2 != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string2, (String)it, (boolean)false, (int)2, null)) : null), (Object)true);
                                    } else {
                                        bl = false;
                                    }
                                    if (!(bl || Intrinsics.areEqual((Object)dbType.getDriverClass(), (Object)dataSource.getDriverClass()))) continue;
                                    v0 = false;
                                    break block14;
                                }
                                v0 = unsupportedDbType = true;
                            }
                        }
                        if (unsupportedDbType) {
                            return null;
                        }
                    }
                    if ((string = dataSource.getUrl()) == null) break block15;
                    String it = string;
                    boolean bl = false;
                    DbProperties dbProperties = DbProperties.create((String)it, (String)dataSource.getUrl());
                    string = dbProperties;
                    if (dbProperties != null) break block16;
                }
                String string3 = dataSource.getDriverClass();
                if (string3 != null) {
                    String it = string3;
                    boolean bl = false;
                    object = DbProperties.createFromDriverClass((String)it);
                } else {
                    object = string = null;
                }
                if (object == null) {
                    return null;
                }
            }
            String dbProperties = string;
            String string4 = dataSource.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUniqueId(...)");
            String dsUniqueId = string4;
            String string5 = dataSource.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            String dsName = string5;
            IdeaDataStore mainDataStore = new IdeaDataStore(project, dsUniqueId, dsName);
            mainDataStore.setImported(dataSource.isImported());
            mainDataStore.setDbProperties(dbProperties.setUser(dataSource.getUsername()).setPasswordProvider(() -> Companion.myCreateDataStore$lambda$3(dataSource)));
            return mainDataStore;
        }

        @NotNull
        public final List<DataStore> createDataStores(@NotNull Project project, @NotNull LocalDataSource dataSource) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            IdeaDataStore ideaDataStore = this.createDataStore(project, dataSource, JpaOrmFramework.INSTANCE.getSupportedDbTypes());
            if (ideaDataStore == null) {
                return CollectionsKt.emptyList();
            }
            IdeaDataStore mainDataStore = ideaDataStore;
            DbProperties dbProperties = mainDataStore.getDbProperties();
            Intrinsics.checkNotNullExpressionValue((Object)dbProperties, (String)"getDbProperties(...)");
            DbProperties dbProperties2 = dbProperties;
            String string = dbProperties2.getUrl();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String dsUrl = string;
            String dsUniqueId = mainDataStore.getDsUniqueId();
            String dsName = mainDataStore.getName();
            Supplier passwordProvider = dbProperties2.getPasswordProvider();
            Object[] objectArray = new DataStore[]{mainDataStore};
            List allStores = CollectionsKt.mutableListOf((Object[])objectArray);
            DbType dbType = dbProperties2.getType();
            if (Intrinsics.areEqual((Object)dbType, (Object)DbType.POSTGRES) && ((charSequence = (CharSequence)dbProperties2.getCurrentSchema()) == null || StringsKt.isBlank((CharSequence)charSequence)) && dbType.getStartSeparator() != null) {
                List list = ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((DasDataSource)((DasDataSource)dataSource)).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(DasNamespace.class).filter(arg_0 -> Companion.createDataStores$lambda$1(arg_0 -> Companion.createDataStores$lambda$0(dbProperties2, arg_0), arg_0)).toList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
                List additionalDbSchemas = list;
                for (DasNamespace dbSchema : additionalDbSchemas) {
                    String schemaName;
                    DbProperties additionalDbProperties;
                    Intrinsics.checkNotNullExpressionValue((Object)DbProperties.create((String)dsUrl, (DbType)dbProperties2.getType()), (String)"create(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)dbSchema.getName(), (String)"getName(...)");
                    additionalDbProperties.addParameter("currentSchema", schemaName);
                    IdeaDataStore additionalDataStore = new IdeaDataStore(project, dsUniqueId + "_" + schemaName, dsName + "_" + schemaName);
                    additionalDataStore.setCustomSchemaName(schemaName);
                    additionalDataStore.setDsUniqueId(dsUniqueId);
                    additionalDataStore.setDbProperties(additionalDbProperties.setUser(dataSource.getUsername()).setPasswordProvider(passwordProvider));
                    additionalDataStore.setImported(dataSource.isImported());
                    allStores.add(additionalDataStore);
                }
            }
            return allStores;
        }

        @NotNull
        public final LocalDataSource createLocalDataSource(@NotNull DbType dbType) {
            Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
            DatabaseDriver databaseDriver = this.findDatabaseDriver(dbType);
            if (databaseDriver == null) {
                throw new IllegalStateException("Database driver '" + dbType.getDriverClass() + "' not found");
            }
            DatabaseDriver databaseDriver2 = databaseDriver;
            LocalDataSource localDataSource = databaseDriver2.createDataSource(null);
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"createDataSource(...)");
            return localDataSource;
        }

        private final DatabaseDriver findDatabaseDriver(DbType dbType) {
            Object v1;
            block1: {
                Collection collection = DatabaseDriverManager.getInstance().getDrivers();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrivers(...)");
                Iterable iterable = collection;
                for (Object t : iterable) {
                    DatabaseDriver it = (DatabaseDriver)t;
                    boolean bl = false;
                    String ideaDriverId = Companion.getIdeaDriverId(dbType);
                    if (!(ideaDriverId != null ? Intrinsics.areEqual((Object)it.getId(), (Object)ideaDriverId) : Intrinsics.areEqual((Object)it.getDriverClass(), (Object)dbType.getDriverClass()))) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private final String getIdeaDriverId(DbType dbType) {
            DbType dbType2 = dbType;
            return Intrinsics.areEqual((Object)dbType2, (Object)DbType.MSSQL) ? "sqlserver.ms" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MSSQL_JTDS) ? "sqlserver.jtds" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MYSQL) ? "mysql.8" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MYSQL_51) ? "mysql" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL_INMEMORY) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL_FILE) ? "hsqldb.local" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MARIA) ? "mariadb" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.H2) ? "h2.unified" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.POSTGRES) ? "postgresql" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.ORACLE) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.ORACLE_SID) ? "oracle" : (Intrinsics.areEqual((Object)dbType2, (Object)DbType.DB2) ? "db2.11" : null)))))))));
        }

        @Nullable
        public final OneTimeString getDataSourcePassword(@NotNull DasDataSource info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return info instanceof LocalDataSource ? DatabaseCredentials.loadPassword$default((DatabaseCredentials)DatabaseCredentials.Companion.getInstance(), (DatabaseConnectionPoint)((DatabaseConnectionPoint)info), null, (int)2, null) : null;
        }

        @NotNull
        public final String getDefaultSchemaName(@NotNull DbProperties dbProperties) {
            String string;
            Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
            DbType dbType = dbProperties.getType();
            Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
            DbType dbType2 = DbType.Companion.getMainType(dbType);
            if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MYSQL) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.MARIA)) {
                String string2 = dbProperties.getDatabaseName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDatabaseName(...)");
            } else if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.ORACLE) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.ORACLE_SID)) {
                String string3 = dbProperties.getUser();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUser(...)");
            } else if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.DB2)) {
                String string4 = dbProperties.getUser();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUser(...)");
                String string5 = string4.toUpperCase(Locale.ROOT);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            } else {
                string = Intrinsics.areEqual((Object)dbType2, (Object)DbType.MSSQL) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.MSSQL_JTDS) ? "dbo" : "public";
            }
            return string;
        }

        private static final List createReverseEngineeringDataStores$lambda$0(Project $project, LocalDataSource $dataSource, Set $supportedTypes) {
            return Companion.myCreateReverseEngineeringDataStores($project, $dataSource, $supportedTypes);
        }

        private static final IdeaDataStore createDataStore$lambda$0(Project $project, LocalDataSource $dataSource, Set $supportedTypes) {
            return Companion.myCreateDataStore($project, $dataSource, $supportedTypes);
        }

        private static final String myCreateDataStore$lambda$3(LocalDataSource $dataSource) {
            OneTimeString oneTimeString = Companion.getDataSourcePassword((DasDataSource)$dataSource);
            return oneTimeString != null ? oneTimeString.toString() : null;
        }

        private static final boolean createDataStores$lambda$0(DbProperties $dbProperties, DasNamespace dasNamespace) {
            DasObject dasParent = dasNamespace.getDasParent();
            BasicMateDatabase basicMateDatabase = dasParent instanceof BasicMateDatabase ? (BasicMateDatabase)dasParent : null;
            if (basicMateDatabase == null) {
                return false;
            }
            BasicMateDatabase ownerDatabase = basicMateDatabase;
            return StringsKt.equals((String)ownerDatabase.getName(), (String)$dbProperties.getDatabaseName(), (boolean)true) && !Intrinsics.areEqual((Object)ModelFun.getCurrentSchema((BasicDatabase)((BasicDatabase)ownerDatabase)), (Object)dasNamespace);
        }

        private static final boolean createDataStores$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

