/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseEvent;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseIndex;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseModelHelperKt;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoutine;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTable;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseUser;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrantController;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J\b\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0016J4\u0010&\u001a\u00020\u0018\"\b\b\u0000\u0010'*\u00020(2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H'0\u00162\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0+0*H\u0016\u00a8\u0006,"}, d2={"Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "getCustomName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/Nullable;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "", "getIcon", "Ljavax/swing/Icon;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "getVariant", "c", "Lcom/intellij/database/model/DasObject;", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "vars", "", "modifyParent", "setDefaultTriggerTurn", "Lcom/intellij/database/model/basic/BasicModTrigger;", "getGrantController", "Lcom/intellij/database/dialects/mysqlbase/model/properties/MysqlObjectGrantController;", "handleJdbcComment", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "comment", "reorderProperties", "E", "Lcom/intellij/database/model/basic/BasicElement;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "intellij.database.dialects.mysqlbase"})
@SourceDebugExtension(value={"SMAP\nMysqlBaseModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseModelHelper.kt\ncom/intellij/database/dialects/mysqlbase/model/MysqlBaseModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,83:1\n18#2:84\n*S KotlinDebug\n*F\n+ 1 MysqlBaseModelHelper.kt\ncom/intellij/database/dialects/mysqlbase/model/MysqlBaseModelHelper\n*L\n24#1:84\n*E\n"})
public class MysqlBaseModelHelper
extends ModelHelper {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEDULED_EVENT)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message((String)"CustomObjectKind.event", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ModelHelper.ObjectKindVariant variant) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (Intrinsics.areEqual((Object)variant, (Object)MysqlBaseModelHelperKt.access$getROLE$p())) {
            return this.getIcon(ObjectKind.ROLE);
        }
        return super.getIcon(kind, variant);
    }

    @NotNull
    public ModelHelper.ObjectKindVariant getVariant(@NotNull DasObject c) {
        ModelHelper.ObjectKindVariant objectKindVariant;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (c instanceof MysqlBaseUser && !((MysqlBaseUser)c).isCanLogin()) {
            objectKindVariant = MysqlBaseModelHelperKt.access$getROLE$p();
        } else {
            ModelHelper.ObjectKindVariant objectKindVariant2 = super.getVariant(c);
            objectKindVariant = objectKindVariant2;
            Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant2, (String)"getVariant(...)");
        }
        return objectKindVariant;
    }

    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        if (Intrinsics.areEqual((Object)meta.kind, (Object)ObjectKind.USER)) {
            JBIterable jBIterable2 = super.generationVariants(meta).append((Object)MysqlBaseModelHelperKt.access$getROLE$p());
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"append(...)");
        } else {
            JBIterable jBIterable3 = super.generationVariants(meta);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        if (e instanceof MysqlBaseUser) {
            ((MysqlBaseUser)e).setCanLogin(!Intrinsics.areEqual((Object)variant, (Object)MysqlBaseModelHelperKt.access$getROLE$p()));
        }
        if (e instanceof MysqlBaseRoutine && ((MysqlBaseRoutine)e).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
            vars.put("args", "IN " + vars.get("args"));
        }
        if (e instanceof MysqlBaseEvent) {
            ((MysqlBaseEvent)e).setInterval("1 hour");
            vars.put("schedule", "every 1 hour");
        }
    }

    protected void setDefaultTriggerTurn(@NotNull BasicModTrigger e, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        e.setTurn(TrigTurn.AFTER_ROW);
        vars.put("turn", "after");
    }

    @NotNull
    public MysqlObjectGrantController getGrantController() {
        return MysqlObjectGrantController.INSTANCE;
    }

    @Nullable
    public String handleJdbcComment(@NotNull BasicModNamedElement obj, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (Intrinsics.areEqual((Object)obj.getKind(), (Object)ObjectKind.VIEW) && Intrinsics.areEqual((Object)"VIEW", (Object)comment)) {
            return null;
        }
        return super.handleJdbcComment(obj, comment);
    }

    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (Intrinsics.areEqual((Object)meta.kind, (Object)ObjectKind.USER)) {
            BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{MysqlBaseUser.HOST, MysqlBaseUser.CAN_LOGIN, MysqlBaseUser.PLUGIN, MysqlBaseUser.PASSWORD};
            ModelHelper.moveTo(fields, (int)1, (BasicMetaId[])basicMetaIdArray);
        }
        if (Intrinsics.areEqual((Object)meta.kind, (Object)ObjectKind.TABLE)) {
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)MysqlBaseTable.ENGINE)) + 1), (BasicMetaId)((BasicMetaId)MysqlBaseTable.COLLATION_REF));
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)MysqlBaseTable.PARTITION_METHOD)) + 1), (BasicMetaId)((BasicMetaId)MysqlBaseTable.PARTITION_EXPRESSION));
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)MysqlBaseTable.SUBPARTITION_METHOD)) + 1), (BasicMetaId)((BasicMetaId)MysqlBaseTable.SUBPARTITION_EXPRESSION));
        }
        if (Intrinsics.areEqual((Object)meta.kind, (Object)ObjectKind.INDEX)) {
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)MysqlBaseIndex.UNIQUE)) + 1), (BasicMetaId)((BasicMetaId)MysqlBaseIndex.TYPE));
        }
    }
}

