/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.claude.hooks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.util.system.OS;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lcom/intellij/code/provenance/core/claude/hooks/ClaudeJsonUtil;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "postToolJson", "Lcom/google/gson/JsonArray;", "getPostToolJson", "()Lcom/google/gson/JsonArray;", "postToolJson$delegate", "Lkotlin/Lazy;", "buildHook", "", "hookName", "buildHook$intellij_code_provenance_core_claude", "hasPostToolUse", "", "settingsFile", "Ljava/nio/file/Path;", "hasValidHooksConfiguration", "updateSettingsWithHooks", "", "parseJsonFile", "Lcom/google/gson/JsonObject;", "file", "writeJsonFile", "jsonObject", "isValidHookArray", "hookArray", "isValidCommandHook", "hook", "Lcom/google/gson/JsonElement;", "createToolCall", "intellij.code.provenance.core.claude"})
public final class ClaudeJsonUtil {
    @NotNull
    public static final ClaudeJsonUtil INSTANCE = new ClaudeJsonUtil();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @NotNull
    private static final Lazy postToolJson$delegate = LazyKt.lazy(ClaudeJsonUtil::postToolJson_delegate$lambda$0);

    private ClaudeJsonUtil() {
    }

    private final JsonArray getPostToolJson() {
        Lazy lazy = postToolJson$delegate;
        return (JsonArray)lazy.getValue();
    }

    @NotNull
    public final String buildHook$intellij_code_provenance_core_claude(@NotNull String hookName) {
        Intrinsics.checkNotNullParameter((Object)hookName, (String)"hookName");
        return OS.CURRENT == OS.Windows ? "python3 \"%CLAUDE_PROJECT_DIR%/.claude/hooks/" + hookName + "\"" : "python3 \"$CLAUDE_PROJECT_DIR\"/.claude/hooks/" + hookName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasPostToolUse(@NotNull Path settingsFile) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        try {
            JsonObject jsonObject = this.parseJsonFile(settingsFile);
            JsonObject hooks = jsonObject.getAsJsonObject("hooks");
            if (hooks == null) return false;
            if (!hooks.has("PostToolUse")) return false;
            JsonArray jsonArray = hooks.getAsJsonArray("PostToolUse");
            if (jsonArray == null) {
                jsonArray = new JsonArray();
            }
            if (this.isValidHookArray(jsonArray)) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final boolean hasValidHooksConfiguration(@NotNull Path settingsFile) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        try {
            JsonObject jsonObject = this.parseJsonFile(settingsFile);
            JsonObject jsonObject2 = jsonObject.getAsJsonObject("hooks");
            if (jsonObject2 == null) {
                return false;
            }
            JsonObject hooks = jsonObject2;
            JsonArray postToolUse = hooks.getAsJsonArray("PostToolUse");
            return postToolUse != null && this.isValidHookArray(postToolUse);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final void updateSettingsWithHooks(@NotNull Path settingsFile) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        JsonObject jsonObject = Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? this.parseJsonFile(settingsFile) : new JsonObject();
        JsonObject hooksObject = new JsonObject();
        hooksObject.add("PostToolUse", (JsonElement)this.getPostToolJson());
        jsonObject.add("hooks", (JsonElement)hooksObject);
        this.writeJsonFile(settingsFile, jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject parseJsonFile(Path file) {
        Object object = file;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2);
        object2 = null;
        try {
            JsonObject jsonObject;
            InputStreamReader reader = (InputStreamReader)object;
            boolean bl = false;
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element.isJsonObject()) {
                JsonObject jsonObject2 = element.getAsJsonObject();
                Intrinsics.checkNotNull((Object)jsonObject2);
                jsonObject = jsonObject2;
            } else {
                jsonObject = new JsonObject();
            }
            JsonObject jsonObject3 = jsonObject;
            return jsonObject3;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeJsonFile(Path file, JsonObject jsonObject) {
        Path path = file.getParent();
        if (path != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            v3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
        } else {
            v3 = null;
        }
        Object object = file;
        Unit unit = new Unit[]{};
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(unit, ((OpenOption[])unit).length)), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            gson.toJson((JsonElement)jsonObject, (Appendable)writer);
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidHookArray(JsonArray hookArray) {
        if (hookArray.size() != 1) {
            return false;
        }
        JsonElement hookEntry = hookArray.get(0);
        if (!hookEntry.isJsonObject()) {
            return false;
        }
        JsonObject hookObject = hookEntry.getAsJsonObject();
        JsonPrimitive matcher = hookObject.getAsJsonPrimitive("matcher");
        JsonArray hooks = hookObject.getAsJsonArray("hooks");
        JsonPrimitive jsonPrimitive = matcher;
        if (!Intrinsics.areEqual((Object)(jsonPrimitive != null ? jsonPrimitive.getAsString() : null), (Object)"Write|Edit|MultiEdit|NotebookEdit")) return false;
        if (hooks == null) return false;
        if (hooks.size() != 1) return false;
        JsonElement jsonElement = hooks.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
        if (!this.isValidCommandHook(jsonElement)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidCommandHook(JsonElement hook) {
        if (!hook.isJsonObject()) {
            return false;
        }
        JsonObject hookObject = hook.getAsJsonObject();
        JsonPrimitive type = hookObject.getAsJsonPrimitive("type");
        JsonPrimitive command = hookObject.getAsJsonPrimitive("command");
        JsonPrimitive jsonPrimitive = type;
        if (!Intrinsics.areEqual((Object)(jsonPrimitive != null ? jsonPrimitive.getAsString() : null), (Object)"command")) return false;
        JsonPrimitive jsonPrimitive2 = command;
        Object object = jsonPrimitive2;
        if (jsonPrimitive2 == null) return false;
        String string = object.toString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"post-tool-call.py", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final JsonArray createToolCall(String hookName) {
        JsonArray hookArray = new JsonArray();
        JsonObject hookEntry = new JsonObject();
        hookEntry.addProperty("matcher", "Write|Edit|MultiEdit|NotebookEdit");
        JsonArray hooksArray = new JsonArray();
        JsonObject commandHook = new JsonObject();
        commandHook.addProperty("type", "command");
        commandHook.addProperty("command", this.buildHook$intellij_code_provenance_core_claude(hookName));
        hooksArray.add((JsonElement)commandHook);
        hookEntry.add("hooks", (JsonElement)hooksArray);
        hookArray.add((JsonElement)hookEntry);
        return hookArray;
    }

    private static final JsonArray postToolJson_delegate$lambda$0() {
        return INSTANCE.createToolCall("post-tool-call.py");
    }
}

