/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.inspections;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.ProxyParamTuner;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.RemoteProcessInitializer;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dialects.mongo.MongoUtils;
import com.intellij.database.remote.jdbc.RemoteProcessController;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.sql.dialects.mongo.js.inspections.MongoSrvSshHandlerKt;
import com.intellij.util.net.ProxyCredentialStore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoSrvSshHandler;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "Lcom/intellij/database/dataSource/RemoteProcessInitializer;", "<init>", "()V", "tuneParams", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "initProcess", "controller", "Lcom/intellij/database/remote/jdbc/RemoteProcessController;", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "(Lcom/intellij/database/remote/jdbc/RemoteProcessController;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.dialects.mongo.ex"})
final class MongoSrvSshHandler
extends RemoteProcessInitializer
implements ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!MongoSrvSshHandler.Companion.shouldProcess(dataSource)) {
            return;
        }
        HostPort proxyServerHostPort = JdbcDriverManager.getDriverManager((Project)project).createProxyServer(dataSource);
        ParametersList parametersList = params.getVMParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"getVMParametersList(...)");
        ParametersList vmParams = parametersList;
        vmParams.addProperty("socksProxyHost", proxyServerHostPort.getHost());
        vmParams.addProperty("socksProxyPort", proxyServerHostPort.getPort());
        for (Pair opt : DatabaseCoreUiService.getInstance().getNonProxyOptions(ProxyParamTuner.Companion.getNON_PROXY())) {
            params.getVMParametersList().addProperty((String)opt.first, (String)opt.second);
        }
    }

    @Nullable
    public Object initProcess(@NotNull RemoteProcessController controller, @NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        String userName;
        Credentials credentials;
        if (!MongoSrvSshHandler.Companion.shouldProcess(dataSource)) {
            return Unit.INSTANCE;
        }
        HostPort proxyServerHostPort = JdbcDriverManager.getDriverManager((Project)project).createProxyServer(dataSource);
        ProxyCredentialStore proxyCredentialStore = ProxyCredentialStore.Companion.getInstance();
        String string = proxyServerHostPort.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String string2 = proxyServerHostPort.getPort();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPort(...)");
        Credentials credentials2 = credentials = proxyCredentialStore.getCredentials(string, Integer.parseInt(string2));
        OneTimeString password = credentials2 != null ? credentials2.getPassword() : null;
        Credentials credentials3 = credentials;
        String string3 = userName = credentials3 != null ? credentials3.getUserName() : null;
        if (credentials == null || userName == null || password == null) {
            MongoSrvSshHandlerKt.access$getLOG$p().error("No credentials for the proxy server");
            throw new IllegalStateException(DatabaseBundle.message((String)"failed.to.get.proxy.credentials", (Object[])new Object[0]));
        }
        controller.setAuthenticatorPassword(userName, password.getChars());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoSrvSshHandler$Companion;", "", "<init>", "()V", "shouldProcess", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.dialects.mongo.ex"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean shouldProcess(LocalDataSource dataSource) {
            DataSourceSshTunnelConfiguration sshConfig = dataSource.getSshConfiguration();
            return sshConfig != null && sshConfig.isEnabled() && MongoUtils.Companion.isMongoDBSRV(dataSource.getUrl());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

