/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.RememberCheckBoxState;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.UpdatePasswordKt;
import org.jetbrains.idea.perforce.perforce.login.AttemptsStateMachine;
import org.jetbrains.idea.perforce.perforce.login.LoginState;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a,\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"askUpdatePassword", "", "project", "Lcom/intellij/openapi/project/Project;", "attemptsMachine", "Lorg/jetbrains/idea/perforce/perforce/login/AttemptsStateMachine;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "changePassUnderProgress", "Lorg/jetbrains/idea/perforce/perforce/login/LoginState;", "machine", "oldPass", "", "newPassword", "intellij.vcs.perforce"})
public final class UpdatePasswordKt {
    public static final boolean askUpdatePassword(@NotNull Project project, @NotNull AttemptsStateMachine attemptsMachine, @NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attemptsMachine, (String)"attemptsMachine");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> UpdatePasswordKt.askUpdatePassword$lambda$0(project, attemptsMachine, attributes), (int)1, null);
    }

    private static final LoginState changePassUnderProgress(Project project, AttemptsStateMachine machine, String oldPass, String newPassword) {
        Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> UpdatePasswordKt.changePassUnderProgress$lambda$0(machine, oldPass, newPassword), PerforceBundle.message("login.password.update.title", new Object[0]), true, project);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
        return (LoginState)object;
    }

    private static final boolean askUpdatePassword$lambda$0(Project $project, AttemptsStateMachine $attemptsMachine, CredentialAttributes $attributes) {
        DialogWrapper dialog2 = new DialogWrapper($project, $attemptsMachine, $attributes){
            public JBPasswordField myOldPasswordField;
            public JBPasswordField myNewPasswordField;
            public JBPasswordField myRepeatNewPasswordField;
            public JCheckBox myRememberCheckbox;
            public JEditorPane myErrorLabel;
            final /* synthetic */ Project $project;
            final /* synthetic */ AttemptsStateMachine $attemptsMachine;
            final /* synthetic */ CredentialAttributes $attributes;
            {
                this.$project = $project;
                this.$attemptsMachine = $attemptsMachine;
                this.$attributes = $attributes;
                super($project);
                this.setTitle(PerforceBundle.message("login.password.update.title", new Object[0]));
                this.init();
            }

            public final JBPasswordField getMyOldPasswordField() {
                JBPasswordField jBPasswordField = this.myOldPasswordField;
                if (jBPasswordField != null) {
                    return jBPasswordField;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"myOldPasswordField");
                return null;
            }

            public final void setMyOldPasswordField(JBPasswordField jBPasswordField) {
                Intrinsics.checkNotNullParameter((Object)jBPasswordField, (String)"<set-?>");
                this.myOldPasswordField = jBPasswordField;
            }

            public final JBPasswordField getMyNewPasswordField() {
                JBPasswordField jBPasswordField = this.myNewPasswordField;
                if (jBPasswordField != null) {
                    return jBPasswordField;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"myNewPasswordField");
                return null;
            }

            public final void setMyNewPasswordField(JBPasswordField jBPasswordField) {
                Intrinsics.checkNotNullParameter((Object)jBPasswordField, (String)"<set-?>");
                this.myNewPasswordField = jBPasswordField;
            }

            public final JBPasswordField getMyRepeatNewPasswordField() {
                JBPasswordField jBPasswordField = this.myRepeatNewPasswordField;
                if (jBPasswordField != null) {
                    return jBPasswordField;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRepeatNewPasswordField");
                return null;
            }

            public final void setMyRepeatNewPasswordField(JBPasswordField jBPasswordField) {
                Intrinsics.checkNotNullParameter((Object)jBPasswordField, (String)"<set-?>");
                this.myRepeatNewPasswordField = jBPasswordField;
            }

            public final JCheckBox getMyRememberCheckbox() {
                JCheckBox jCheckBox = this.myRememberCheckbox;
                if (jCheckBox != null) {
                    return jCheckBox;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRememberCheckbox");
                return null;
            }

            public final void setMyRememberCheckbox(JCheckBox jCheckBox) {
                Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"<set-?>");
                this.myRememberCheckbox = jCheckBox;
            }

            public final JEditorPane getMyErrorLabel() {
                JEditorPane jEditorPane = this.myErrorLabel;
                if (jEditorPane != null) {
                    return jEditorPane;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"myErrorLabel");
                return null;
            }

            public final void setMyErrorLabel(JEditorPane jEditorPane) {
                Intrinsics.checkNotNullParameter((Object)jEditorPane, (String)"<set-?>");
                this.myErrorLabel = jEditorPane;
            }

            protected JComponent createCenterPanel() {
                this.setMyRememberCheckbox(RememberCheckBoxState.INSTANCE.createCheckBox(PerforceBundle.message("login.password.remember.tooltip", new Object[0])));
                return (JComponent)BuilderKt.panel(arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0(this, arg_0));
            }

            protected ValidationInfo doValidate() {
                if (!Arrays.equals(this.getMyNewPasswordField().getPassword(), this.getMyRepeatNewPasswordField().getPassword())) {
                    return new ValidationInfo(PerforceBundle.message("login.password.passwords.not.match.error", new Object[0]), (JComponent)this.getMyRepeatNewPasswordField());
                }
                if (Arrays.equals(this.getMyOldPasswordField().getPassword(), this.getMyNewPasswordField().getPassword())) {
                    return new ValidationInfo(PerforceBundle.message("login.password.password.not.changed.error", new Object[0]), (JComponent)this.getMyOldPasswordField());
                }
                return super.doValidate();
            }

            public JComponent getPreferredFocusedComponent() {
                return (JComponent)this.getMyOldPasswordField();
            }

            protected void doOKAction() {
                Pair<String, String> passwords = this.getPasswords();
                LoginState state = UpdatePasswordKt.access$changePassUnderProgress(this.$project, this.$attemptsMachine, (String)passwords.getFirst(), (String)passwords.getSecond());
                if (!state.isSuccess()) {
                    HtmlBuilder builder = new HtmlBuilder();
                    Color color = NamedColorUtil.getErrorForeground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getErrorForeground(...)");
                    Color color2 = color;
                    Object[] objectArray = new Object[]{state.getError()};
                    builder.append((HtmlChunk)HtmlChunk.raw((String)PerforceBundle.message("login.perforce.error", objectArray)).wrapWith("left").wrapWith(HtmlChunk.font((String)ColorUtil.toHex((Color)color2))));
                    this.getMyErrorLabel().setText(builder.toString());
                    this.getMyErrorLabel().setVisible(true);
                    return;
                }
                RememberCheckBoxState.update((JCheckBox)this.getMyRememberCheckbox());
                PasswordSafe store = PasswordSafe.Companion.getInstance();
                Credentials credentials = new Credentials(this.$attributes.getUserName(), CredentialPromptDialog.getTrimmedChars((JPasswordField)((JPasswordField)this.getMyNewPasswordField())));
                if (this.getMyRememberCheckbox().isSelected()) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> askUpdatePassword.1.dialog.1.doOKAction$lambda$1(store, this.$attributes, credentials), this.getTitle(), false, this.$project);
                }
                super.doOKAction();
            }

            private final Pair<String, String> getPasswords() {
                char[] cArray = this.getMyOldPasswordField().getPassword();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
                char[] cArray2 = cArray;
                String string = new String(cArray2);
                char[] cArray3 = this.getMyNewPasswordField().getPassword();
                Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"getPassword(...)");
                cArray2 = cArray3;
                return new Pair((Object)string, (Object)new String(cArray2));
            }

            private static final Unit createCenterPanel$lambda$0$0$0(askUpdatePassword.1.dialog.1 this$0, JBPasswordField it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.initValidation();
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$1$0(askUpdatePassword.1.dialog.1 this$0, JBPasswordField it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.initValidation();
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$2$0(askUpdatePassword.1.dialog.1 this$0, JBPasswordField it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.initValidation();
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$0(askUpdatePassword.1.dialog.1 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                this$0.setMyOldPasswordField((JBPasswordField)$this$row.passwordField().resizableColumn().align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$0$0(this$0, arg_0)).getComponent());
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$1(askUpdatePassword.1.dialog.1 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                this$0.setMyNewPasswordField((JBPasswordField)$this$row.passwordField().resizableColumn().align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$1$0(this$0, arg_0)).getComponent());
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$2(askUpdatePassword.1.dialog.1 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                this$0.setMyRepeatNewPasswordField((JBPasswordField)$this$row.passwordField().resizableColumn().align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$2$0(this$0, arg_0)).getComponent());
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$3(askUpdatePassword.1.dialog.1 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.cell((JComponent)this$0.getMyRememberCheckbox());
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0$4(askUpdatePassword.1.dialog.1 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                this$0.setMyErrorLabel((JEditorPane)Row.comment$default((Row)$this$row, (String)"", (int)0, null, (int)6, null).getComponent());
                return Unit.INSTANCE;
            }

            private static final Unit createCenterPanel$lambda$0(askUpdatePassword.1.dialog.1 this$0, Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = PerforceBundle.message("login.password.old.password", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$0(this$0, arg_0));
                String string2 = PerforceBundle.message("login.password.new.password", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$1(this$0, arg_0));
                String string3 = PerforceBundle.message("login.password.repeat.new.password", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                $this$panel.row(string3, arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$2(this$0, arg_0));
                Panel.row$default((Panel)$this$panel, null, arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$3(this$0, arg_0), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, arg_0 -> askUpdatePassword.1.dialog.1.createCenterPanel$lambda$0$4(this$0, arg_0), (int)1, null);
                return Unit.INSTANCE;
            }

            private static final void doOKAction$lambda$1(PasswordSafe $store, CredentialAttributes $attributes, Credentials $credentials) {
                $store.set($attributes, $credentials);
            }
        };
        return dialog2.showAndGet();
    }

    private static final LoginState changePassUnderProgress$lambda$0$0(AttemptsStateMachine $machine, String $oldPass, String $newPassword) {
        return $machine.changePass($oldPass, $newPassword);
    }

    private static final LoginState changePassUnderProgress$lambda$0(AttemptsStateMachine $machine, String $oldPass, String $newPassword) {
        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
        try {
            return (LoginState)((Computable)() -> UpdatePasswordKt.changePassUnderProgress$lambda$0$0($machine, $oldPass, $newPassword)).compute();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    public static final /* synthetic */ LoginState access$changePassUnderProgress(Project project, AttemptsStateMachine machine, String oldPass, String newPassword) {
        return UpdatePasswordKt.changePassUnderProgress(project, machine, oldPass, newPassword);
    }
}

