/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.checkout;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.checkout.PerforceCloneConnection;
import org.jetbrains.idea.perforce.checkout.PerforceCloneConnectionManager;
import org.jetbrains.idea.perforce.checkout.PerforceCloneParams;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.TestLoginManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/perforce/checkout/PerforceCloneRunnerFactory;", "", "<init>", "()V", "createRunner", "Lorg/jetbrains/idea/perforce/perforce/PerforceRunner;", "project", "Lcom/intellij/openapi/project/Project;", "params", "Lorg/jetbrains/idea/perforce/checkout/PerforceCloneParams;", "workDir", "Ljava/io/File;", "buildConnectArgs", "", "", "(Lorg/jetbrains/idea/perforce/checkout/PerforceCloneParams;)[Ljava/lang/String;", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nPerforceCloneRunnerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceCloneRunnerFactory.kt\norg/jetbrains/idea/perforce/checkout/PerforceCloneRunnerFactory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,52:1\n37#2,2:53\n*S KotlinDebug\n*F\n+ 1 PerforceCloneRunnerFactory.kt\norg/jetbrains/idea/perforce/checkout/PerforceCloneRunnerFactory\n*L\n49#1:53,2\n*E\n"})
public final class PerforceCloneRunnerFactory {
    @NotNull
    public static final PerforceCloneRunnerFactory INSTANCE = new PerforceCloneRunnerFactory();

    private PerforceCloneRunnerFactory() {
    }

    @NotNull
    public final PerforceRunner createRunner(@NotNull Project project, @NotNull PerforceCloneParams params, @NotNull File workDir) {
        PerforceSettings perforceSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        PerforceSettings $this$createRunner_u24lambda_u240 = perforceSettings = new PerforceSettings(project);
        boolean bl = false;
        $this$createRunner_u24lambda_u240.useP4CONFIG = false;
        $this$createRunner_u24lambda_u240.port = params.getServer();
        $this$createRunner_u24lambda_u240.user = params.getUser();
        $this$createRunner_u24lambda_u240.client = params.getClient();
        $this$createRunner_u24lambda_u240.USE_LOGIN = false;
        PerforceSettings settings = perforceSettings;
        String[] connArgs = this.buildConnectArgs(params);
        PerforceCloneConnection connection = new PerforceCloneConnection(workDir, connArgs);
        PerforceCloneConnectionManager connectionManager = new PerforceCloneConnectionManager(connection);
        TestLoginManager loginManager = new TestLoginManager(project, settings, connectionManager);
        return new PerforceRunner(connectionManager, settings, loginManager);
    }

    @NotNull
    public final String[] buildConnectArgs(@NotNull PerforceCloneParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List args = new ArrayList();
        if (!StringsKt.isBlank((CharSequence)params.getServer())) {
            args.add("-p");
            args.add(params.getServer());
        }
        if (!StringsKt.isBlank((CharSequence)params.getUser())) {
            args.add("-u");
            args.add(params.getUser());
        }
        if (!StringsKt.isBlank((CharSequence)params.getPassword())) {
            args.add("-P");
            args.add(params.getPassword());
        }
        if (!StringsKt.isBlank((CharSequence)params.getClient())) {
            args.add("-c");
            args.add(params.getClient());
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }
}

