/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParametersProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0005\u000e\u000f\u0010\u0011\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider;", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParametersProvider;", "configFiles", "Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConfigFiles;", "<init>", "(Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConfigFiles;)V", "getConnectionParameters", "", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "project", "Lcom/intellij/openapi/project/Project;", "parseConnectionParameters", "", "Ljava/io/File;", "Companion", "ConfigFiles", "DefaultConfigFiles", "ConnectionMapParseHandler", "ConnectionMapList", "intellij.vcs.perforce"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nP4ConnectionParametersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4ConnectionParametersProvider.kt\norg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,136:1\n1#2:137\n13#3:138\n*S KotlinDebug\n*F\n+ 1 P4ConnectionParametersProvider.kt\norg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider\n*L\n61#1:138\n*E\n"})
public final class HelixClientConnectionParametersProvider
implements P4ConnectionParametersProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigFiles configFiles;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CONNECTIONMAP_FILE_NAME = "connectionmap.xml";

    public HelixClientConnectionParametersProvider(@NotNull ConfigFiles configFiles) {
        Intrinsics.checkNotNullParameter((Object)configFiles, (String)"configFiles");
        this.configFiles = configFiles;
    }

    public /* synthetic */ HelixClientConnectionParametersProvider(ConfigFiles configFiles, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            configFiles = new DefaultConfigFiles();
        }
        this(configFiles);
    }

    @Override
    @NotNull
    public Set<P4ConnectionParameters> getConnectionParameters(@NotNull Project project) {
        File adminConfig;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LinkedHashSet result = new LinkedHashSet();
        File clientConfig = this.configFiles.getClientConfig();
        if (clientConfig.exists()) {
            result.addAll(this.parseConnectionParameters(clientConfig));
        }
        if ((adminConfig = this.configFiles.getAdminConfig()).exists()) {
            result.addAll(this.parseConnectionParameters(adminConfig));
        }
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<P4ConnectionParameters> parseConnectionParameters(File $this$parseConnectionParameters) {
        Object object;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ConnectionMapParseHandler handler = new ConnectionMapParseHandler();
        try {
            Closeable closeable = new FileReader($this$parseConnectionParameters);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                saxParser.parse(new InputSource(reader), (DefaultHandler)handler);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to parse " + $this$parseConnectionParameters, (Throwable)e);
        }
        if ((object = handler.getConnectionMapList()) == null || (object = ((ConnectionMapList)object).getConnectionMap()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public HelixClientConnectionParametersProvider() {
        this(null, 1, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HelixClientConnectionParametersProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CONNECTIONMAP_FILE_NAME", "", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConfigFiles;", "", "getClientConfig", "Ljava/io/File;", "getAdminConfig", "intellij.vcs.perforce"})
    public static interface ConfigFiles {
        @NotNull
        public File getClientConfig();

        @NotNull
        public File getAdminConfig();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\n\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConnectionMapList;", "", "connectionMap", "", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "<init>", "(Ljava/util/List;)V", "getConnectionMap", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.perforce"})
    private static final class ConnectionMapList {
        @Nullable
        private final List<P4ConnectionParameters> connectionMap;

        public ConnectionMapList(@Nullable List<? extends P4ConnectionParameters> connectionMap) {
            this.connectionMap = connectionMap;
        }

        @Nullable
        public final List<P4ConnectionParameters> getConnectionMap() {
            return this.connectionMap;
        }

        @Nullable
        public final List<P4ConnectionParameters> component1() {
            return this.connectionMap;
        }

        @NotNull
        public final ConnectionMapList copy(@Nullable List<? extends P4ConnectionParameters> connectionMap) {
            return new ConnectionMapList(connectionMap);
        }

        public static /* synthetic */ ConnectionMapList copy$default(ConnectionMapList connectionMapList, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = connectionMapList.connectionMap;
            }
            return connectionMapList.copy(list);
        }

        @NotNull
        public String toString() {
            return "ConnectionMapList(connectionMap=" + this.connectionMap + ")";
        }

        public int hashCode() {
            return this.connectionMap == null ? 0 : ((Object)this.connectionMap).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionMapList)) {
                return false;
            }
            ConnectionMapList connectionMapList = (ConnectionMapList)other;
            return Intrinsics.areEqual(this.connectionMap, connectionMapList.connectionMap);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u0004\u0018\u00010\u0005J0\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J&\u0010\u0014\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConnectionMapParseHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "<init>", "()V", "connectionMapList", "Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConnectionMapList;", "tempConnectionMapList", "", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "tempConnectionMap", "tempValue", "", "getConnectionMapList", "startElement", "", "uri", "localName", "qName", "attributes", "Lorg/xml/sax/Attributes;", "endElement", "characters", "ch", "", "start", "", "length", "intellij.vcs.perforce"})
    @SourceDebugExtension(value={"SMAP\nP4ConnectionParametersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4ConnectionParametersProvider.kt\norg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConnectionMapParseHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    private static final class ConnectionMapParseHandler
    extends DefaultHandler {
        @Nullable
        private ConnectionMapList connectionMapList;
        @NotNull
        private List<P4ConnectionParameters> tempConnectionMapList = new ArrayList();
        @Nullable
        private P4ConnectionParameters tempConnectionMap;
        @Nullable
        private String tempValue;

        @Nullable
        public final ConnectionMapList getConnectionMapList() {
            return this.connectionMapList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) {
            String string = qName;
            if (Intrinsics.areEqual((Object)string, (Object)"ConnectionMapList")) {
                this.connectionMapList = new ConnectionMapList(this.tempConnectionMapList);
            } else if (Intrinsics.areEqual((Object)string, (Object)"ConnectionMap")) {
                void $this$startElement_u24lambda_u240;
                P4ConnectionParameters p4ConnectionParameters;
                P4ConnectionParameters p4ConnectionParameters2 = p4ConnectionParameters = new P4ConnectionParameters();
                ConnectionMapParseHandler connectionMapParseHandler = this;
                boolean bl = false;
                $this$startElement_u24lambda_u240.setNoConfigFound(true);
                connectionMapParseHandler.tempConnectionMap = p4ConnectionParameters;
            }
        }

        @Override
        public void endElement(@Nullable String uri, @Nullable String localName, @Nullable String qName) {
            block16: {
                String string = qName;
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case 2645995: {
                        if (string.equals("User")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1954118523: {
                        if (string.equals("P4Port")) {
                            n = 2;
                        }
                        break;
                    }
                    case 285739390: {
                        if (string.equals("ConnectionMap")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        P4ConnectionParameters p4ConnectionParameters = this.tempConnectionMap;
                        if (p4ConnectionParameters != null) {
                            P4ConnectionParameters it = p4ConnectionParameters;
                            boolean bl = false;
                            it.setUser(this.tempValue);
                        }
                        break;
                    }
                    case 2: {
                        P4ConnectionParameters p4ConnectionParameters = this.tempConnectionMap;
                        if (p4ConnectionParameters != null) {
                            P4ConnectionParameters it = p4ConnectionParameters;
                            boolean bl = false;
                            it.setServer(this.tempValue);
                        }
                        break;
                    }
                    case 3: {
                        P4ConnectionParameters p4ConnectionParameters = this.tempConnectionMap;
                        if (p4ConnectionParameters != null) {
                            P4ConnectionParameters tempConnectionMaps = p4ConnectionParameters;
                            boolean bl = false;
                            this.tempConnectionMapList.add(tempConnectionMaps);
                        }
                        break;
                    }
                }
            }
            this.tempValue = "";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void characters(@Nullable char[] ch, int start, int length) {
            String string;
            ConnectionMapParseHandler connectionMapParseHandler = this;
            if (ch != null) {
                void it;
                char[] cArray = ch;
                ConnectionMapParseHandler connectionMapParseHandler2 = connectionMapParseHandler;
                boolean bl = false;
                string = new String((char[])it, start, length);
                connectionMapParseHandler = connectionMapParseHandler2;
            } else {
                string = null;
            }
            connectionMapParseHandler.tempValue = string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$DefaultConfigFiles;", "Lorg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$ConfigFiles;", "<init>", "()V", "getUserHomeDir", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/NonNls;", "getClientConfig", "Ljava/io/File;", "getAdminConfig", "intellij.vcs.perforce"})
    @SourceDebugExtension(value={"SMAP\nP4ConnectionParametersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4ConnectionParametersProvider.kt\norg/jetbrains/idea/perforce/perforce/connections/HelixClientConnectionParametersProvider$DefaultConfigFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class DefaultConfigFiles
    implements ConfigFiles {
        private final String getUserHomeDir() {
            String string = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)SystemProperties.getUserHome(), (boolean)true));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            return string;
        }

        @Override
        @NotNull
        public File getClientConfig() {
            String p0 = this.getUserHomeDir() + "/.p4qt/connectionmap.xml";
            boolean bl = false;
            return new File(p0);
        }

        @Override
        @NotNull
        public File getAdminConfig() {
            String p0 = this.getUserHomeDir() + "/.p4admin/connectionmap.xml";
            boolean bl = false;
            return new File(p0);
        }
    }
}

