/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionDiagnoseRefresher;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.TestLoginManager;
import org.jetbrains.idea.perforce.perforce.connections.TestPerforceConnectionManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionTester;", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;)V", "connectionManager", "Lorg/jetbrains/idea/perforce/perforce/connections/TestPerforceConnectionManager;", "loginManager", "Lorg/jetbrains/idea/perforce/perforce/connections/TestLoginManager;", "testConnection", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionTester$TestConnectionResult;", "connection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "clientRoot", "Ljava/nio/file/Path;", "testExistingConnection", "testConnectionWithP4Config", "TestConnectionResult", "P4ConfigConnectionTestDataProvider", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nPerforceConnectionTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceConnectionTester.kt\norg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionTester\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class PerforceConnectionTester {
    @NotNull
    private final Project project;
    @NotNull
    private final PerforceSettings settings;
    @NotNull
    private final TestPerforceConnectionManager connectionManager;
    @NotNull
    private final TestLoginManager loginManager;

    public PerforceConnectionTester(@NotNull Project project, @NotNull PerforceSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.project = project;
        this.settings = settings;
        this.connectionManager = new TestPerforceConnectionManager(this.project, !this.settings.useP4CONFIG);
        this.loginManager = new TestLoginManager(this.project, this.settings, this.connectionManager);
    }

    @NotNull
    public final TestConnectionResult testConnection(@Nullable P4Connection connection, @Nullable Path clientRoot) {
        TestConnectionResult testConnectionResult;
        if (this.settings.useP4CONFIG) {
            testConnectionResult = this.testConnectionWithP4Config();
        } else {
            if (connection == null) {
                boolean bl = false;
                String string = "Connection is required for existing connection mode";
                throw new IllegalArgumentException(string.toString());
            }
            testConnectionResult = this.testExistingConnection(connection, clientRoot);
        }
        return testConnectionResult;
    }

    public static /* synthetic */ TestConnectionResult testConnection$default(PerforceConnectionTester perforceConnectionTester, P4Connection p4Connection, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            p4Connection = null;
        }
        if ((n & 2) != 0) {
            path = null;
        }
        return perforceConnectionTester.testConnection(p4Connection, path);
    }

    /*
     * Unable to fully structure code
     */
    private final TestConnectionResult testExistingConnection(P4Connection connection, Path clientRoot) {
        this.connectionManager.setSingletonConnection(connection);
        checker = new Ref.ObjectRef();
        runner = new PerforceRunner(this.connectionManager, this.settings, this.loginManager);
        isSuccess = ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, testExistingConnection$lambda$0(org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionTester java.nio.file.Path org.jetbrains.idea.perforce.perforce.connections.P4Connection org.jetbrains.idea.perforce.perforce.PerforceRunner kotlin.jvm.internal.Ref$ObjectRef ), ()V)((PerforceConnectionTester)this, (Path)clientRoot, (P4Connection)connection, (PerforceRunner)runner, (Ref.ObjectRef)checker), PerforceBundle.message("connection.test", new Object[0]), true, this.project);
        if (!isSuccess) ** GOTO lbl-1000
        v0 = (PerforceClientRootsChecker)checker.element;
        if (!(v0 != null ? v0.hasAnyErrors() : false)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        return new TestConnectionResult(v1, isSuccess == false, (P4RootsInformation)checker.element, null, null, 24, null);
    }

    /*
     * Unable to fully structure code
     */
    private final TestConnectionResult testConnectionWithP4Config() {
        runner = new PerforceRunner(this.connectionManager, this.settings, this.loginManager);
        refresher = new P4ConfigConnectionTestDataProvider(this.project, this.connectionManager, runner);
        isSuccess = ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, testConnectionWithP4Config$lambda$0(org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionTester$P4ConfigConnectionTestDataProvider ), ()V)((P4ConfigConnectionTestDataProvider)refresher), PerforceBundle.message("connection.test", new Object[0]), true, this.project);
        v0 = checker = isSuccess != false ? refresher.getP4RootsInformation() : null;
        if (!isSuccess) ** GOTO lbl-1000
        v1 = checker;
        if (!(v1 != null ? v1.hasAnyErrors() : false)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        return new TestConnectionResult(v2, isSuccess == false, checker, isSuccess != false ? refresher : null, null, 16, null);
    }

    private static final void testExistingConnection$lambda$0(PerforceConnectionTester this$0, Path $clientRoot, P4Connection $connection, PerforceRunner $runner, Ref.ObjectRef $checker) {
        VirtualFile clientRootVf;
        Map allConnections = this$0.connectionManager.getAllConnections();
        Path path = $clientRoot;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            v1 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(it);
        } else {
            v1 = clientRootVf = null;
        }
        if (allConnections.isEmpty() && clientRootVf != null) {
            allConnections = MapsKt.mapOf((Pair)TuplesKt.to((Object)clientRootVf, (Object)$connection));
        }
        ClientRootsCache cache = $clientRoot == null ? ClientRootsCache.getClientRootsCache(this$0.project) : new ClientRootsCache();
        Map<P4Connection, ConnectionInfo> info = PerforceInfoAndClient.calculateInfos(allConnections.values(), $runner, cache);
        $checker.element = new PerforceClientRootsChecker(info, allConnections, clientRootVf);
    }

    private static final void testConnectionWithP4Config$lambda$0(P4ConfigConnectionTestDataProvider $refresher) {
        $refresher.refresh();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionTester$P4ConfigConnectionTestDataProvider;", "Lorg/jetbrains/idea/perforce/application/ConnectionDiagnoseRefresher;", "project", "Lcom/intellij/openapi/project/Project;", "connectionManager", "Lorg/jetbrains/idea/perforce/perforce/connections/TestPerforceConnectionManager;", "runner", "Lorg/jetbrains/idea/perforce/perforce/PerforceRunner;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/perforce/perforce/connections/TestPerforceConnectionManager;Lorg/jetbrains/idea/perforce/perforce/PerforceRunner;)V", "checker", "Lorg/jetbrains/idea/perforce/application/PerforceClientRootsChecker;", "info", "", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "Lorg/jetbrains/idea/perforce/application/ConnectionInfo;", "mc", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceMultipleConnections;", "refresh", "", "getMultipleConnections", "getP4RootsInformation", "Lorg/jetbrains/idea/perforce/application/P4RootsInformation;", "intellij.vcs.perforce"})
    private static final class P4ConfigConnectionTestDataProvider
    implements ConnectionDiagnoseRefresher {
        @NotNull
        private final Project project;
        @NotNull
        private final TestPerforceConnectionManager connectionManager;
        @NotNull
        private final PerforceRunner runner;
        @NotNull
        private PerforceClientRootsChecker checker;
        @NotNull
        private Map<P4Connection, ? extends ConnectionInfo> info;
        @Nullable
        private PerforceMultipleConnections mc;

        public P4ConfigConnectionTestDataProvider(@NotNull Project project, @NotNull TestPerforceConnectionManager connectionManager, @NotNull PerforceRunner runner) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
            Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
            this.project = project;
            this.connectionManager = connectionManager;
            this.runner = runner;
            this.checker = new PerforceClientRootsChecker();
            this.info = MapsKt.emptyMap();
        }

        @Override
        public void refresh() {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.project);
            calculator.execute();
            PerforceMultipleConnections perforceMultipleConnections = this.mc = calculator.getMultipleConnections();
            Intrinsics.checkNotNull((Object)perforceMultipleConnections);
            Map<VirtualFile, P4Connection> map = perforceMultipleConnections.getAllConnections();
            this.connectionManager.setMultipleConnectionObject(this.mc);
            Map<P4Connection, ConnectionInfo> map2 = PerforceInfoAndClient.recalculateInfos(this.info, map.values(), (PerforceRunner)this.runner, (ClientRootsCache)ClientRootsCache.getClientRootsCache((Project)this.project)).newInfo;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"newInfo");
            this.info = map2;
            this.checker = new PerforceClientRootsChecker(this.info, map);
        }

        @Override
        @NotNull
        public PerforceMultipleConnections getMultipleConnections() {
            PerforceMultipleConnections perforceMultipleConnections = this.mc;
            Intrinsics.checkNotNull((Object)perforceMultipleConnections);
            return perforceMultipleConnections;
        }

        @Override
        @NotNull
        public P4RootsInformation getP4RootsInformation() {
            return this.checker;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B>\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000f\b\u0002\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0010\u0010\u0019\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0003JF\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000f\b\u0002\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\nH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionTester$TestConnectionResult;", "", "isSuccess", "", "isCancelled", "info", "Lorg/jetbrains/idea/perforce/application/P4RootsInformation;", "refresher", "Lorg/jetbrains/idea/perforce/application/ConnectionDiagnoseRefresher;", "errorMessage", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(ZZLorg/jetbrains/idea/perforce/application/P4RootsInformation;Lorg/jetbrains/idea/perforce/application/ConnectionDiagnoseRefresher;Ljava/lang/String;)V", "()Z", "getInfo", "()Lorg/jetbrains/idea/perforce/application/P4RootsInformation;", "getRefresher", "()Lorg/jetbrains/idea/perforce/application/ConnectionDiagnoseRefresher;", "getErrorMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.vcs.perforce"})
    public static final class TestConnectionResult {
        private final boolean isSuccess;
        private final boolean isCancelled;
        @Nullable
        private final P4RootsInformation info;
        @Nullable
        private final ConnectionDiagnoseRefresher refresher;
        @Nullable
        private final String errorMessage;

        public TestConnectionResult(boolean isSuccess, boolean isCancelled, @Nullable P4RootsInformation info, @Nullable ConnectionDiagnoseRefresher refresher, @Nullable String errorMessage) {
            this.isSuccess = isSuccess;
            this.isCancelled = isCancelled;
            this.info = info;
            this.refresher = refresher;
            this.errorMessage = errorMessage;
        }

        public /* synthetic */ TestConnectionResult(boolean bl, boolean bl2, P4RootsInformation p4RootsInformation, ConnectionDiagnoseRefresher connectionDiagnoseRefresher, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                connectionDiagnoseRefresher = null;
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            this(bl, bl2, p4RootsInformation, connectionDiagnoseRefresher, string);
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        public final boolean isCancelled() {
            return this.isCancelled;
        }

        @Nullable
        public final P4RootsInformation getInfo() {
            return this.info;
        }

        @Nullable
        public final ConnectionDiagnoseRefresher getRefresher() {
            return this.refresher;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final boolean component1() {
            return this.isSuccess;
        }

        public final boolean component2() {
            return this.isCancelled;
        }

        @Nullable
        public final P4RootsInformation component3() {
            return this.info;
        }

        @Nullable
        public final ConnectionDiagnoseRefresher component4() {
            return this.refresher;
        }

        @Nullable
        public final String component5() {
            return this.errorMessage;
        }

        @NotNull
        public final TestConnectionResult copy(boolean isSuccess, boolean isCancelled, @Nullable P4RootsInformation info, @Nullable ConnectionDiagnoseRefresher refresher, @Nullable String errorMessage) {
            return new TestConnectionResult(isSuccess, isCancelled, info, refresher, errorMessage);
        }

        public static /* synthetic */ TestConnectionResult copy$default(TestConnectionResult testConnectionResult, boolean bl, boolean bl2, P4RootsInformation p4RootsInformation, ConnectionDiagnoseRefresher connectionDiagnoseRefresher, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = testConnectionResult.isSuccess;
            }
            if ((n & 2) != 0) {
                bl2 = testConnectionResult.isCancelled;
            }
            if ((n & 4) != 0) {
                p4RootsInformation = testConnectionResult.info;
            }
            if ((n & 8) != 0) {
                connectionDiagnoseRefresher = testConnectionResult.refresher;
            }
            if ((n & 0x10) != 0) {
                string = testConnectionResult.errorMessage;
            }
            return testConnectionResult.copy(bl, bl2, p4RootsInformation, connectionDiagnoseRefresher, string);
        }

        @NotNull
        public String toString() {
            return "TestConnectionResult(isSuccess=" + this.isSuccess + ", isCancelled=" + this.isCancelled + ", info=" + this.info + ", refresher=" + this.refresher + ", errorMessage=" + this.errorMessage + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isSuccess);
            result = result * 31 + Boolean.hashCode(this.isCancelled);
            result = result * 31 + (this.info == null ? 0 : this.info.hashCode());
            result = result * 31 + (this.refresher == null ? 0 : this.refresher.hashCode());
            result = result * 31 + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestConnectionResult)) {
                return false;
            }
            TestConnectionResult testConnectionResult = (TestConnectionResult)other;
            if (this.isSuccess != testConnectionResult.isSuccess) {
                return false;
            }
            if (this.isCancelled != testConnectionResult.isCancelled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.info, (Object)testConnectionResult.info)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refresher, (Object)testConnectionResult.refresher)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)testConnectionResult.errorMessage);
        }
    }
}

