/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.plots;

import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.plots.FlavorsKt;
import com.intellij.kotlin.jupyter.plots.IdeaPlotComponentProviderBatik;
import com.intellij.kotlin.jupyter.plots.IdeaSwingContextBatik;
import com.intellij.kotlin.jupyter.plots.LetsPlotComponentKt;
import com.intellij.kotlin.jupyter.plots.LetsPlotComponentState;
import com.intellij.kotlin.jupyter.plots.LetsPlotOutputDataKey;
import com.intellij.kotlin.jupyter.plots.ToolbarKt;
import com.intellij.kotlin.jupyter.plots.export.HtmlExportKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLayeredPane;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.letsPlot.awt.plot.component.PlotPanel;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J \u0010\u001d\u001a\u00020\u00162\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u0002`#H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002J \u0010%\u001a\u00020\u00162\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u0002`#H\u0002J\u001c\u0010'\u001a\u0016\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 j\u0004\u0018\u0001`#H\u0002J\b\u0010(\u001a\u00020!H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/kotlin/jupyter/plots/LetsPlotComponent;", "Lcom/intellij/ui/components/JBLayeredPane;", "<init>", "()V", "plotPanel", "Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanel;", "_dataKey", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "dataKey", "getDataKey", "()Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "_showToolbar", "", "showToolbar", "getShowToolbar", "()Z", "currentState", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotComponentState;", "getCurrentState", "()Lcom/intellij/kotlin/jupyter/plots/LetsPlotComponentState;", "previousState", "initialize", "", "toggleToolbar", "updateUI", "doLayout", "getPreferredSize", "Ljava/awt/Dimension;", "logUpdateCall", "reinitComponent", "state", "spec", "", "", "", "Lcom/intellij/kotlin/jupyter/plots/MutableLetsPlotSpec;", "clear", "initForSpec", "processedSpec", "getSpec", "getPlotHtml", "Companion", "intellij.kotlin.jupyter.plots"})
@SourceDebugExtension(value={"SMAP\nLetsPlotComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LetsPlotComponent.kt\ncom/intellij/kotlin/jupyter/plots/LetsPlotComponent\n+ 2 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,198:1\n13#2:199\n*S KotlinDebug\n*F\n+ 1 LetsPlotComponent.kt\ncom/intellij/kotlin/jupyter/plots/LetsPlotComponent\n*L\n161#1:199\n*E\n"})
public final class LetsPlotComponent
extends JBLayeredPane {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private PlotPanel plotPanel;
    @Nullable
    private LetsPlotOutputDataKey _dataKey;
    private boolean _showToolbar;
    @Nullable
    private LetsPlotComponentState previousState;
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final LetsPlotOutputDataKey getDataKey() {
        return this._dataKey;
    }

    public final boolean getShowToolbar() {
        return this._showToolbar;
    }

    private final LetsPlotComponentState getCurrentState() {
        return new LetsPlotComponentState(this.getDataKey(), FlavorsKt.getCurrentLetsPlotFlavor(), this.getShowToolbar());
    }

    public final void initialize(@NotNull LetsPlotOutputDataKey dataKey) {
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        this._dataKey = dataKey;
        this._showToolbar = ToolbarKt.isToolbarEnabled(dataKey.getSpec());
        this.reinitComponent();
    }

    public final void toggleToolbar() {
        this._showToolbar = !this._showToolbar;
        this.reinitComponent();
    }

    public void updateUI() {
        LetsPlotComponentState prevState;
        LetsPlotComponentState currentState = this.getCurrentState();
        if (Intrinsics.areEqual((Object)currentState, (Object)(prevState = this.previousState))) {
            return;
        }
        this.logUpdateCall(prevState);
        this.previousState = currentState;
        this.reinitComponent(currentState);
    }

    public void doLayout() {
        super.doLayout();
        Dimension mySize = this.getSize();
        if (mySize.width <= 0 || mySize.height <= 0) {
            return;
        }
        PlotPanel plotPanel2 = this.plotPanel;
        if (plotPanel2 == null) {
            return;
        }
        PlotPanel myComponent = plotPanel2;
        Map<String, Object> map = this.getSpec();
        if (map == null) {
            return;
        }
        Map<String, Object> spec = map;
        Dimension dimension2 = LetsPlotComponentKt.access$plotSize(spec, mySize, SizingPolicy.Companion.fitContainerSize(true));
        if (dimension2 == null) {
            dimension2 = mySize;
        }
        Dimension plotSize = dimension2;
        myComponent.setBounds(new Rectangle(plotSize));
        myComponent.dispatchEvent((AWTEvent)new ComponentEvent((Component)myComponent, 101));
    }

    @NotNull
    public Dimension getPreferredSize() {
        Object object;
        block5: {
            block4: {
                object = this.getSpec();
                if (object == null) break block4;
                Map<String, Object> it = object;
                boolean bl = false;
                Container container = this.getParent();
                Dimension dimension2 = LetsPlotComponentKt.access$plotSize(it, container != null ? container.getSize() : null, SizingPolicy.Companion.notebookCell());
                object = dimension2;
                if (dimension2 != null) break block5;
            }
            PlotPanel plotPanel2 = this.plotPanel;
            object = plotPanel2 != null ? plotPanel2.getPreferredSize() : null;
            if (object == null) {
                Dimension dimension3 = super.getPreferredSize();
                object = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getPreferredSize(...)");
            }
        }
        return object;
    }

    private final void logUpdateCall(LetsPlotComponentState previousState) {
        boolean flavorChanged;
        LetsPlotComponentState currentState = this.getCurrentState();
        LetsPlotComponentState letsPlotComponentState = previousState;
        boolean dataKeyChanged = !Intrinsics.areEqual((Object)currentState.getDataKey(), (Object)(letsPlotComponentState != null ? letsPlotComponentState.getDataKey() : null));
        LetsPlotComponentState letsPlotComponentState2 = previousState;
        boolean bl = flavorChanged = currentState.getColorFlavor() != (letsPlotComponentState2 != null ? letsPlotComponentState2.getColorFlavor() : null);
        boolean toolbarChanged = !(previousState != null ? currentState.getShowToolbar() == previousState.getShowToolbar() : false);
        LOG.trace("updateUI: dataKeyChanged=" + dataKeyChanged + ", flavorChanged=" + flavorChanged + ", toolbarChanged=" + toolbarChanged);
    }

    private final void reinitComponent() {
        this.reinitComponent(this.getCurrentState());
    }

    private final void reinitComponent(LetsPlotComponentState state) {
        LOG.trace("reinitComponent: state=" + state);
        Map map = LetsPlotComponentKt.access$getSpec(state);
        if (map == null) {
            return;
        }
        this.reinitComponent(map);
    }

    private final void reinitComponent(Map<String, Object> spec) {
        this.clear();
        this.initForSpec(spec);
    }

    private final void clear() {
        LOG.trace(new Throwable("clear: plotPanel=" + (this.plotPanel != null) + ", componentCount=" + this.getComponentCount()));
        this.removeAll();
        PlotPanel plotPanel2 = this.plotPanel;
        if (plotPanel2 != null) {
            plotPanel2.dispose();
        }
        this.plotPanel = null;
    }

    private final void initForSpec(Map<String, Object> processedSpec) {
        IdeaPlotComponentProviderBatik plotComponentProvider = new IdeaPlotComponentProviderBatik(processedSpec, IdeaSwingContextBatik.INSTANCE.getIDEA_EDT_EXECUTOR(), (Function1<? super List<String>, Unit>)((Function1)LetsPlotComponent::initForSpec$lambda$0), (Function1<? super JComponent, Unit>)((Function1)LetsPlotComponent::initForSpec$lambda$1));
        boolean showToolbar = ToolbarKt.isToolbarEnabled(processedSpec);
        IdeaSwingContextBatik ideaSwingContextBatik = IdeaSwingContextBatik.INSTANCE;
        SizingPolicy sizingPolicy = SizingPolicy.Companion.fitContainerSize(!showToolbar);
        PlotPanel plotPanel2 = new PlotPanel(plotComponentProvider, showToolbar, ideaSwingContextBatik, sizingPolicy){};
        plotPanel2.setOpaque(true);
        plotPanel2.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.add((Component)plotPanel2, JBLayeredPane.DEFAULT_LAYER, -1);
        this.plotPanel = plotPanel2;
    }

    private final Map<String, Object> getSpec() {
        return LetsPlotComponentKt.access$getSpec(this.getCurrentState());
    }

    @TestOnly
    @NotNull
    public final String getPlotHtml() {
        Object object;
        block3: {
            block2: {
                object = this.getDataKey();
                if (object == null) break block2;
                LetsPlotOutputDataKey it = object;
                boolean bl = false;
                String string = HtmlExportKt.buildHtmlFromRawPlotSpec(MapsKt.toMutableMap(it.getSpec()));
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private static final Unit initForSpec$lambda$0(List messages) {
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        for (String message : messages) {
            LOG.debug("[Demo Plot Viewer] " + message);
        }
        return Unit.INSTANCE;
    }

    private static final Unit initForSpec$lambda$1(JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        PopupHandler.installPopupMenu((JComponent)component, (String)"LetsPlotActions", (String)"Editor.Jupyter.Cell.Output.Popup");
        return Unit.INSTANCE;
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/plots/LetsPlotComponent$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.plots"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

