/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0017H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/todo/nodes/TodoRemoteItemNode;", "Lcom/intellij/ide/todo/nodes/BaseToDoNode;", "Lcom/intellij/ide/todo/nodes/TodoRemoteItemNode$Value;", "project", "Lcom/intellij/openapi/project/Project;", "value", "builder", "Lcom/intellij/ide/todo/TodoTreeBuilder;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/todo/nodes/TodoRemoteItemNode$Value;Lcom/intellij/ide/todo/TodoTreeBuilder;)V", "createPresentation", "Lcom/intellij/ide/projectView/PresentationData;", "getFileCount", "", "val", "getTodoItemCount", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "", "presentation", "canNavigate", "", "navigate", "requestFocus", "Value", "intellij.platform.todo"})
@ApiStatus.Internal
public final class TodoRemoteItemNode
extends BaseToDoNode<Value> {
    public TodoRemoteItemNode(@NotNull Project project, @NotNull Value value, @NotNull TodoTreeBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(project, value, builder);
    }

    @NotNull
    protected PresentationData createPresentation() {
        return new PresentationData();
    }

    @Override
    public int getFileCount(@Nullable Value val) {
        return 1;
    }

    @Override
    public int getTodoItemCount(@Nullable Value val) {
        return 1;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return CollectionsKt.emptyList();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Value value = (Value)this.getValue();
        if (value == null) {
            return;
        }
        Value v = value;
        String text = v.getLine() + 1 + " : " + v.getLineText();
        presentation.setPresentableText(text);
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        Value value = (Value)this.getValue();
        if (value == null) {
            return;
        }
        Value v = value;
        new OpenFileDescriptor(this.getProject(), v.getFile(), v.getNavigationOffset()).navigate(requestFocus);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\tH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/todo/nodes/TodoRemoteItemNode$Value;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigationOffset", "", "length", "line", "lineText", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;IIILjava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getNavigationOffset", "()I", "getLength", "getLine", "getLineText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.todo"})
    public static final class Value {
        @NotNull
        private final VirtualFile file;
        private final int navigationOffset;
        private final int length;
        private final int line;
        @NotNull
        private final String lineText;

        public Value(@NotNull VirtualFile file, int navigationOffset, int length, int line, @NotNull String lineText) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
            this.file = file;
            this.navigationOffset = navigationOffset;
            this.length = length;
            this.line = line;
            this.lineText = lineText;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final int getNavigationOffset() {
            return this.navigationOffset;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getLine() {
            return this.line;
        }

        @NotNull
        public final String getLineText() {
            return this.lineText;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        public final int component2() {
            return this.navigationOffset;
        }

        public final int component3() {
            return this.length;
        }

        public final int component4() {
            return this.line;
        }

        @NotNull
        public final String component5() {
            return this.lineText;
        }

        @NotNull
        public final Value copy(@NotNull VirtualFile file, int navigationOffset, int length, int line, @NotNull String lineText) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
            return new Value(file, navigationOffset, length, line, lineText);
        }

        public static /* synthetic */ Value copy$default(Value value, VirtualFile virtualFile, int n, int n2, int n3, String string, int n4, Object object) {
            if ((n4 & 1) != 0) {
                virtualFile = value.file;
            }
            if ((n4 & 2) != 0) {
                n = value.navigationOffset;
            }
            if ((n4 & 4) != 0) {
                n2 = value.length;
            }
            if ((n4 & 8) != 0) {
                n3 = value.line;
            }
            if ((n4 & 0x10) != 0) {
                string = value.lineText;
            }
            return value.copy(virtualFile, n, n2, n3, string);
        }

        @NotNull
        public String toString() {
            return "Value(file=" + this.file + ", navigationOffset=" + this.navigationOffset + ", length=" + this.length + ", line=" + this.line + ", lineText=" + this.lineText + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Integer.hashCode(this.navigationOffset);
            result = result * 31 + Integer.hashCode(this.length);
            result = result * 31 + Integer.hashCode(this.line);
            result = result * 31 + this.lineText.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Value)) {
                return false;
            }
            Value value = (Value)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)value.file)) {
                return false;
            }
            if (this.navigationOffset != value.navigationOffset) {
                return false;
            }
            if (this.length != value.length) {
                return false;
            }
            if (this.line != value.line) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lineText, (Object)value.lineText);
        }
    }
}

