/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.platform.completion.common.protocol.RpcCompletionArrangement;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemId;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemWeight;
import com.intellij.platform.completion.common.protocol.RpcCompletionResponseEvent;
import com.intellij.platform.completion.frontend.split.FrontendArrangement;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendCompletionState;", "", "<init>", "()V", "allEvents", "", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent;", "getAllEvents", "()Ljava/util/List;", "arrangement", "Lcom/intellij/platform/completion/frontend/split/FrontendArrangement;", "isMatchedByBackend", "", "id", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionItemId;", "getWeight", "", "updateArrangement", "", "completionArrangement", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionArrangement;", "isStartMatchByBackend", "intellij.platform.completion.frontend.split"})
public final class FrontendCompletionState {
    @NotNull
    private final List<RpcCompletionResponseEvent> allEvents = new ArrayList();
    @NotNull
    private volatile FrontendArrangement arrangement = new FrontendArrangement((Object2IntMap<RpcCompletionItemId>)((Object2IntMap)new Object2IntOpenHashMap()), SetsKt.emptySet(), SetsKt.emptySet());

    @NotNull
    public final List<RpcCompletionResponseEvent> getAllEvents() {
        return this.allEvents;
    }

    public final boolean isMatchedByBackend(@NotNull RpcCompletionItemId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !this.arrangement.getNonMatched().contains(id);
    }

    public final int getWeight(@NotNull RpcCompletionItemId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.arrangement.getWeights().getInt((Object)id);
    }

    public final void updateArrangement(@NotNull RpcCompletionArrangement completionArrangement) {
        Intrinsics.checkNotNullParameter((Object)completionArrangement, (String)"completionArrangement");
        Object2IntOpenHashMap weights = new Object2IntOpenHashMap();
        for (RpcCompletionItemWeight weight : completionArrangement.getWeightsOfMatchedItems()) {
            weights.put((Object)weight.getId(), weight.getWeight());
        }
        Set nonMatched = CollectionsKt.toSet((Iterable)completionArrangement.getNonMatchedItems());
        Set startMatches = CollectionsKt.toSet((Iterable)completionArrangement.getStartMatches());
        this.arrangement = new FrontendArrangement((Object2IntMap<RpcCompletionItemId>)((Object2IntMap)weights), nonMatched, startMatches);
    }

    public final boolean isStartMatchByBackend(@NotNull RpcCompletionItemId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.arrangement.getStartMatches().contains(id);
    }
}

