/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementInsertStopper;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.completion.common.LookupElementWithRpcId;
import com.intellij.platform.completion.common.protocol.RpcCompletionItem;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemId;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemPresentation;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemPresentationKt;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequest;
import com.intellij.platform.completion.frontend.split.FrontendInsertHandler;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElementInsertStopper;", "Lcom/intellij/platform/completion/common/LookupElementWithRpcId;", "item", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionItem;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "<init>", "(Lcom/intellij/platform/completion/common/protocol/RpcCompletionItem;Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;)V", "getItem", "()Lcom/intellij/platform/completion/common/protocol/RpcCompletionItem;", "getRequest", "()Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "getLookupString", "", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "handleInsert", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "getAllLookupStrings", "", "requiresCommittedDocuments", "", "getAutoCompletionPolicy", "Lcom/intellij/codeInsight/lookup/AutoCompletionPolicy;", "getExpensiveRenderer", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "isCaseSensitive", "shouldStopLookupInsertion", "rpcId", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionItemId;", "getRpcId", "()Lcom/intellij/platform/completion/common/protocol/RpcCompletionItemId;", "intellij.platform.completion.frontend.split"})
public final class FrontendLookupElement
extends LookupElement
implements LookupElementInsertStopper,
LookupElementWithRpcId {
    @NotNull
    private final RpcCompletionItem item;
    @NotNull
    private final Project project;
    @NotNull
    private final RpcCompletionRequest request;

    public FrontendLookupElement(@NotNull RpcCompletionItem item, @NotNull Project project, @NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.item = item;
        this.project = project;
        this.request = request;
        if (this.item.isDirectInsertion()) {
            this.putUserData(CodeCompletionHandlerBase.DIRECT_INSERTION, true);
        }
    }

    @NotNull
    public final RpcCompletionItem getItem() {
        return this.item;
    }

    @NotNull
    public final RpcCompletionRequest getRequest() {
        return this.request;
    }

    @NotNull
    public String getLookupString() {
        return this.item.getLookupString();
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        RpcCompletionItemPresentationKt.render((RpcCompletionItemPresentation)this.item.getPresentation(), (LookupElementPresentation)presentation);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        new FrontendInsertHandler(this.request.getId(), this.project).handleInsert(context, this);
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        Set set = this.item.getAllLookupStrings();
        if (set == null) {
            set = SetsKt.setOf((Object)this.getLookupString());
        }
        return set;
    }

    public boolean requiresCommittedDocuments() {
        return this.item.getRequiresCommittedDocuments();
    }

    @NotNull
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.item.getAutoCompletionPolicy();
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return super.getExpensiveRenderer();
    }

    public boolean isCaseSensitive() {
        return this.item.isCaseSensitive();
    }

    public boolean shouldStopLookupInsertion() {
        return this.item.getShouldStopLookupInsertion();
    }

    @NotNull
    public RpcCompletionItemId getRpcId() {
        return this.item.getId();
    }
}

