/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.util.URIUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.GitLabProjectsManager;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.util.GitLabProjectMapping;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"createSingleProjectAndAccountState", "Lkotlinx/coroutines/flow/StateFlow;", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping;", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "projectsManager", "Lorg/jetbrains/plugins/gitlab/GitLabProjectsManager;", "accountManager", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabProjectsAndAccountsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabProjectsAndAccountsUtil.kt\norg/jetbrains/plugins/gitlab/GitLabProjectsAndAccountsUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,23:1\n672#2,11:24\n*S KotlinDebug\n*F\n+ 1 GitLabProjectsAndAccountsUtil.kt\norg/jetbrains/plugins/gitlab/GitLabProjectsAndAccountsUtilKt\n*L\n19#1:24,11\n*E\n"})
public final class GitLabProjectsAndAccountsUtilKt {
    @NotNull
    public static final StateFlow<Pair<GitLabProjectMapping, GitLabAccount>> createSingleProjectAndAccountState(@NotNull CoroutineScope cs, @NotNull GitLabProjectsManager projectsManager, @NotNull GitLabAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectsManager, (String)"projectsManager");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        return CoroutineUtilKt.combineState((CoroutineScope)cs, (StateFlow)projectsManager.getKnownRepositoriesState(), (StateFlow)accountManager.getAccountsState(), GitLabProjectsAndAccountsUtilKt::createSingleProjectAndAccountState$lambda$0);
    }

    private static final Pair createSingleProjectAndAccountState$lambda$0(Set repos, Set accounts) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)repos, (String)"repos");
        Intrinsics.checkNotNullParameter((Object)accounts, (String)"accounts");
        GitLabProjectMapping gitLabProjectMapping = (GitLabProjectMapping)CollectionsKt.singleOrNull((Iterable)repos);
        if (gitLabProjectMapping != null) {
            Object v1;
            GitLabProjectMapping repo;
            block6: {
                repo = gitLabProjectMapping;
                boolean bl = false;
                Iterable $this$singleOrNull$iv = accounts;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    GitLabAccount it = (GitLabAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!URIUtil.INSTANCE.equalWithoutSchema(it.getServer().toURI(), repo.getRepository().getServerPath().toURI())) continue;
                    if (found$iv) {
                        v1 = null;
                        break block6;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            GitLabAccount gitLabAccount = v1;
            if (gitLabAccount != null) {
                GitLabAccount it = gitLabAccount;
                boolean bl = false;
                pair = TuplesKt.to((Object)repo, (Object)((Object)it));
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }
}

