/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.LTRuleInfo;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.document.ConsistencyChecker;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishMetadata;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

class SerialComma {
    private static final String MISSING_MESSAGE = "In comma-separated lists, it\u2019s suggested to put a comma before the last item";
    private static final String PRESENT_MESSAGE = "In comma-separated lists, it\u2019s suggested to avoid commas before the last item";
    private static final String INCONSISTENT_MESSAGE = "Inconsistent serial (Oxford) comma usage";
    private static final NodePattern noCcConj = NodePattern.N.noDependents("cc");
    private static final NodePattern wrongFirstConj = CommonPatterns.capitalizedMiddle.directlyAfter(CommonPatterns.colon).withHead("appos", NodePattern.ROOT.pos("NNP"));
    private static final NodePattern lastConjMisparsed = NodePattern.N.directlyBefore(CommonPatterns.comma.directlyBefore(NodePattern.N.withHeadRelation("list")));
    private static final NodePattern lastConj = NodePattern.custom(node -> {
        Node head = node.head();
        if (head == null) {
            return false;
        }
        if (wrongFirstConj.matches(head)) {
            return false;
        }
        List<Node> conjs = head.findDependents("appos|conj");
        if (conjs.size() >= 2 && node == conjs.getLast()) {
            if (conjs.stream().limit(conjs.size() - 1).allMatch(noCcConj::matches)) {
                if (conjs.stream().anyMatch(Commas.commaStartingPhrase::matches)) {
                    return conjs.size() != 2 || SerialComma.isSerialCommaApplicableTo3(head, conjs.get(0), conjs.get(1));
                }
            }
        }
        return false;
    }).noDependents("appos|conj").noDependents("flat", NodePattern.N.withDependent("appos|conj")).andNot(lastConjMisparsed).andNot(NodePattern.N.formCaseSensitive("Company").directlyAfter(NodePattern.N.form("and"))).andNot(NodePattern.N.inFormSequence(2, "Bexley", "and", "Bromley")).andNot(NodePattern.N.inFormSequence(2, "Tegan", "and", "Sara"));
    private static final String batchRemoveId = "RemoveSerialComma";
    private static final String batchInsertId = "InsertSerialComma";
    private static final NodePattern present = CommonPatterns.comma.and(CommonPatterns.reportWithPrevWord).directlyBefore(NodePattern.N.form("and|or").includeIntoReport(ReportingKind.Hover).withHead("cc", lastConj)).correct(NodeCorrector.replace("").batchCapable("RemoveSerialComma"));
    private static final NodePattern missing = NodePattern.N.form("and|or").includeIntoReport().withHead("cc", lastConj).directlyAfter(NodePattern.not(NodePattern.PUNCT).includeIntoReport().correct(NodeCorrector.insertAfter(",").batchCapable("InsertSerialComma")));
    private static final NodePattern vbConjAmbiguity = NodePattern.N.potentialPos("VB").andNot(CommonPatterns.capitalizedMiddle);
    private static final ConsistencyChecker<SerialCommaUsage> consistency = new ConsistencyChecker<SerialCommaUsage>(SerialCommaUsage.class, EnglishMetadata.serialComma){

        @Override
        protected ConsistencyChecker.SingleFix correctStyle(SerialCommaUsage style, Node node) {
            return ConsistencyChecker.SingleFix.from((style == SerialCommaUsage.missing ? present : missing).match(node));
        }

        @Override
        protected String quickFixMessage(SerialCommaUsage style) {
            return style == SerialCommaUsage.missing ? "Remove serial commas everywhere" : "Insert serial commas everywhere";
        }
    };

    SerialComma() {
    }

    private static boolean isSerialCommaApplicableTo3(Node c1, Node c2, Node c3) {
        if (c2.hasPos("JJ.*") && c3.hasPos("JJ.*")) {
            if (c1.tagIndependently().hasPos("JJ.*")) {
                return true;
            }
            if (c1.hasPos("NN.*")) {
                return false;
            }
        }
        return !c1.hierarchy().anyMatch(n -> n.isBefore(c1) && n.hasPos("VB")) || !vbConjAmbiguity.matches(c2) || !vbConjAmbiguity.matches(c3);
    }

    static Rule.PatternRule rule() {
        final String desc = "Some style guides suggest putting a comma before the last item in comma-separated lists, while others suggest leaving it out.\nWhichever guide you follow, it\u2019s important to be consistent.\n";
        final Example consistencyExample = new Example("Tom, <b>Dick,</b> <i>and</i> Harry go there, while Alice, <b>Bob and</b> Carol don\u2019t. (consistency expected)", List.of("Tom, Dick, and Harry go there, while Alice, <b>Bob, and</b> Carol don\u2019t. (consistency expected)", "Tom, Dick<b> and</b> Harry go there, while Alice, Bob and Carol don\u2019t. (consistency expected)"), Map.of(EnglishParameters.SERIAL_COMMA, "consistently"));
        return new DocumentRule.PatternRule("Style.SERIAL_COMMA", "Check for serial (Oxford) commas", desc, "https://en.wikipedia.org/wiki/Serial_comma", () -> NodePattern.or(missing.andOr(EnglishParameters.SERIAL_COMMA.withValue("always").message(MISSING_MESSAGE), EnglishParameters.SERIAL_COMMA.withValue("consistently").and(consistency.record(SerialCommaUsage.missing))), present.andOr(EnglishParameters.SERIAL_COMMA.withValue("never").message(PRESENT_MESSAGE), EnglishParameters.SERIAL_COMMA.withValue("consistently").and(consistency.record(SerialCommaUsage.present)))), new Example[]{new Example("Every Tom, <b>Dick and</b> Harry go there. (serial comma preferred)", List.of("Every Tom, <b>Dick, and</b> Harry go there. (serial comma preferred)"), Map.of(EnglishParameters.SERIAL_COMMA, "always")), new Example("Every Tom, <b>Dick,</b> <i>and</i> Harry go there. (serial comma disfavored)", List.of("Every Tom, <b>Dick and</b> Harry go there. (serial comma disfavored)"), Map.of(EnglishParameters.SERIAL_COMMA, "never"))}){

            @Override
            public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
                return MatchingResult.from(consistency.checkConsistency(sentences, this, SerialComma.INCONSISTENT_MESSAGE));
            }

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsMetadataBasedDocumentAnalysis();
            }

            @Override
            public String getDescription(RuleClient client) {
                if (client.hasLocalMode()) {
                    return desc + "<p>This rule is only available when connected to Grazie Cloud.";
                }
                return desc;
            }

            @Override
            public List<Example> getExamples(RuleClient client) {
                return StreamEx.of(super.getExamples(client)).append(client.supportsMetadataBasedDocumentAnalysis() ? List.of(consistencyExample) : List.of()).toList();
            }
        }.styleFlavor(StyleFlavor.Formality).coveringLTRules(new LTRuleInfo("SERIAL_COMMA_ON", EnglishParameters.SERIAL_COMMA, "always"), new LTRuleInfo("SERIAL_COMMA_OFF", EnglishParameters.SERIAL_COMMA, "never"));
    }

    private static enum SerialCommaUsage {
        present,
        missing;

    }
}

