/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public record TextRange(int start, int end) {
    public TextRange {
        if (start > end) {
            throw new AssertionError((Object)(start + ">" + end));
        }
        if (start < 0) {
            throw new AssertionError(start);
        }
    }

    public static TextRange fromLength(int start, int length) {
        return new TextRange(start, start + length);
    }

    @NotNull
    public static TextRange span(TextRange r1, TextRange r2) {
        return new TextRange(Math.min(r1.start, r2.start), Math.max(r1.end, r2.end));
    }

    public static TextRange spanRanges(Stream<TextRange> ranges) {
        return ranges.reduce(TextRange::span).orElseThrow();
    }

    @Override
    public String toString() {
        return "(" + this.start + ", " + this.end + ")";
    }

    public boolean encloses(@NotNull TextRange another) {
        return this.start <= another.start && another.end <= this.end;
    }

    public boolean containsInclusive(int offset) {
        return this.start <= offset && offset <= this.end;
    }

    public boolean containsExclusive(int offset) {
        return this.start < offset && offset < this.end;
    }

    public boolean containsInclusive(TextRange range) {
        return this.start <= range.start && range.end <= this.end;
    }

    public boolean overlaps(TextRange range) {
        return this.end > range.start && range.end > this.start;
    }

    public boolean touches(TextRange range) {
        return this.end >= range.start && range.end >= this.start;
    }

    public TextRange mapOffsets(IntUnaryOperator mapper) {
        return new TextRange(mapper.applyAsInt(this.start), mapper.applyAsInt(this.end));
    }

    public TextRange shiftRight(int delta) {
        return new TextRange(this.start + delta, this.end + delta);
    }

    public TextRange shiftLeft(int delta) {
        return new TextRange(this.start - delta, this.end - delta);
    }

    public String substring(String text) {
        return text.substring(this.start, this.end);
    }

    public String replace(String text, String replacement) {
        return text.substring(0, this.start) + replacement + text.substring(this.end);
    }

    public int clamp(int offset) {
        return Math.clamp((long)offset, this.start, this.end);
    }

    public int length() {
        return this.end - this.start;
    }

    public static List<TextRange> mergeConditionally(Stream<TextRange> ranges, BiPredicate<TextRange, TextRange> spanCondition) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        List<TextRange> input = ranges.collect(Collectors.toList());
        if (input.size() < 2) {
            return input;
        }
        input.sort(Comparator.comparing(TextRange::start));
        for (TextRange next : input) {
            TextRange prev;
            if (!result.isEmpty() && spanCondition.test(prev = (TextRange)result.get(result.size() - 1), next)) {
                result.set(result.size() - 1, TextRange.span(next, prev));
                continue;
            }
            result.add(next);
        }
        return result;
    }
}

