/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.util.lang.JavaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.ConfigurableGradleBuildIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJvmAndGradleBuildIssue;", "Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "projectPath", "", "<init>", "(Lorg/gradle/util/GradleVersion;Lcom/intellij/util/lang/JavaVersion;Ljava/lang/String;)V", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nIncompatibleGradleJvmAndGradleIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncompatibleGradleJvmAndGradleIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/IncompatibleGradleJvmAndGradleBuildIssue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
final class IncompatibleGradleJvmAndGradleBuildIssue
extends ConfigurableGradleBuildIssue {
    public IncompatibleGradleJvmAndGradleBuildIssue(@Nullable GradleVersion gradleVersion, @Nullable JavaVersion javaVersion, @NotNull String projectPath) {
        GradleVersion gradleVersion2;
        GradleVersion gradleVersion3;
        JavaVersion javaVersion2;
        JavaVersion javaVersion3;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        GradleVersion gradleVersion4 = gradleVersion;
        if (gradleVersion4 != null) {
            GradleVersion it = gradleVersion4;
            boolean bl = false;
            javaVersion3 = GradleJvmSupportMatrix.Companion.suggestOldestSupportedJavaVersion(it);
        } else {
            javaVersion3 = null;
        }
        JavaVersion oldestCompatibleJavaVersion = javaVersion3;
        GradleVersion gradleVersion5 = gradleVersion;
        if (gradleVersion5 != null) {
            GradleVersion it = gradleVersion5;
            boolean bl = false;
            javaVersion2 = GradleJvmSupportMatrix.Companion.suggestLatestSupportedJavaVersion(it);
        } else {
            javaVersion2 = null;
        }
        JavaVersion latestCompatibleJavaVersion = javaVersion2;
        JavaVersion javaVersion4 = javaVersion;
        if (javaVersion4 != null) {
            JavaVersion it = javaVersion4;
            boolean bl = false;
            gradleVersion3 = GradleJvmSupportMatrix.Companion.suggestOldestSupportedGradleVersion(it);
        } else {
            gradleVersion3 = null;
        }
        GradleVersion oldestCompatibleGradleVersion = gradleVersion3;
        JavaVersion javaVersion5 = javaVersion;
        if (javaVersion5 != null) {
            JavaVersion it = javaVersion5;
            boolean bl = false;
            gradleVersion2 = GradleJvmSupportMatrix.Companion.suggestLatestSupportedGradleVersion(it);
        } else {
            gradleVersion2 = null;
        }
        GradleVersion latestCompatibleGradleVersion = gradleVersion2;
        GradleVersion recommendedGradleVersion = GradleJvmSupportMatrix.Companion.getRecommendedGradleVersionByIdea();
        String string = GradleBundle.message("gradle.build.issue.gradle.jvm.incompatible.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setTitle(string);
        if (javaVersion == null) {
            String string2 = GradleBundle.message("gradle.build.issue.gradle.jvm.incompatible.unknown.java.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.addDescription(string2);
        } else if (gradleVersion == null) {
            Object[] objectArray = new Object[]{javaVersion};
            String string3 = GradleBundle.message("gradle.build.issue.gradle.jvm.incompatible.unknown.gradle.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.addDescription(string3);
        } else {
            Object[] objectArray = new Object[]{javaVersion, gradleVersion.getVersion()};
            String string4 = GradleBundle.message("gradle.build.issue.gradle.jvm.incompatible.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            this.addDescription(string4);
        }
        if (gradleVersion != null && oldestCompatibleGradleVersion != null && gradleVersion.compareTo(oldestCompatibleGradleVersion) < 0) {
            if (gradleVersion.compareTo(recommendedGradleVersion) < 0 && GradleJvmSupportMatrix.Companion.isSupported(recommendedGradleVersion, javaVersion)) {
                Object[] objectArray = new Object[]{recommendedGradleVersion.getVersion()};
                String string5 = GradleBundle.message("gradle.build.issue.gradle.recommended.description", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                this.addDescription(string5);
                this.addGradleVersionQuickFix(projectPath, recommendedGradleVersion);
            }
            if (oldestCompatibleGradleVersion.compareTo(recommendedGradleVersion) < 0) {
                Object[] objectArray = new Object[]{oldestCompatibleGradleVersion.getVersion()};
                String string6 = GradleBundle.message("gradle.build.issue.gradle.compatible.minimum.description", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                this.addDescription(string6);
                this.addGradleVersionQuickFix(projectPath, oldestCompatibleGradleVersion);
            }
        } else if (gradleVersion != null && latestCompatibleGradleVersion != null && gradleVersion.compareTo(latestCompatibleGradleVersion) > 0) {
            Object[] objectArray = new Object[]{latestCompatibleGradleVersion.getVersion()};
            String string7 = GradleBundle.message("gradle.build.issue.gradle.compatible.maximum.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            this.addDescription(string7);
            this.addGradleVersionQuickFix(projectPath, latestCompatibleGradleVersion);
        }
        if (javaVersion != null && oldestCompatibleJavaVersion != null && javaVersion.compareTo(oldestCompatibleJavaVersion) < 0) {
            Object[] objectArray = new Object[]{oldestCompatibleJavaVersion};
            String string8 = GradleBundle.message("gradle.build.issue.gradle.jvm.compatible.minimum.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
            this.addDescription(string8);
            this.addGradleJvmQuickFix(projectPath, oldestCompatibleJavaVersion);
        } else if (javaVersion != null && latestCompatibleJavaVersion != null && javaVersion.compareTo(latestCompatibleJavaVersion) > 0) {
            Object[] objectArray = new Object[]{latestCompatibleJavaVersion};
            String string9 = GradleBundle.message("gradle.build.issue.gradle.jvm.compatible.maximum.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
            this.addDescription(string9);
            this.addGradleJvmQuickFix(projectPath, latestCompatibleJavaVersion);
        }
    }
}

