/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.ConfigurableGradleBuildIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/OutdatedGradleVersionIssue;", "Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "context", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;", "currentVersion", "Lorg/gradle/util/GradleVersion;", "<init>", "(Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;Lorg/gradle/util/GradleVersion;)V", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "addOpenInspectionSettingsQuickFix", "", "inspectionShortName", "", "OpenInspectionSettingsFix", "intellij.gradle"})
@ApiStatus.Internal
public final class OutdatedGradleVersionIssue
extends ConfigurableGradleBuildIssue {
    @NotNull
    private final GradleVersion currentVersion;

    public OutdatedGradleVersionIssue(@NotNull GradleExecutionContext context, @NotNull GradleVersion currentVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        this.currentVersion = currentVersion;
        GradleVersion latestVersion = GradleJvmSupportMatrix.Companion.getLatestMinorGradleVersion(this.currentVersion.getMajorVersion());
        String string = GradleBundle.message("gradle.build.issue.gradle.outdated.minor.version.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setTitle(string);
        Object[] objectArray = new Object[]{this.currentVersion.getVersion()};
        String string2 = GradleBundle.message("gradle.build.issue.gradle.outdated.minor.version.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.addDescription(string2);
        objectArray = new Object[]{latestVersion.getVersion()};
        String string3 = GradleBundle.message("gradle.build.issue.gradle.recommended.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.addDescription(string3);
        this.addGradleVersionQuickFix(context.getProjectPath(), latestVersion);
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        String basePath = string;
        return (Navigatable)ReadAction.compute(() -> OutdatedGradleVersionIssue.getNavigatable$lambda$0(basePath, project, this));
    }

    public final void addOpenInspectionSettingsQuickFix(@NotNull GradleExecutionContext context, @NotNull String inspectionShortName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inspectionShortName, (String)"inspectionShortName");
        String hyperlinkReference = this.addQuickFix(new OpenInspectionSettingsFix(context, inspectionShortName));
        Object[] objectArray = new Object[]{hyperlinkReference};
        String string = GradleBundle.message("gradle.build.quick.fix.edit.inspection.settings", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    private static final Navigatable getNavigatable$lambda$0(String $basePath, Project $project, OutdatedGradleVersionIssue this$0) {
        Path path = GradleUtil.findDefaultWrapperPropertiesFile(Path.of($basePath, new String[0]));
        if (path == null) {
            return null;
        }
        Path wrapperPropertiesPath = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(wrapperPropertiesPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof PropertiesFile)) {
            return null;
        }
        IProperty iProperty = ((PropertiesFile)psiFile2).findPropertyByKey("distributionUrl");
        if (iProperty == null) {
            return null;
        }
        IProperty distributionUrlProp = iProperty;
        String versionText = this$0.currentVersion.getVersion();
        PsiElement psiElement = distributionUrlProp.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement psiElement2 = psiElement;
        String string = psiElement2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        Intrinsics.checkNotNull((Object)versionText);
        int indexInProperty = StringsKt.indexOf$default((CharSequence)charSequence, (String)versionText, (int)0, (boolean)false, (int)6, null);
        if (indexInProperty < 0) {
            return null;
        }
        int indexInFile = psiElement2.getStartOffsetInParent() + indexInProperty + versionText.length();
        return (Navigatable)new OpenFileDescriptor($project, virtualFile2, indexInFile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/OutdatedGradleVersionIssue$OpenInspectionSettingsFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "context", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;", "inspectionShortName", "", "<init>", "(Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle"})
    private static final class OpenInspectionSettingsFix
    implements BuildIssueQuickFix {
        @NotNull
        private final GradleExecutionContext context;
        @NotNull
        private final String inspectionShortName;
        @NotNull
        private final String id;

        public OpenInspectionSettingsFix(@NotNull GradleExecutionContext context, @NotNull String inspectionShortName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)inspectionShortName, (String)"inspectionShortName");
            this.context = context;
            this.inspectionShortName = inspectionShortName;
            this.id = "open_inspection_settings";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.context.getProject());
            InspectionProfileImpl inspectionProfileImpl = projectProfileManager.getCurrentProfile();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
            InspectionProfileImpl inspectionProfile = inspectionProfileImpl;
            EditInspectionToolsSettingsAction.editToolSettings((Project)this.context.getProject(), (InspectionProfileImpl)inspectionProfile, (String)this.inspectionShortName);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
    }
}

