/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleJvmProviderId;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionContext;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;
import org.jetbrains.plugins.gradle.util.JavaHomeValidationStatus;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\f*\u00020\u000fH\u0002\u001a\f\u0010\u0012\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0003H\u0000\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"getGradleJvmLookupProvider", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "setupGradleJvm", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "updateGradleJvm", "externalProjectPath", "", "canUseGradleJavaHomeJdk", "", "Lorg/jetbrains/plugins/gradle/util/GradleJvmResolutionContext;", "canUseJavaHomeJdk", "findGradleJvm", "canUseProjectSdk", "resolveProjectJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "findRegisteredSdk", "sdk", "intellij.gradle"})
@JvmName(name="GradleJvmResolutionUtil")
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleJvmResolutionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJvmResolutionUtil.kt\norg/jetbrains/plugins/gradle/util/GradleJvmResolutionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class GradleJvmResolutionUtil {
    @NotNull
    public static final SdkLookupProvider getGradleJvmLookupProvider(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        return SdkLookupProvider.Companion.getInstance(project, (SdkLookupProvider.Id)new GradleJvmProviderId(projectSettings));
    }

    public static final void setupGradleJvm(@NotNull Project project, @NotNull GradleProjectSettings projectSettings, @NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        Path projectPath = Paths.get(projectSettings.getExternalProjectPath(), new String[0]);
        Intrinsics.checkNotNull((Object)projectPath);
        if (GradleDaemonJvmHelper.isProjectUsingDaemonJvmCriteria(projectPath, gradleVersion)) {
            return;
        }
        GradleJvmResolutionContext resolutionContext = new GradleJvmResolutionContext(project, projectPath, gradleVersion);
        projectSettings.setGradleJvm(GradleJvmResolutionUtil.findGradleJvm(resolutionContext));
        if (projectSettings.getGradleJvm() != null) {
            return;
        }
        if (GradleJvmResolutionUtil.canUseProjectSdk(resolutionContext)) {
            projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        } else if (GradleJvmResolutionUtil.canUseGradleJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#GRADLE_JAVA_HOME");
        } else if (GradleJvmResolutionUtil.canUseJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#JAVA_HOME");
        } else {
            SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withProject(project);
            Object[] objectArray = new Object[]{gradleVersion.getVersion()};
            String string = GradleBundle.message("gradle.jvm.resolution.lookup.reason", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SdkLookupBuilder sdkLookupBuilder2 = sdkLookupBuilder.withLookupReason(string).withVersionFilter(arg_0 -> GradleJvmResolutionUtil.setupGradleJvm$lambda$0(gradleVersion, arg_0));
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
            sdkLookupBuilder2.withSdkType(sdkType).withSdkHomeFilter(GradleJvmResolutionUtil::setupGradleJvm$lambda$1).onSdkNameResolved(arg_0 -> GradleJvmResolutionUtil.setupGradleJvm$lambda$2(projectSettings, project, arg_0)).onSdkResolved(arg_0 -> GradleJvmResolutionUtil.setupGradleJvm$lambda$3(projectSettings, arg_0)).executeLookup();
        }
    }

    public static final void updateGradleJvm(@NotNull Project project, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings settings = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings.getLinkedProjectSettings(externalProjectPath2);
        if (gradleProjectSettings == null) {
            return;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String string = projectSettings.getGradleJvm();
        if (string == null) {
            return;
        }
        String gradleJvm = string;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            return;
        }
        Sdk projectSdk = sdk;
        if (!Intrinsics.areEqual((Object)projectSdk.getName(), (Object)gradleJvm)) {
            return;
        }
        if (GradleDaemonJvmHelper.isProjectUsingDaemonJvmCriteria(projectSettings)) {
            return;
        }
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
    }

    private static final boolean canUseGradleJavaHomeJdk(GradleJvmResolutionContext $this$canUseGradleJavaHomeJdk) {
        GradleProperties properties = GradlePropertiesFile.getProperties($this$canUseGradleJavaHomeJdk.getProject(), $this$canUseGradleJavaHomeJdk.getExternalProjectPath());
        Property<String> property = properties.getJavaHomeProperty();
        String javaHome = property != null ? property.getValue() : null;
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseGradleJavaHomeJdk.getProject(), $this$canUseGradleJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final boolean canUseJavaHomeJdk(GradleJvmResolutionContext $this$canUseJavaHomeJdk) {
        boolean bl;
        Path localJavaHome = ExternalSystemJdkUtilKt.getLocalJavaHomeIfMatchesEel((EelDescriptor)EelProviderUtil.getEelDescriptor((Project)$this$canUseJavaHomeJdk.getProject()));
        Path path = localJavaHome;
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseJavaHomeJdk.getProject(), $this$canUseJavaHomeJdk.getGradleVersion(), path != null ? ((Object)path).toString() : null);
        JavaHomeValidationStatus javaHomeValidationStatus = validationStatus;
        if (Intrinsics.areEqual((Object)javaHomeValidationStatus, (Object)JavaHomeValidationStatus.Invalid.INSTANCE) || Intrinsics.areEqual((Object)javaHomeValidationStatus, (Object)JavaHomeValidationStatus.Undefined.INSTANCE) || javaHomeValidationStatus instanceof JavaHomeValidationStatus.Unsupported) {
            bl = false;
        } else if (javaHomeValidationStatus instanceof JavaHomeValidationStatus.Success) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final String findGradleJvm(GradleJvmResolutionContext $this$findGradleJvm) {
        GradleSettings gradleSettings = GradleSettings.getInstance($this$findGradleJvm.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings settings = gradleSettings;
        Collection collection = settings.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), GradleJvmResolutionUtil::findGradleJvm$lambda$0));
    }

    private static final boolean canUseProjectSdk(GradleJvmResolutionContext $this$canUseProjectSdk) {
        return GradleJvmResolutionUtil.resolveProjectJdk($this$canUseProjectSdk.getProject()) != null;
    }

    @Nullable
    public static final Sdk resolveProjectJdk(@NotNull Project $this$resolveProjectJdk) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveProjectJdk, (String)"<this>");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)$this$resolveProjectJdk);
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            return null;
        }
        Sdk projectSdk = sdk;
        Sdk sdk2 = ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk);
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"resolveDependentJdk(...)");
        Sdk resolvedSdk = sdk2;
        if (ExternalSystemJdkUtil.isValidJdk((Sdk)resolvedSdk)) {
            return resolvedSdk;
        }
        return null;
    }

    private static final Sdk findRegisteredSdk(Project project, Sdk sdk) {
        return (Sdk)ActionsKt.runReadAction(() -> GradleJvmResolutionUtil.findRegisteredSdk$lambda$0(project, sdk));
    }

    private static final boolean setupGradleJvm$lambda$0(GradleVersion $gradleVersion, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JavaVersion javaVersion = JavaVersion.Companion.tryParse(it);
        return javaVersion != null && GradleJvmSupportMatrix.Companion.isJavaSupportedByIdea(javaVersion) && GradleJvmSupportMatrix.Companion.isSupported($gradleVersion, javaVersion);
    }

    private static final boolean setupGradleJvm$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ExternalSystemJdkUtil.isValidJdk((String)it);
    }

    private static final Unit setupGradleJvm$lambda$2(GradleProjectSettings $projectSettings, Project $project, Sdk sdk) {
        Sdk fakeSdk;
        Sdk sdk2 = sdk;
        if (sdk2 != null) {
            Sdk it = sdk2;
            boolean bl = false;
            v1 = GradleJvmResolutionUtil.findRegisteredSdk($project, it);
        } else {
            v1 = fakeSdk = null;
        }
        if (fakeSdk != null && $projectSettings.getGradleJvm() == null) {
            $projectSettings.setGradleJvm(fakeSdk.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupGradleJvm$lambda$3(GradleProjectSettings $projectSettings, Sdk sdk) {
        if ($projectSettings.getGradleJvm() == null) {
            Sdk sdk2 = sdk;
            $projectSettings.setGradleJvm(sdk2 != null ? sdk2.getName() : null);
        }
        return Unit.INSTANCE;
    }

    private static final String findGradleJvm$lambda$0(GradleProjectSettings it) {
        return it.getGradleJvm();
    }

    private static final Sdk findRegisteredSdk$lambda$0(Project $project, Sdk $sdk) {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"getInstance(...)");
        ProjectJdkTable projectJdkTable2 = projectJdkTable;
        return projectJdkTable2.findJdk($sdk.getName(), $sdk.getSdkType().getName());
    }
}

