/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor;

import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.KtorUrlMapping;
import com.intellij.ktor.KtorUrlResolver;
import com.intellij.ktor.KtorUrlResolverKt;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ktor/KtorUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modules", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/module/Module;", "getModules", "()Lkotlin/sequences/Sequence;", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "getMatchingUrlMappings", "Lcom/intellij/ktor/KtorUrlMapping;", "allMappings", "", "urlPath", "Lcom/intellij/microservices/url/UrlPath;", "Factory", "intellij.ktor"})
public final class KtorUrlResolver
extends HttpUrlResolver {
    @NotNull
    private final Project project;

    public KtorUrlResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final Sequence<Module> getModules() {
        return ArraysKt.asSequence((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter(this.getModules(), (Function1)resolve.1.INSTANCE), arg_0 -> KtorUrlResolver.resolve$lambda$0(request, this, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter(this.getModules(), (Function1)getVariants.1.INSTANCE), KtorUrlResolver::getVariants$lambda$0));
    }

    private final Sequence<KtorUrlMapping> getMatchingUrlMappings(List<KtorUrlMapping> allMappings, UrlPath urlPath) {
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allMappings), arg_0 -> KtorUrlResolver.getMatchingUrlMappings$lambda$0(urlPath, arg_0));
    }

    private static final Sequence resolve$lambda$0$0(KtorUrlResolver this$0, List $allMappings, UrlPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this$0.getMatchingUrlMappings($allMappings, path);
    }

    private static final Iterable resolve$lambda$0(UrlResolveRequest $request, KtorUrlResolver this$0, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List allMappings = KtorUrlResolverKt.access$getAllUrlMappings(module);
        Sequence resolvedMappings = SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations($request.getPath()), arg_0 -> KtorUrlResolver.resolve$lambda$0$0(this$0, allMappings, arg_0));
        return KtorUrlResolverKt.access$getUrlTargetInfoForModule(module, SequencesKt.toList((Sequence)resolvedMappings));
    }

    private static final Iterable getVariants$lambda$0(Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return KtorUrlResolverKt.access$getUrlTargetInfoForModule(module, KtorUrlResolverKt.access$getAllUrlMappings(module));
    }

    private static final boolean getMatchingUrlMappings$lambda$0(UrlPath $urlPath, KtorUrlMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUrlPath().isCompatibleWith($urlPath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ktor/KtorUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ktor"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return KtorLibraryUtilKt.hasKtorServerLibrary(project) ? (UrlResolver)new KtorUrlResolver(project) : null;
        }
    }
}

