/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.yaml.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.ktor.configurations.meta.key.KtorMetaConfigKeyManager;
import com.intellij.ktor.configurations.yaml.completion.KtorYamlKeyCompletionProvider;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\f\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ktor/configurations/yaml/completion/KtorYamlKeyCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "CONFIG_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "ROOT_KEY", "INSERT_HANDLER", "com/intellij/ktor/configurations/yaml/completion/KtorYamlKeyCompletionProvider$INSERT_HANDLER$1", "Lcom/intellij/ktor/configurations/yaml/completion/KtorYamlKeyCompletionProvider$INSERT_HANDLER$1;", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorYamlKeyCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorYamlKeyCompletionProvider.kt\ncom/intellij/ktor/configurations/yaml/completion/KtorYamlKeyCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n777#2:89\n873#2,2:90\n*S KotlinDebug\n*F\n+ 1 KtorYamlKeyCompletionProvider.kt\ncom/intellij/ktor/configurations/yaml/completion/KtorYamlKeyCompletionProvider\n*L\n63#1:89\n63#1:90,2\n*E\n"})
public final class KtorYamlKeyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final Key<String> CONFIG_KEY;
    @NotNull
    private final Key<String> ROOT_KEY;
    @NotNull
    private final INSERT_HANDLER.1 INSERT_HANDLER;

    public KtorYamlKeyCompletionProvider() {
        Key key = Key.create((String)"ymlConfigKey");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.CONFIG_KEY = key;
        Key key2 = Key.create((String)"ymlRootKey");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        this.ROOT_KEY = key2;
        this.INSERT_HANDLER = new YamlKeyCompletionInsertHandler<LookupElementDecorator<LookupElementBuilder>>(this){
            final /* synthetic */ KtorYamlKeyCompletionProvider this$0;
            {
                this.this$0 = $receiver;
            }

            protected YAMLKeyValue createNewEntry(YAMLDocument document, LookupElementDecorator<LookupElementBuilder> item, YAMLKeyValue parent) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                Intrinsics.checkNotNullParameter(item, (String)"item");
                String rootQualifiedName = (String)item.getCopyableUserData(KtorYamlKeyCompletionProvider.access$getROOT_KEY$p(this.this$0));
                ConfigYamlAccessor defaultAccessor = new ConfigYamlAccessor(document, (MetaConfigKeyManager)KtorMetaConfigKeyManager.Companion.getInstance());
                String string = rootQualifiedName;
                YAMLKeyValue root = string != null ? defaultAccessor.findExistingKey(string) : null;
                ConfigYamlAccessor accessor = root != null ? new ConfigYamlAccessor((PsiElement)root, (MetaConfigKeyManager)KtorMetaConfigKeyManager.Companion.getInstance()) : defaultAccessor;
                String qualifiedKey = (String)item.getCopyableUserData(KtorYamlKeyCompletionProvider.access$getCONFIG_KEY$p(this.this$0));
                YAMLKeyValue yAMLKeyValue = accessor.findExistingKey(qualifiedKey);
                if (yAMLKeyValue == null && (yAMLKeyValue = accessor.create(qualifiedKey)) == null) {
                    Intrinsics.checkNotNull((Object)qualifiedKey);
                    throw new IllegalStateException(qualifiedKey.toString());
                }
                return yAMLKeyValue;
            }

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElementBuilder> item) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(item, (String)"item");
                super.handleInsert(context, (LookupElement)item);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLFile");
        YAMLFile yamlFile = (YAMLFile)psiFile;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)yamlFile));
        if (module == null) {
            return;
        }
        Module module2 = module;
        List<MetaConfigKey> configKeys = KtorMetaConfigKeyManager.Companion.getInstance().getAllMetaConfigKeys(module2);
        MetaConfigKeyManager.ConfigKeyNameBinder binder = KtorMetaConfigKeyManager.Companion.getInstance().getConfigKeyNameBinder(module2);
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement element = psiElement;
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)element);
        YAMLKeyValue parentYamlKeyValue = ConfigYamlUtils.getParentKeyValue((PsiElement)element, (PsiElement)originalElement);
        ConfigYamlUtils.addCompletionAddIfNeeded((CompletionParameters)parameters, (CompletionResultSet)result);
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)parentYamlKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String fullParentConfigName = string;
        List list = ConfigYamlUtils.getCurrentLineKeyComponents((PsiElement)((PsiElement)ObjectUtils.chooseNotNull((Object)originalElement, (Object)element)), (MetaConfigKeyManager.ConfigKeyNameBinder)binder, (String)fullParentConfigName, configKeys);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentLineKeyComponents(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var15_16 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LookupElement it = (LookupElement)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getLookupString(), (Object)"*"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List currentLineKeyComponents = (List)destination$iv$iv;
        if (!((Collection)currentLineKeyComponents).isEmpty()) {
            result.addAllElements((Iterable)currentLineKeyComponents);
        }
        int invocationCount = parameters.getInvocationCount();
        String parentConfigKeyName = parentYamlKeyValue == null || invocationCount > 1 ? "" : fullParentConfigName;
        ArrayList<LookupElement> keyLookupElements = new ArrayList<LookupElement>();
        for (MetaConfigKey configKey : configKeys) {
            LookupElementDecorator insertHandler;
            String configKeyName;
            if (((CharSequence)parentConfigKeyName).length() > 0 && !binder.matchesPrefix(configKey, parentConfigKeyName)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)configKey.getName(), (String)"getName(...)");
            LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
            builder.putCopyableUserData(this.CONFIG_KEY, (Object)configKeyName);
            Intrinsics.checkNotNullExpressionValue((Object)LookupElementDecorator.withInsertHandler((LookupElement)((LookupElement)builder), (InsertHandler)((InsertHandler)this.INSERT_HANDLER)), (String)"withInsertHandler(...)");
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)insertHandler);
            keyLookupElements.add(lookupElement);
        }
        result.addAllElements((Iterable)keyLookupElements);
        result.stopHere();
    }

    public static final /* synthetic */ Key access$getROOT_KEY$p(KtorYamlKeyCompletionProvider $this) {
        return $this.ROOT_KEY;
    }

    public static final /* synthetic */ Key access$getCONFIG_KEY$p(KtorYamlKeyCompletionProvider $this) {
        return $this.CONFIG_KEY;
    }
}

