/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.lineMapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.lineProfiler.lineMapping.IdLineMapping;
import com.intellij.profiler.lineProfiler.lineMapping.LineMapping;
import com.intellij.profiler.lineProfiler.lineMapping.LineMappingImpl;
import com.intellij.profiler.lineProfiler.lineMapping.LinesMapperKt;
import com.intellij.profiler.lineProfiler.lineMapping.OneDirectionMapping;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0014\u001a\u00020\u000eJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/lineProfiler/lineMapping/LinesMapper;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "myDocument", "Lcom/intellij/openapi/editor/Document;", "myDate", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;J)V", "lock", "myMapping", "Lcom/intellij/profiler/lineProfiler/lineMapping/LineMapping;", "myOldContent", "", "clear", "", "mapLinesFast", "mapLines", "doGetLineMapping", "extractOldContent", "loadFromVersionControl", "date", "intellij.profiler.lineProfiler"})
public final class LinesMapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Document myDocument;
    private final long myDate;
    @NotNull
    private final Object lock;
    @Nullable
    private LineMapping myMapping;
    @Nullable
    private byte[] myOldContent;

    public LinesMapper(@NotNull Project myProject, @NotNull VirtualFile myFile, @NotNull Document myDocument, long myDate) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)myDocument, (String)"myDocument");
        this.myProject = myProject;
        this.myFile = myFile;
        this.myDocument = myDocument;
        this.myDate = myDate;
        this.lock = new Object();
    }

    public final void clear() {
        this.myMapping = null;
    }

    @Nullable
    public final LineMapping mapLinesFast() {
        return this.myOldContent != null ? this.mapLines() : null;
    }

    @NotNull
    public final LineMapping mapLines() {
        LineMapping lineMapping;
        if (this.myMapping == null) {
            this.myMapping = this.doGetLineMapping();
        }
        if ((lineMapping = this.myMapping) == null) {
            lineMapping = IdLineMapping.INSTANCE;
        }
        return lineMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LineMapping doGetLineMapping() {
        byte[] $i$a$-synchronized-LinesMapper$doGetLineMapping$oldContent$22;
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-LinesMapper$doGetLineMapping$oldContent$22 = false;
            if (this.myOldContent == null) {
                this.extractOldContent();
            }
            $i$a$-synchronized-LinesMapper$doGetLineMapping$oldContent$22 = this.myOldContent;
        }
        byte[] oldContent = $i$a$-synchronized-LinesMapper$doGetLineMapping$oldContent$22;
        if (oldContent == null || oldContent == LinesMapperKt.access$getFAIL_MARKER$p()) {
            return null;
        }
        String[] previousLines = LinesMapperKt.access$getOldLines(oldContent, this.myFile);
        String[] currentLines = LinesMapperKt.access$getCurrentLines(this.myDocument);
        OneDirectionMapping oneDirectionMapping = LinesMapperKt.access$createMapping(previousLines, currentLines);
        if (oneDirectionMapping == null) {
            return null;
        }
        OneDirectionMapping oldToNew = oneDirectionMapping;
        OneDirectionMapping oneDirectionMapping2 = LinesMapperKt.access$createMapping(currentLines, previousLines);
        if (oneDirectionMapping2 == null) {
            return null;
        }
        OneDirectionMapping newToOld = oneDirectionMapping2;
        return new LineMappingImpl(oldToNew, newToOld);
    }

    @RequiresBackgroundThread
    private final void extractOldContent() {
        byte[] byteContent = LinesMapperKt.access$loadFromLocalHistory(this.myDate, this.myFile);
        if ((byteContent == null || byteContent.length == 0) && this.myFile.getTimeStamp() > this.myDate) {
            byteContent = this.loadFromVersionControl(this.myDate);
        }
        if (byteContent == null || byteContent.length == 0) {
            byteContent = LinesMapperKt.access$getFAIL_MARKER$p();
        }
        this.myOldContent = byteContent;
    }

    private final byte[] loadFromVersionControl(long date) {
        try {
            AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)this.myFile);
            if (abstractVcs == null) {
                return null;
            }
            AbstractVcs vcs = abstractVcs;
            VcsHistoryProvider vcsHistoryProvider = vcs.getVcsHistoryProvider();
            if (vcsHistoryProvider == null) {
                return null;
            }
            VcsHistoryProvider historyProvider = vcsHistoryProvider;
            FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(this.myFile);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePathOn(...)");
            FilePath filePath2 = filePath;
            VcsHistorySession vcsHistorySession = historyProvider.createSessionFor(filePath2);
            if (vcsHistorySession == null) {
                return null;
            }
            VcsHistorySession session = vcsHistorySession;
            List list = session.getRevisionList();
            if (list != null) {
                for (VcsFileRevision revision : list) {
                    Date revisionDate;
                    if (revision.getRevisionDate() == null) {
                        return null;
                    }
                    if (revisionDate.getTime() >= date) continue;
                    return revision.loadContent();
                }
            }
        }
        catch (Exception e) {
            LinesMapperKt.access$getLOG$p().info((Throwable)e);
            return null;
        }
        return null;
    }
}

