/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.lineMapping;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.lineProfiler.LineProfilerBundle;
import com.intellij.profiler.lineProfiler.lineMapping.MappingTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/lineProfiler/lineMapping/MappingGroupedTask;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "queue", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/profiler/lineProfiler/lineMapping/MappingTask;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "run", "", "task", "cancel", "createBackgroundTask", "intellij.profiler.lineProfiler"})
final class MappingGroupedTask {
    @NotNull
    private final Project project;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private ArrayDeque<MappingTask> queue;
    @Nullable
    private ProgressIndicator indicator;

    public MappingGroupedTask(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(@NotNull MappingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Lock lock = this.lock;
        lock.lock();
        try {
            Boolean bl;
            boolean bl2 = false;
            ArrayDeque q = this.queue;
            if (q != null) {
                bl = q.add((Object)task);
            } else {
                q = new ArrayDeque();
                q.add((Object)task);
                this.queue = q;
                this.createBackgroundTask();
                bl = Unit.INSTANCE;
            }
            Boolean bl3 = bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.queue = null;
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
            this.indicator = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void createBackgroundTask() {
        Project project = this.project;
        String string = LineProfilerBundle.message("progress.title.calculate.line.mappings", new Object[0]);
        new Task.Backgroundable(this, project, string){
            final /* synthetic */ MappingGroupedTask this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Object $i$a$-withLock-MappingGroupedTask$createBackgroundTask$1$run$32;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Lock lock = MappingGroupedTask.access$getLock$p(this.this$0);
                MappingGroupedTask mappingGroupedTask = this.this$0;
                lock.lock();
                try {
                    boolean $i$a$-withLock-MappingGroupedTask$createBackgroundTask$1$run$32 = false;
                    MappingGroupedTask.access$setIndicator$p(mappingGroupedTask, indicator);
                    $i$a$-withLock-MappingGroupedTask$createBackgroundTask$1$run$32 = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                int count = 0;
                while (true) {
                    Object[] objectArray;
                    $i$a$-withLock-MappingGroupedTask$createBackgroundTask$1$run$32 = MappingGroupedTask.access$getLock$p(this.this$0);
                    MappingGroupedTask mappingGroupedTask2 = this.this$0;
                    $i$a$-withLock-MappingGroupedTask$createBackgroundTask$1$run$32.lock();
                    try {
                        ArrayDeque arrayDeque;
                        boolean bl = false;
                        if (MappingGroupedTask.access$getQueue$p(mappingGroupedTask2) == null) {
                            return;
                        }
                        ArrayDeque q = arrayDeque;
                        if (q.isEmpty()) {
                            MappingGroupedTask.access$setQueue$p(mappingGroupedTask2, null);
                            return;
                        }
                        objectArray = TuplesKt.to((Object)q.removeLast(), (Object)(q.size() + 1));
                    }
                    finally {
                        $i$a$-withLock-MappingGroupedTask$createBackgroundTask$1$run$32.unlock();
                    }
                    mappingGroupedTask = objectArray;
                    MappingTask task = (MappingTask)mappingGroupedTask.component1();
                    int size = ((Number)mappingGroupedTask.component2()).intValue();
                    indicator.checkCanceled();
                    indicator.setFraction((double)count / (double)(count + size));
                    objectArray = new Object[]{task.getName()};
                    indicator.setText(LineProfilerBundle.message("progress.text.calculate.line.mappings.for", objectArray));
                    task.run();
                    ++count;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFinished() {
                Lock lock = MappingGroupedTask.access$getLock$p(this.this$0);
                MappingGroupedTask mappingGroupedTask = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    MappingGroupedTask.access$setIndicator$p(mappingGroupedTask, null);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }.queue();
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(MappingGroupedTask $this) {
        return $this.lock;
    }

    public static final /* synthetic */ void access$setIndicator$p(MappingGroupedTask $this, ProgressIndicator progressIndicator) {
        $this.indicator = progressIndicator;
    }

    public static final /* synthetic */ ArrayDeque access$getQueue$p(MappingGroupedTask $this) {
        return $this.queue;
    }

    public static final /* synthetic */ void access$setQueue$p(MappingGroupedTask $this, ArrayDeque arrayDeque) {
        $this.queue = arrayDeque;
    }
}

