/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRootStoredRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016J\u0012\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0018H\u0016R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/data/RootRefsModel;", "Lcom/intellij/vcs/log/VcsLogRootStoredRefs;", "refs", "", "Lcom/intellij/vcs/log/VcsRef;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "<init>", "(Ljava/lang/Iterable;Lcom/intellij/vcs/log/data/VcsLogStorage;)V", "tagsMapping", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "branchesMapping", "branches", "Lkotlin/sequences/Sequence;", "tags", "contains", "", "index", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "refsToCommit", "Lcom/intellij/util/SmartList;", "getRefsIndexes", "", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogRefsOfSingleRootFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogRefsOfSingleRootFactory.kt\ncom/intellij/vcs/log/data/RootRefsModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class RootRefsModel
implements VcsLogRootStoredRefs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectMap<Collection<VcsRef>> tagsMapping = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    @NotNull
    private final Int2ObjectMap<Collection<VcsRef>> branchesMapping = (Int2ObjectMap)new Int2ObjectOpenHashMap();

    private RootRefsModel(Iterable<? extends VcsRef> refs, VcsLogStorage storage) {
        VirtualFile root = null;
        for (VcsRef vcsRef : refs) {
            boolean bl;
            boolean bl2 = bl = root == null || Intrinsics.areEqual(root, (Object)vcsRef.getRoot());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "All references are supposed to be from the single root";
                throw new AssertionError((Object)string);
            }
            root = vcsRef.getRoot();
            Hash hash = vcsRef.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = vcsRef.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            int index = storage.getCommitIndex(hash, virtualFile);
            boolean bl3 = vcsRef.getType().isBranch() ? ((Collection)this.branchesMapping.computeIfAbsent(index, RootRefsModel::_init_$lambda$1)).add(vcsRef) : ((Collection)this.tagsMapping.computeIfAbsent(index, RootRefsModel::_init_$lambda$2)).add(vcsRef);
        }
    }

    @NotNull
    public Sequence<VcsRef> branches() {
        Collection collection = this.branchesMapping.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), RootRefsModel::branches$lambda$0);
    }

    @NotNull
    public Sequence<VcsRef> tags() {
        Collection collection = this.tagsMapping.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), RootRefsModel::tags$lambda$0);
    }

    public boolean contains(int index) {
        return this.branchesMapping.containsKey(index) || this.tagsMapping.containsKey(index);
    }

    @NotNull
    public SmartList<VcsRef> refsToCommit(int index) {
        SmartList result;
        block1: {
            Collection it;
            result = new SmartList();
            Collection collection = (Collection)this.branchesMapping.get(index);
            if (collection != null) {
                it = collection;
                boolean bl = false;
                result.addAll(it);
            }
            Collection collection2 = (Collection)this.tagsMapping.get(index);
            if (collection2 == null) break block1;
            it = collection2;
            boolean bl = false;
            result.addAll(it);
        }
        return result;
    }

    @NotNull
    public Collection<Integer> getRefsIndexes() {
        IntOpenHashSet result = new IntOpenHashSet(((IntSet)this.branchesMapping.keySet()).size() + ((IntSet)this.tagsMapping.keySet()).size());
        result.addAll((IntCollection)this.branchesMapping.keySet());
        result.addAll((IntCollection)this.tagsMapping.keySet());
        return (Collection)result;
    }

    private static final Collection _init_$lambda$1(int it) {
        return (Collection)new SmartList();
    }

    private static final Collection _init_$lambda$2(int it) {
        return (Collection)new SmartList();
    }

    private static final Sequence branches$lambda$0(Collection it) {
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.asSequence((Iterable)it);
    }

    private static final Sequence tags$lambda$0(Collection it) {
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.asSequence((Iterable)it);
    }

    @JvmStatic
    @NotNull
    public static final RootRefsModel create(@NotNull Iterable<? extends VcsRef> refs, @NotNull VcsLogStorage storage) {
        return Companion.create(refs, storage);
    }

    public /* synthetic */ RootRefsModel(Iterable refs, VcsLogStorage storage, DefaultConstructorMarker $constructor_marker) {
        this(refs, storage);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/data/RootRefsModel$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/vcs/log/data/RootRefsModel;", "refs", "", "Lcom/intellij/vcs/log/VcsRef;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RootRefsModel create(@NotNull Iterable<? extends VcsRef> refs, @NotNull VcsLogStorage storage) {
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return new RootRefsModel(refs, storage, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

