/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.metrics;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.MemoryUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.Metric;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricType;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricsStatus;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.providers.MetricProvider;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdserver.unattendedHost.metrics.CGroupMetricsReader;
import com.jetbrains.rdserver.unattendedHost.metrics.CGroupV1MetricsReader;
import com.jetbrains.rdserver.unattendedHost.metrics.CGroupV2MetricsReader;
import com.jetbrains.rdserver.unattendedHost.metrics.CpuMetricsProvider;
import com.jetbrains.rdserver.unattendedHost.metrics.DefaultCGroupMetricsReader;
import com.jetbrains.rdserver.unattendedHost.metrics.MemoryMetricsProvider;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\b\u0003\n\u0002\b\u0005*\u0002\"%\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001d\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider;", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/providers/MetricProvider;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "dataReaders", "", "Lcom/jetbrains/rdserver/unattendedHost/metrics/CGroupMetricsReader;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "memoryUpdate", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "memoryProperty", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$MemoryData;", "initialized", "", "getMetrics", "", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/Metric;", "updateServerMemoryData", "", "readMemoryFromLinux", "readMemoryData", "memoryMetric", "status", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;", "value", "", "memoryPercentageMetric", "com/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$memoryPercentageMetric$1", "(Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;D)Lcom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$memoryPercentageMetric$1;", "jvmMemoryPercentageMetric", "com/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$jvmMemoryPercentageMetric$1", "(Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;D)Lcom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$jvmMemoryPercentageMetric$1;", "Companion", "MemoryData", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nMemoryMetricsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryMetricsProvider.kt\ncom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n231#2,2:146\n*S KotlinDebug\n*F\n+ 1 MemoryMetricsProvider.kt\ncom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider\n*L\n113#1:146,2\n*E\n"})
public final class MemoryMetricsProvider
implements MetricProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final List<CGroupMetricsReader> dataReaders;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue memoryUpdate;
    @NotNull
    private final Property<MemoryData> memoryProperty;
    private boolean initialized;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String TOTAL_MEMORY_GB = "totalMemoryGb";
    @NotNull
    public static final String USED_MEMORY_GB = "usedMemoryGb";
    @NotNull
    public static final String USED_MEMORY_PERCENTAGE = "usedMemoryPercentage";
    @NotNull
    public static final String MAX_AVAILABLE_JVM_MEMORY_GB = "maxAvailableJvmMemoryGb";
    @NotNull
    public static final String USED_JVM_MEMORY_GB = "usedJvmMemoryGb";
    @NotNull
    public static final String USED_JVM_MEMORY_PERCENTAGE = "usedJvmMemoryPercentage";
    private static final long gbCoefficientFromKb = 0x100000L;
    private static final long gbCoefficient = 0x40000000L;

    public MemoryMetricsProvider() {
        this.id = "memoryMetrics";
        Object[] objectArray = new CGroupMetricsReader[]{CGroupV1MetricsReader.Companion.getINSTANCE(), CGroupV2MetricsReader.Companion.getINSTANCE(), DefaultCGroupMetricsReader.INSTANCE};
        this.dataReaders = CollectionsKt.listOf((Object[])objectArray);
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()), (String)"MemoryMetricsProviderQueue");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.memoryUpdate = new MergingUpdateQueue(string, 10000, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, false);
        this.memoryProperty = new Property((Object)new MemoryData(0.0, 0.0));
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Map<String, Metric> getMetrics() {
        LOG.trace("Updating RAM data");
        if (!this.initialized) {
            this.updateServerMemoryData();
            this.initialized = true;
        }
        this.memoryUpdate.queue(Update.Companion.create((Object)"laUpdate", () -> MemoryMetricsProvider.getMetrics$lambda$0(this)));
        Runtime runtime = Runtime.getRuntime();
        double percentageForMemory = ((MemoryData)this.memoryProperty.getValue()).getTotal() > 0.001 ? (double)100 * ((MemoryData)this.memoryProperty.getValue()).getUsed() / ((MemoryData)this.memoryProperty.getValue()).getTotal() : 0.0;
        Metric totalMetric = this.memoryMetric(MetricsStatus.NORMAL, ((MemoryData)this.memoryProperty.getValue()).getTotal());
        Metric usedMetric = this.memoryMetric(MetricsStatus.NORMAL, ((MemoryData)this.memoryProperty.getValue()).getUsed());
        memoryPercentageMetric.1 usedPercentageMetric = this.memoryPercentageMetric(MetricProvider.Companion.calculateMetricStatus((Comparable)Double.valueOf(percentageForMemory), (Comparable)Double.valueOf(80.0), (Comparable)Double.valueOf(95.0)), percentageForMemory);
        double max = (double)runtime.maxMemory() / 1.073741824E9;
        double used = (double)(runtime.totalMemory() - runtime.freeMemory()) / 1.073741824E9;
        double percentageForJvmMemory = (double)100 * used / max;
        Metric maxJvmMetric = this.memoryMetric(MetricsStatus.NORMAL, max);
        Metric usedJvmMetric = this.memoryMetric(MetricsStatus.NORMAL, used);
        jvmMemoryPercentageMetric.1 usedJvmPercentageMetric = this.jvmMemoryPercentageMetric(MetricProvider.Companion.calculateMetricStatus((Comparable)Double.valueOf(percentageForJvmMemory), (Comparable)Double.valueOf(95.0), (Comparable)Double.valueOf(99.9)), percentageForJvmMemory);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TOTAL_MEMORY_GB, (Object)totalMetric), TuplesKt.to((Object)USED_MEMORY_GB, (Object)usedMetric), TuplesKt.to((Object)USED_MEMORY_PERCENTAGE, (Object)((Object)usedPercentageMetric)), TuplesKt.to((Object)MAX_AVAILABLE_JVM_MEMORY_GB, (Object)maxJvmMetric), TuplesKt.to((Object)USED_JVM_MEMORY_GB, (Object)usedJvmMetric), TuplesKt.to((Object)USED_JVM_MEMORY_PERCENTAGE, (Object)((Object)usedJvmPercentageMetric))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final void updateServerMemoryData() {
        if (SystemInfo.isLinux) {
            this.readMemoryFromLinux();
        } else {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystemMXBean, (String)"getPlatformMXBean(...)");
            OperatingSystemMXBean mxBean = operatingSystemMXBean;
            double totalRAM = (double)mxBean.getTotalMemorySize() / 1.073741824E9;
            Long l = MemoryUtil.getUnusedMemory();
            long unusedRAM = l != null ? l.longValue() : mxBean.getFreeMemorySize();
            double usedRAM = totalRAM - (double)unusedRAM / 1.073741824E9;
            this.memoryProperty.set((Object)new MemoryData(totalRAM, usedRAM));
        }
    }

    private final void readMemoryFromLinux() {
        try {
            this.memoryProperty.set((Object)this.readMemoryData());
        }
        catch (Throwable e) {
            CpuMetricsProvider.Companion.getLOG().warn("Failed to read memory data", e);
        }
    }

    private final MemoryData readMemoryData() {
        Object element$iv2;
        block3: {
            Iterable $this$first$iv = this.dataReaders;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                CGroupMetricsReader it = (CGroupMetricsReader)element$iv2;
                boolean bl = false;
                if (!it.isAcceptable()) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        CGroupMetricsReader reader = (CGroupMetricsReader)element$iv2;
        Long l = reader.getMemoryUsed();
        if (l == null) {
            throw new RuntimeException("Failed to read used memory data");
        }
        long usedRam = l;
        Long l2 = reader.getAvailableMemory();
        if (l2 == null) {
            throw new RuntimeException("Failed to read available memory data");
        }
        long totalRAM = l2;
        return new MemoryData((double)totalRAM / 1.073741824E9, (double)usedRam / 1.073741824E9);
    }

    private final Metric memoryMetric(MetricsStatus status, double value) {
        return new Metric(MetricType.PERFORMANCE, status, (Object)value);
    }

    private final memoryPercentageMetric.1 memoryPercentageMetric(MetricsStatus status, double value) {
        MetricType metricType = MetricType.PERFORMANCE;
        return new Metric(status, value, metricType){

            public String toString() {
                if (this.getStatusProperty().getValue() == MetricsStatus.DANGER) {
                    Object[] objectArray = new Object[1];
                    String string = "%.0f";
                    Object[] objectArray2 = new Object[]{this.getValueProperty().getValue()};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                    return PlatformSplitBundle.INSTANCE.message("metrics.server.ram.full.label", objectArray);
                }
                Object[] objectArray = new Object[1];
                String string = "%.0f";
                Object[] objectArray3 = new Object[]{this.getValueProperty().getValue()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
                return PlatformSplitBundle.INSTANCE.message("metrics.server.ram.label", objectArray);
            }
        };
    }

    private final jvmMemoryPercentageMetric.1 jvmMemoryPercentageMetric(MetricsStatus status, double value) {
        MetricType metricType = MetricType.PERFORMANCE;
        return new Metric(status, value, metricType){

            public String toString() {
                if (this.getStatusProperty().getValue() == MetricsStatus.DANGER) {
                    Object[] objectArray = new Object[1];
                    String string = "%.0f";
                    Object[] objectArray2 = new Object[]{this.getValueProperty().getValue()};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                    return PlatformSplitBundle.INSTANCE.message("metrics.jvm.ram.full.label", objectArray);
                }
                Object[] objectArray = new Object[1];
                String string = "%.0f";
                Object[] objectArray3 = new Object[]{this.getValueProperty().getValue()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
                return PlatformSplitBundle.INSTANCE.message("metrics.jvm.ram.label", objectArray);
            }
        };
    }

    private static final void getMetrics$lambda$0(MemoryMetricsProvider this$0) {
        this$0.updateServerMemoryData();
    }

    static {
        Logger logger = Logger.getInstance(MemoryMetricsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TOTAL_MEMORY_GB", "", "USED_MEMORY_GB", "USED_MEMORY_PERCENTAGE", "MAX_AVAILABLE_JVM_MEMORY_GB", "USED_JVM_MEMORY_GB", "USED_JVM_MEMORY_PERCENTAGE", "gbCoefficientFromKb", "", "gbCoefficient", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/MemoryMetricsProvider$MemoryData;", "", "total", "", "used", "<init>", "(DD)V", "getTotal", "()D", "getUsed", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.remoteController.backend"})
    public static final class MemoryData {
        private final double total;
        private final double used;

        public MemoryData(double total, double used) {
            this.total = total;
            this.used = used;
        }

        public final double getTotal() {
            return this.total;
        }

        public final double getUsed() {
            return this.used;
        }

        public final double component1() {
            return this.total;
        }

        public final double component2() {
            return this.used;
        }

        @NotNull
        public final MemoryData copy(double total, double used) {
            return new MemoryData(total, used);
        }

        public static /* synthetic */ MemoryData copy$default(MemoryData memoryData, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = memoryData.total;
            }
            if ((n & 2) != 0) {
                d2 = memoryData.used;
            }
            return memoryData.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "MemoryData(total=" + this.total + ", used=" + this.used + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.total);
            result = result * 31 + Double.hashCode(this.used);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MemoryData)) {
                return false;
            }
            MemoryData memoryData = (MemoryData)other;
            if (Double.compare(this.total, memoryData.total) != 0) {
                return false;
            }
            return Double.compare(this.used, memoryData.used) == 0;
        }
    }
}

