/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.restassured;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.lang.injection.general.SimpleInjection;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.microservices.jvm.restassured.RestAssuredBodyLanguageInjectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/jvm/restassured/RestAssuredBodyLanguageInjector;", "Lcom/intellij/lang/injection/general/LanguageInjectionContributor;", "<init>", "()V", "getInjection", "Lcom/intellij/lang/injection/general/Injection;", "host", "Lcom/intellij/psi/PsiElement;", "hasRestAssured", "", "project", "Lcom/intellij/openapi/project/Project;", "isTargetMethod", "uCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nRestAssuredBodyLanguageInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestAssuredBodyLanguageInjector.kt\ncom/intellij/microservices/jvm/restassured/RestAssuredBodyLanguageInjector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class RestAssuredBodyLanguageInjector
implements LanguageInjectionContributor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Injection getInjection(@NotNull PsiElement host) {
        String string;
        block24: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Project project = host.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (project2.isDefault()) {
                return null;
            }
            if (!this.hasRestAssured(project2)) {
                return null;
            }
            UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)host, UInjectionHost.class);
            if (uInjectionHost == null) {
                return null;
            }
            UInjectionHost uInjectionHost2 = uInjectionHost;
            UExpression roomExpression = uInjectionHost2.getStringRoomExpression();
            UCallExpression uCallExpression = UastUtils.getUCallExpression((UElement)roomExpression.getUastParent(), (int)1);
            if (!this.isTargetMethod(uCallExpression)) {
                return null;
            }
            UCallExpression uCallExpression2 = uCallExpression;
            UElement uElement = uCallExpression2 != null ? uCallExpression2.getUastParent() : null;
            if (!(uElement instanceof UExpression)) return null;
            UExpression uExpression = (UExpression)uElement;
            if (uExpression == null) {
                return null;
            }
            UExpression chainExpression = uExpression;
            Iterable iterable = UastUtils.getQualifiedChain((UExpression)chainExpression);
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                if (!(it instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)it).getMethodName(), (Object)"contentType"))) continue;
                string = (String)t;
                break block24;
            }
            string = null;
        }
        String string2 = string;
        if (!(string2 instanceof UCallExpression)) return null;
        UCallExpression uCallExpression = (UCallExpression)string2;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression contentTypeCall = uCallExpression;
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)contentTypeCall.getValueArguments());
        if (uExpression == null) {
            return null;
        }
        UExpression firstArg = uExpression;
        if (firstArg instanceof UReferenceExpression) {
            Injection injection;
            string2 = ((UReferenceExpression)firstArg).getResolvedName();
            if (Intrinsics.areEqual((Object)string2, (Object)"JSON")) {
                Language language = Language.findLanguageByID((String)"JSON");
                Intrinsics.checkNotNull((Object)language);
                injection = (Injection)new SimpleInjection(language, "", "", "java");
                return injection;
            } else {
                if (!Intrinsics.areEqual((Object)string2, (Object)"XML")) return null;
                injection = (Injection)new SimpleInjection((Language)XMLLanguage.INSTANCE, "", "", "java");
            }
            return injection;
        }
        string2 = UastUtils.evaluateString((UExpression)firstArg);
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case -1248326952: {
                if (string2.equals("application/xml")) {
                    n = 1;
                }
                break;
            }
            case -43840953: {
                if (string2.equals("application/json")) {
                    n = 2;
                }
                break;
            }
            case -1004727243: {
                if (string2.equals("text/xml")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                Language language = Language.findLanguageByID((String)"JSON");
                Intrinsics.checkNotNull((Object)language);
                Injection injection = (Injection)new SimpleInjection(language, "", "", "java");
                return injection;
            }
            case 1: {
                Injection injection = (Injection)new SimpleInjection((Language)XMLLanguage.INSTANCE, "", "", "java");
                return injection;
            }
            case 3: {
                Injection injection = (Injection)new SimpleInjection((Language)XMLLanguage.INSTANCE, "", "", "java");
                return injection;
            }
            default: {
                return null;
            }
        }
    }

    private final boolean hasRestAssured(Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"io.rest-assured:rest-assured");
    }

    private final boolean isTargetMethod(UCallExpression uCallExpression) {
        PsiMethod psiMethod;
        if (uCallExpression == null) {
            return false;
        }
        return uCallExpression.isMethodNameOneOf((Collection)RestAssuredBodyLanguageInjectorKt.access$getBODY_METHOD_NAME$p()) && Intrinsics.areEqual((Object)((psiMethod = uCallExpression.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"io.restassured.specification.RequestSpecification");
    }
}

