/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0012\u001a\u00020\tJ\b\u0010\u0013\u001a\u00020\tH\u0002J\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0011R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jpa/jpb/model/ui/ValidationSupport;", "", "validateAll", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "setErrorText", "Lkotlin/Function1;", "", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/Alarm;", "validationRunning", "", "startValidation", "doValidation", "stopValidation", "hasErrors", "intellij.javaee.jpa.jpb.model.ui"})
public final class ValidationSupport {
    @NotNull
    private final Function0<List<ValidationInfo>> validateAll;
    @NotNull
    private final Function1<String, Unit> setErrorText;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final Alarm alarm;
    private boolean validationRunning;

    public ValidationSupport(@NotNull Function0<? extends List<ValidationInfo>> validateAll, @NotNull Function1<? super String, Unit> setErrorText, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(validateAll, (String)"validateAll");
        Intrinsics.checkNotNullParameter(setErrorText, (String)"setErrorText");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.validateAll = validateAll;
        this.setErrorText = setErrorText;
        this.parentDisposable = parentDisposable;
        this.alarm = new Alarm(this.parentDisposable);
    }

    public final void startValidation() {
        if (this.validationRunning) {
            return;
        }
        this.validationRunning = true;
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(this::doValidation, 300);
    }

    private final void doValidation() {
        if (Disposer.isDisposed((Disposable)this.parentDisposable) || !this.validationRunning) {
            return;
        }
        List infos = (List)this.validateAll.invoke();
        if (infos.isEmpty()) {
            this.setErrorText.invoke(null);
        } else {
            for (ValidationInfo info : infos) {
                if (info.component != null) continue;
                this.setErrorText.invoke((Object)info.message);
            }
        }
        this.alarm.addRequest(this::doValidation, 300);
    }

    public final void stopValidation() {
        if (!this.validationRunning) {
            return;
        }
        this.validationRunning = false;
        this.alarm.cancelAllRequests();
    }

    public final boolean hasErrors() {
        return !((Collection)this.validateAll.invoke()).isEmpty();
    }
}

