/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.ptable;

import com.intellij.jpa.jpb.model.ui.SSwingUtilKt;
import com.intellij.jpa.jpb.model.ui.ptable.PTableItem;
import com.intellij.util.ui.UIUtil;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u000e\b\u0002\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0007J\u0014\u0010\u000e\u001a\u00020\u00052\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0014\u0010\u0013\u001a\u00020\u00052\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jpa/jpb/model/ui/ptable/PTableRenderUtils;", "", "<init>", "()V", "DEFAULT_ICON_WIDTH", "", "getAbbreviatedText", "", "table", "Ljavax/swing/JTable;", "col", "text", "item", "Lcom/intellij/jpa/jpb/model/ui/ptable/PTableItem;", "getIconWithSpacingWidth", "getAfterIconSpacing", "iconWidth", "getBeforeIconSpacing", "depth", "getDepth", "tableItem", "intellij.javaee.jpa.jpb.model.ui"})
public final class PTableRenderUtils {
    @NotNull
    public static final PTableRenderUtils INSTANCE = new PTableRenderUtils();
    private static final int DEFAULT_ICON_WIDTH = SSwingUtilKt.getScaled(16);

    private PTableRenderUtils() {
    }

    @JvmStatic
    @Nls
    @NotNull
    public static final String getAbbreviatedText(@NotNull JTable table, int col, @NotNull String text, @Nullable PTableItem<?> item) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String abbreviatedText = StringUtils.rightPad((String)text, (int)SSwingUtilKt.getScaled(5), (String)" ");
        int length = abbreviatedText.length();
        int iconWithSpacingWidth = col == 0 && item != null ? PTableRenderUtils.getIconWithSpacingWidth(item) : 0;
        int width = table.getColumnModel().getColumn(col).getWidth();
        while (width < iconWithSpacingWidth + table.getFontMetrics(table.getFont()).stringWidth(abbreviatedText) && length > 4) {
            abbreviatedText = StringUtils.abbreviate((String)abbreviatedText, (int)(--length));
        }
        String string = abbreviatedText;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static /* synthetic */ String getAbbreviatedText$default(JTable jTable, int n, String string, PTableItem pTableItem, int n2, Object object) {
        if ((n2 & 8) != 0) {
            pTableItem = null;
        }
        return PTableRenderUtils.getAbbreviatedText(jTable, n, string, pTableItem);
    }

    @JvmStatic
    public static final int getIconWithSpacingWidth(@NotNull PTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return PTableRenderUtils.getBeforeIconSpacing(PTableRenderUtils.getDepth(item), DEFAULT_ICON_WIDTH) + DEFAULT_ICON_WIDTH + PTableRenderUtils.getAfterIconSpacing(DEFAULT_ICON_WIDTH);
    }

    @JvmStatic
    public static final int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    @JvmStatic
    public static final int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = RangesKt.coerceAtLeast((int)0, (int)(UIUtil.getTreeLeftChildIndent() - iconWidth / 2));
        return nodeIndent * depth + leftIconOffset;
    }

    @JvmStatic
    public static final int getDepth(@NotNull PTableItem<?> tableItem) {
        Intrinsics.checkNotNullParameter(tableItem, (String)"tableItem");
        PTableItem item = tableItem;
        int result = 0;
        while (item.getParent() != null) {
            ++result;
            Intrinsics.checkNotNull((Object)item.getParent());
        }
        return result;
    }
}

