/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.jpa.jpb.model.generator.InsertPosition;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/jpa/jpb/model/util/HEditorUtil;", "", "<init>", "()V", "Companion", "intellij.javaee.jpa.jpb.model"})
public final class HEditorUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jpa/jpb/model/util/HEditorUtil$Companion;", "", "<init>", "()V", "findAnchorBeforeMethod", "Lcom/intellij/psi/PsiMethod;", "editor", "Lcom/intellij/openapi/editor/Editor;", "entityClass", "Lcom/intellij/psi/PsiClass;", "getElementAtCaret", "Lcom/intellij/psi/PsiElement;", "getCaretOffset", "", "aClass", "insertPosition", "Lcom/intellij/jpa/jpb/model/generator/InsertPosition;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiMethod findAnchorBeforeMethod(@NotNull Editor editor, @NotNull PsiClass entityClass) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
            int caretOffset = editor.getCaretModel().getOffset();
            PsiMethod anchorMethod = null;
            int minDistance = Integer.MAX_VALUE;
            PsiMethod[] psiMethodArray = entityClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
            for (PsiMethod existMethod : psiMethodArray) {
                int distance;
                TextRange textRange;
                int startOffset;
                if (existMethod.getTextRange() == null || (startOffset = textRange.getStartOffset()) < caretOffset || (distance = startOffset - caretOffset) >= minDistance) continue;
                anchorMethod = existMethod;
                minDistance = distance;
            }
            return anchorMethod;
        }

        @Nullable
        public final PsiElement getElementAtCaret(@NotNull Editor $this$getElementAtCaret) {
            Intrinsics.checkNotNullParameter((Object)$this$getElementAtCaret, (String)"<this>");
            int offset = $this$getElementAtCaret.getCaretModel().getOffset();
            Project project = $this$getElementAtCaret.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile($this$getElementAtCaret.getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            return psiFile2.findElementAt(offset);
        }

        public final int getCaretOffset(@NotNull PsiClass aClass, @NotNull Editor editor, @NotNull InsertPosition insertPosition) {
            Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)insertPosition), (String)"insertPosition");
            Object t = TemplateHelper.Companion.getInstance((PsiElement)aClass);
            Intrinsics.checkNotNull(t);
            TemplateHelper templateHelper = (TemplateHelper)t;
            PsiField[] psiFieldArray = aClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            PsiField[] fields = psiFieldArray;
            int caretOffset = -1;
            TemplateHelper templateHelper2 = templateHelper;
            Intrinsics.checkNotNull((Object)templateHelper2);
            PsiElement rBrace = templateHelper2.getRBrace(aClass);
            if (insertPosition == InsertPosition.Caret) {
                caretOffset = editor.getCaretModel().getOffset();
                int maxOffset = Integer.MAX_VALUE;
                if (rBrace != null) {
                    maxOffset = rBrace.getNavigationElement().getTextOffset() - 1;
                }
                if (maxOffset < caretOffset) {
                    caretOffset = maxOffset;
                }
            } else if (insertPosition == InsertPosition.First) {
                PsiField firstField = StreamEx.of((Object[])Arrays.copyOf(fields, fields.length)).findFirst(arg_0 -> Companion.getCaretOffset$lambda$1(Companion::getCaretOffset$lambda$0, arg_0)).orElse(null);
                if (firstField == null) {
                    PsiElement lBrace = templateHelper.getLBrace(aClass);
                    if (lBrace != null) {
                        caretOffset = lBrace.getNavigationElement().getTextOffset() + 1;
                    }
                } else {
                    caretOffset = firstField.getNavigationElement().getTextRange().getStartOffset() - 1;
                }
            } else if (insertPosition == InsertPosition.Last) {
                if (rBrace != null) {
                    caretOffset = rBrace.getNavigationElement().getTextOffset() - 1;
                }
            } else if (fields.length != 0) {
                PsiField lastField = fields[fields.length - 1];
                caretOffset = lastField.getNavigationElement().getTextRange().getEndOffset() + 1;
            } else {
                PsiElement lBrace = aClass.getLBrace();
                if (lBrace != null) {
                    caretOffset = lBrace.getNavigationElement().getTextOffset() + 1;
                }
            }
            return caretOffset;
        }

        private static final boolean getCaretOffset$lambda$0(PsiField psiField) {
            PsiField psiField2 = psiField;
            Intrinsics.checkNotNull((Object)psiField2);
            return !psiField2.hasModifierProperty("static");
        }

        private static final boolean getCaretOffset$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

