/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingArrayInitializerBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            MissingArrayInitializerBraceFixer.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof PsiArrayInitializerExpression) && !(psiElement instanceof PsiArrayInitializerMemberValue)) {
            return;
        }
        PsiElement child = psiElement.getFirstChild();
        if (!PsiUtil.isJavaToken(child, JavaTokenType.LBRACE)) {
            return;
        }
        if (!EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace((Editor)editor, (int)child.getTextRange().getEndOffset(), (FileType)psiElement.getContainingFile().getFileType())) {
            return;
        }
        PsiElement anchor = PsiTreeUtil.getChildOfType((PsiElement)psiElement, PsiErrorElement.class);
        if (anchor == null) {
            PsiElement last = PsiTreeUtil.getDeepestVisibleLast((PsiElement)psiElement);
            while (PsiUtil.isJavaToken(last, JavaTokenType.RBRACE)) {
                last = PsiTreeUtil.prevCodeLeaf((PsiElement)last);
            }
            if (last != null && PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)last, (boolean)true)) {
                anchor = last;
            }
        }
        int endOffset = (anchor != null ? anchor : psiElement).getTextRange().getEndOffset();
        editor.getDocument().insertString(endOffset, (CharSequence)"}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/MissingArrayInitializerBraceFixer", "apply"));
    }
}

