/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingLambdaBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiElement body2;
        if (psiElement == null) {
            MissingLambdaBodyFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)psiElement;
            body2 = lambda.getBody();
        } else if (psiElement instanceof PsiSwitchLabeledRuleStatement) {
            PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)psiElement;
            body2 = rule.getBody();
        } else {
            return;
        }
        if (body2 != null) {
            return;
        }
        Document doc = editor.getDocument();
        PsiElement arrow = PsiTreeUtil.getDeepestVisibleLast((PsiElement)psiElement);
        if (!PsiUtil.isJavaToken(arrow, JavaTokenType.ARROW)) {
            return;
        }
        int offset = arrow.getTextRange().getEndOffset();
        doc.insertString(offset, (CharSequence)"{\n}");
        editor.getCaretModel().moveToOffset(offset + 1);
        processor.commit(editor);
        processor.reformat(psiElement);
        processor.setSkipEnter(psiElement instanceof PsiLambdaExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/MissingLambdaBodyFixer", "apply"));
    }
}

