/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingThrowExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            MissingThrowExpressionFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)psiElement;
            @Nullable PsiExpression exception = throwStatement.getException();
            if (exception != null) {
                int expressionLine = MissingThrowExpressionFixer.startLine(editor, exception);
                if (MissingThrowExpressionFixer.startLine(editor, throwStatement) == expressionLine) {
                    return;
                }
                if (editor.getDocument().getLineNumber(editor.getCaretModel().getOffset()) == expressionLine) {
                    return;
                }
            }
            int startOffset = throwStatement.getTextRange().getStartOffset();
            if (exception != null) {
                editor.getDocument().insertString(startOffset + "throw".length(), (CharSequence)";");
            }
            processor.registerUnresolvedError(startOffset + "throw".length());
        }
    }

    private static int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/MissingThrowExpressionFixer", "apply"));
    }
}

