/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.OldParserWhiteSpaceAndCommentSetHolder;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class StatementParser {
    private static final TokenSet YIELD_STMT_INDICATOR_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.EXCL, JavaTokenType.TILDE, JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD, JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.STRING_LITERAL, JavaTokenType.INTEGER_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.TEXT_BLOCK_LITERAL, JavaTokenType.IDENTIFIER, JavaTokenType.SWITCH_KEYWORD, JavaTokenType.NEW_KEYWORD, JavaTokenType.LPARENTH, JavaTokenType.RBRACE, JavaTokenType.SEMICOLON, JavaTokenType.CASE_KEYWORD});
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD});
    private final JavaParser myParser;
    private final OldParserWhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public StatementParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = OldParserWhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(1);
        }
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder, boolean isStatement) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(2);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        return PsiBuilderUtil.parseBlockLazy((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACE, (IElementType)JavaTokenType.RBRACE, (IElementType)JavaElementType.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder, boolean parseUntilEof) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(3);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        JavaParserUtil.done(codeBlock, (IElementType)JavaElementType.CODE_BLOCK, builder, this.myWhiteSpaceAndCommentSetHolder);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaPsiBundle.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaPsiBundle.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaPsiBundle.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker statement;
        IElementType tokenType;
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(5);
        }
        if ((tokenType = builder.getTokenType()) == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return this.parseBreakStatement(builder);
        }
        if (StatementParser.isStmtYieldToken(builder, tokenType)) {
            return this.parseYieldStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return this.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(empty, JavaElementType.EMPTY_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            boolean nonSealed = DeclarationParser.isNonSealedToken(builder, tokenType);
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            StatementParser.skipQualifiedName(builder);
            IElementType current = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (current == JavaTokenType.LT || current == JavaTokenType.DOT && next == JavaTokenType.AT || nonSealed) {
                PsiBuilder.Marker declStatement = builder.mark();
                if (this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK) != null) {
                    JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                    return declStatement;
                }
                ReferenceParser.TypeInfo type = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
                if (!(current != JavaTokenType.LT || type != null && type.isParameterized)) {
                    declStatement.rollbackTo();
                } else {
                    if (type == null || builder.getTokenType() != JavaTokenType.DOUBLE_COLON) {
                        JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        if (type == null) {
                            builder.advanceLexer();
                        }
                        JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                        return declStatement;
                    }
                    declStatement.rollbackTo();
                }
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        IElementType incompleteDeclarationRestrictedTokenType = null;
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                JavaParserUtil.done(list, JavaElementType.EXPRESSION_LIST, builder, this.myWhiteSpaceAndCommentSetHolder);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_LIST_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                return statement2;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop((PsiBuilder.Marker[])new PsiBuilder.Marker[]{list, pos});
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                return statement2;
            }
            boolean singleToken = expr.getEndIndex() - expr.getStartIndex() == 1;
            pos.rollbackTo();
            if (singleToken && builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                String text = builder.getTokenText();
                if ("record".equals(text) && JavaFeature.RECORDS.isSufficient(JavaParserUtil.getLanguageLevel(builder))) {
                    incompleteDeclarationRestrictedTokenType = JavaTokenType.RECORD_KEYWORD;
                }
                if ("var".equals(text) && JavaFeature.LVTI.isSufficient(JavaParserUtil.getLanguageLevel(builder))) {
                    incompleteDeclarationRestrictedTokenType = JavaTokenType.VAR_KEYWORD;
                }
            }
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            JavaParserUtil.done(statement, JavaElementType.DECLARATION_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder.mark();
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
            this.parseStatement(builder);
            JavaParserUtil.done(statement, JavaElementType.LABELED_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (expr != null) {
            IElementType statementType;
            statement = builder.mark();
            if (incompleteDeclarationRestrictedTokenType != null) {
                builder.remapCurrentToken(incompleteDeclarationRestrictedTokenType);
                builder.advanceLexer();
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                statementType = JavaElementType.DECLARATION_STATEMENT;
            } else {
                this.myParser.getExpressionParser().parse(builder);
                statementType = JavaElementType.EXPRESSION_STATEMENT;
                JavaParserUtil.semicolon(builder);
            }
            JavaParserUtil.done(statement, statementType, builder, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement;
        ArrayList<PsiBuilder.Marker> stack;
        block7: {
            stack = null;
            while (true) {
                statement = builder.mark();
                builder.advanceLexer();
                if (!this.parseExprInParenth(builder)) break block7;
                if (this.parseStatement(builder) == null) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
                    break block7;
                }
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ELSE_KEYWORD)) break block7;
                if (builder.getTokenType() != JavaTokenType.IF_KEYWORD) break;
                if (stack == null) {
                    stack = new ArrayList<PsiBuilder.Marker>();
                }
                stack.add(statement);
            }
            if (this.parseStatement(builder) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        if (stack != null) {
            for (int i = stack.size() - 1; i >= 0; --i) {
                statement = (PsiBuilder.Marker)stack.get(i);
                JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
            }
        }
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.WHILE_STATEMENT, false);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(7);
        }
        return marker;
    }

    @Contract(pure=true)
    private boolean isRecordPatternInForEach(PsiBuilder builder) {
        PsiBuilder.Marker patternStart = this.myParser.getPatternParser().preParsePattern(builder);
        if (patternStart == null) {
            return false;
        }
        if (builder.getTokenType() != JavaTokenType.LPARENTH) {
            patternStart.rollbackTo();
            return false;
        }
        builder.advanceLexer();
        int parenBalance = 1;
        while (true) {
            IElementType current;
            if ((current = builder.getTokenType()) == null) {
                patternStart.rollbackTo();
                return false;
            }
            if (current == JavaTokenType.LPARENTH) {
                ++parenBalance;
            }
            if (current == JavaTokenType.RPARENTH && --parenBalance == 0) break;
            builder.advanceLexer();
        }
        builder.advanceLexer();
        boolean isRecordPattern = builder.getTokenType() != JavaTokenType.SEMICOLON && builder.getTokenType() != JavaTokenType.DOT;
        patternStart.rollbackTo();
        return isRecordPattern;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(8);
            }
            return marker;
        }
        if (this.isRecordPatternInForEach(builder)) {
            this.myParser.getPatternParser().parsePattern(builder);
            if (builder.getTokenType() == JavaTokenType.COLON) {
                return this.parseForEachFromColon(builder, statement, JavaElementType.FOREACH_PATTERN_STATEMENT);
            }
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.colon", new Object[0]));
            while (true) {
                IElementType tokenType;
                if ((tokenType = builder.getTokenType()) == null) {
                    JavaParserUtil.done(statement, JavaElementType.FOREACH_PATTERN_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(9);
                    }
                    return marker;
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    PsiBuilder.Marker marker = this.parserForEachFromRparenth(builder, statement, JavaElementType.FOREACH_PATTERN_STATEMENT);
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(10);
                    }
                    return marker;
                }
                builder.advanceLexer();
            }
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false, true);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            return this.parseForLoopFromInitializer(builder, statement);
        }
        afterParenth.drop();
        return this.parseForEachFromColon(builder, statement, JavaElementType.FOREACH_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                PsiBuilder.Marker marker = statement;
                if (marker == null) {
                    StatementParser.$$$reportNull$$$0(11);
                }
                return marker;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (StatementParser.getLastToken(builder) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder)) == null;
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(12);
                    }
                    return marker;
                }
            } else {
                this.parseForUpdateExpressions(builder);
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(13);
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    private void parseForUpdateExpressions(PsiBuilder builder) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST, builder, this.myWhiteSpaceAndCommentSetHolder);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement, IElementType foreachStatement) {
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        PsiBuilder.Marker marker = this.parserForEachFromRparenth(builder, statement, foreachStatement);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    private PsiBuilder.Marker parserForEachFromRparenth(PsiBuilder builder, PsiBuilder.Marker statement, IElementType forEachType) {
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, forEachType, builder, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body2 = this.parseStatement(builder);
        if (body2 == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder)) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.SWITCH_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(17);
        }
        return marker;
    }

    @ApiStatus.Internal
    public @NotNull Pair<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PsiBuilder.Marker, Boolean> parseCaseLabel(PsiBuilder builder) {
        if (builder.getTokenType() == JavaTokenType.DEFAULT_KEYWORD) {
            PsiBuilder.Marker defaultElement = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(defaultElement, JavaElementType.DEFAULT_CASE_LABEL_ELEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
            Pair pair = Pair.create((Object)defaultElement, (Object)false);
            if (pair == null) {
                StatementParser.$$$reportNull$$$0(18);
            }
            return pair;
        }
        if (this.myParser.getPatternParser().isPattern(builder)) {
            PsiBuilder.Marker pattern = this.myParser.getPatternParser().parsePattern(builder);
            Pair pair = Pair.create((Object)pattern, (Object)false);
            if (pair == null) {
                StatementParser.$$$reportNull$$$0(19);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)this.myParser.getExpressionParser().parseAssignmentForbiddingLambda(builder), (Object)true);
        if (pair == null) {
            StatementParser.$$$reportNull$$$0(20);
        }
        return pair;
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase) {
            boolean patternsAllowed = JavaFeature.PATTERNS_IN_SWITCH.isSufficient(JavaParserUtil.getLanguageLevel(builder));
            PsiBuilder.Marker list = builder.mark();
            do {
                Pair<PsiBuilder.Marker, Boolean> markerAndIsExpression = this.parseCaseLabel(builder);
                PsiBuilder.Marker caseLabel = (PsiBuilder.Marker)markerAndIsExpression.first;
                if (caseLabel != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message(patternsAllowed ? "expected.case.label.element" : "expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
            JavaParserUtil.done(list, JavaElementType.CASE_LABEL_ELEMENT_LIST, builder, this.myWhiteSpaceAndCommentSetHolder);
            this.parseGuard(builder);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ARROW)) {
            PsiBuilder.Marker body2;
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                body2 = builder.mark();
                this.parseCodeBlock(builder, true);
                body2.done(JavaElementType.BLOCK_STATEMENT);
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark = builder.mark();
                    while (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder.advanceLexer();
                    }
                    mark.error(JavaPsiBundle.message("expected.switch.label", new Object[0]));
                }
            } else if (builder.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    body2 = expr.precede();
                    JavaParserUtil.semicolon(builder);
                    body2.done(JavaElementType.EXPRESSION_STATEMENT);
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
                }
            }
            JavaParserUtil.done(statement, JavaElementType.SWITCH_LABELED_RULE, builder, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            JavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon.or.arrow");
            JavaParserUtil.done(statement, JavaElementType.SWITCH_LABEL_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        }
        return statement;
    }

    private void parseGuard(PsiBuilder builder) {
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && "when".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.WHEN_KEYWORD);
            builder.advanceLexer();
            PsiBuilder.Marker guardingExpression = this.myParser.getExpressionParser().parseAssignmentForbiddingLambda(builder);
            if (guardingExpression == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
        }
    }

    @NotNull
    private PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.BREAK_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(21);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseYieldStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.remapCurrentToken(JavaTokenType.YIELD_KEYWORD);
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.YIELD_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(22);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.CONTINUE_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(23);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.RETURN_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(24);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(25);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.SYNCHRONIZED_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(26);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(27);
        }
        return marker;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(28);
        }
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION, builder, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true, false);
        if (param == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION, builder, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        PsiBuilder.Marker body2 = this.parseCodeBlock(builder, true);
        if (body2 == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION, builder, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION, builder, this.myWhiteSpaceAndCommentSetHolder);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(29);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        this.parseCodeBlock(builder, true);
        JavaParserUtil.done(statement, JavaElementType.BLOCK_STATEMENT, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(30);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder, @NotNull IElementType type, boolean block) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(31);
        }
        if (type == null) {
            StatementParser.$$$reportNull$$$0(32);
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker body2;
            PsiBuilder.Marker marker = body2 = block ? this.parseCodeBlock(builder, true) : this.parseStatement(builder);
            if (body2 == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, type, builder, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(33);
        }
        return marker;
    }

    private boolean parseExprInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static boolean isStmtYieldToken(@NotNull PsiBuilder builder, IElementType tokenType) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(34);
        }
        if (tokenType != JavaTokenType.IDENTIFIER || !"yield".equals(builder.getTokenText()) || !JavaFeature.SWITCH_EXPRESSION.isSufficient(JavaParserUtil.getLanguageLevel(builder))) {
            return false;
        }
        PsiBuilder.Marker maybeYieldStmt = builder.mark();
        builder.advanceLexer();
        IElementType tokenAfterYield = builder.getTokenType();
        if (tokenAfterYield == null || YIELD_STMT_INDICATOR_TOKENS.contains(tokenAfterYield)) {
            maybeYieldStmt.rollbackTo();
            return true;
        }
        if (JavaTokenType.PLUSPLUS.equals(tokenAfterYield) || JavaTokenType.MINUSMINUS.equals(tokenAfterYield)) {
            builder.advanceLexer();
            boolean isYieldStmt = !builder.getTokenType().equals(JavaTokenType.SEMICOLON);
            maybeYieldStmt.rollbackTo();
            return isYieldStmt;
        }
        maybeYieldStmt.rollbackTo();
        return false;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        }
    }

    private static IElementType getLastToken(PsiBuilder builder) {
        IElementType token;
        int offset = -1;
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder.rawLookup(offset))) {
            --offset;
        }
        return token;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIfStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileStatement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForStatement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForLoopFromInitializer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForEachFromColon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDoWhileStatement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSwitchStatement";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCaseLabel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBreakStatement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseYieldStatement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContinueStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturnStatement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseThrowStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSynchronizedStatement";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTryStatement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAssertStatement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBlockStatement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExprInParenthWithBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlockDeep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseCatchBlock";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseExprInParenthWithBlock";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isStmtYieldToken";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

