/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.codeInsight.TypeNullability;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.types.JvmWildcardType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.JavaTypeNullabilityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiWildcardType
extends PsiType.Stub
implements JvmWildcardType {
    public static final String EXTENDS_PREFIX = "? extends ";
    public static final String SUPER_PREFIX = "? super ";
    private static final Logger LOG = Logger.getInstance(PsiWildcardType.class);
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    private final PsiManager myManager;
    private final boolean myIsExtending;
    private final PsiType myBound;
    @Nullable
    private final TypeNullability myBaseNullability;

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(0);
        }
        this(manager, isExtending, bound, TypeAnnotationProvider.EMPTY);
    }

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound, @NotNull TypeAnnotationProvider provider) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            PsiWildcardType.$$$reportNull$$$0(2);
        }
        this(manager, isExtending, bound, provider, null);
    }

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound, @NotNull TypeAnnotationProvider provider, @Nullable TypeNullability nullability) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiWildcardType.$$$reportNull$$$0(4);
        }
        super(provider);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
        this.myBaseNullability = nullability;
    }

    @NotNull
    public static PsiWildcardType createUnbounded(@NotNull PsiManager manager) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(5);
        }
        PsiWildcardType psiWildcardType = (PsiWildcardType)ConcurrencyUtil.computeIfAbsent((UserDataHolder)manager, UNBOUNDED_WILDCARD, () -> new PsiWildcardType(manager, false, null));
        if (psiWildcardType == null) {
            PsiWildcardType.$$$reportNull$$$0(6);
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createExtends(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(7);
        }
        if (bound == null) {
            PsiWildcardType.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType) && bound != PsiTypes.nullType(), (Object)bound);
        return new PsiWildcardType(manager, true, bound);
    }

    @NotNull
    public static PsiWildcardType createSuper(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(9);
        }
        if (bound == null) {
            PsiWildcardType.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType) && bound != PsiTypes.nullType(), (Object)bound);
        return new PsiWildcardType(manager, false, bound);
    }

    @Override
    @NotNull
    public TypeNullability getNullability() {
        TypeNullability baseNullability = this.myBaseNullability;
        if (baseNullability == null) {
            baseNullability = JavaTypeNullabilityUtil.getNullabilityFromAnnotations(this.getAnnotations());
        }
        if (!baseNullability.equals(TypeNullability.UNKNOWN)) {
            TypeNullability typeNullability = baseNullability;
            if (typeNullability == null) {
                PsiWildcardType.$$$reportNull$$$0(11);
            }
            return typeNullability;
        }
        if (this.myBound != null && this.myIsExtending) {
            TypeNullability typeNullability = this.myBound.getNullability().inherited();
            if (typeNullability == null) {
                PsiWildcardType.$$$reportNull$$$0(12);
            }
            return typeNullability;
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            PsiWildcardType.$$$reportNull$$$0(13);
        }
        return typeNullability;
    }

    @Override
    @NotNull
    public PsiWildcardType withNullability(@NotNull TypeNullability nullability) {
        if (nullability == null) {
            PsiWildcardType.$$$reportNull$$$0(14);
        }
        return new PsiWildcardType(this.myManager, this.myIsExtending, this.myBound, this.getAnnotationProvider(), nullability);
    }

    @Override
    @NotNull
    public PsiType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiWildcardType.$$$reportNull$$$0(15);
        }
        return new PsiWildcardType(this.myManager, this.myIsExtending, this.myBound, provider);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(false, annotated, this.myBound == null ? null : this.myBound.getPresentableText(annotated));
        if (string == null) {
            PsiWildcardType.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated, this.myBound == null ? null : this.myBound.getCanonicalText(annotated));
        if (string == null) {
            PsiWildcardType.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(true, true, this.myBound == null ? null : this.myBound.getInternalCanonicalText());
        if (string == null) {
            PsiWildcardType.$$$reportNull$$$0(18);
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated, @Nullable String suffix) {
        PsiAnnotation[] annotations;
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0 && suffix == null) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (annotated) {
            PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        }
        if (suffix == null) {
            sb.append('?');
        } else {
            sb.append(this.myIsExtending ? EXTENDS_PREFIX : SUPER_PREFIX);
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope scope;
        if (this.myBound != null && (scope = this.myBound.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                PsiWildcardType.$$$reportNull$$$0(19);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (globalSearchScope == null) {
            PsiWildcardType.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{this.getExtendsBound()};
        if (psiTypeArray == null) {
            PsiWildcardType.$$$reportNull$$$0(21);
        }
        return psiTypeArray;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiWildcardType.$$$reportNull$$$0(22);
        }
        if (this.myBound == null) {
            return "?".equals(text);
        }
        if (this.myIsExtending) {
            return text.startsWith(EXTENDS_PREFIX) && this.myBound.equalsToText(text.substring(EXTENDS_PREFIX.length()));
        }
        return text.startsWith(SUPER_PREFIX) && this.myBound.equalsToText(text.substring(SUPER_PREFIX.length()));
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            PsiWildcardType.$$$reportNull$$$0(23);
        }
        return psiManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal((Object)this.myBound, (Object)that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    @Nullable
    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiWildcardType.$$$reportNull$$$0(24);
        }
        return visitor2.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    @NotNull
    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            PsiClassType psiClassType = PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
            if (psiClassType == null) {
                PsiWildcardType.$$$reportNull$$$0(25);
            }
            return psiClassType;
        }
        PsiType psiType = this.myBound;
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(26);
        }
        return psiType;
    }

    @NotNull
    public PsiType getSuperBound() {
        PsiType psiType = this.myBound == null || this.myIsExtending ? (PsiPrimitiveType)PsiTypes.nullType() : this.myBound;
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(27);
        }
        return psiType;
    }

    @Override
    @NotNull
    public JvmType upperBound() {
        PsiType psiType = this.getExtendsBound();
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(28);
        }
        return psiType;
    }

    @Override
    @NotNull
    public JvmType lowerBound() {
        PsiType psiType = this.getSuperBound();
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(29);
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiWildcardType";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiWildcardType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnbounded";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsBound";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperBound";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "upperBound";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "lowerBound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUnbounded";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExtends";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSuper";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withNullability";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

