/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.IsConstantExpressionVisitor;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiJavaModuleModificationTracker;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.HolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache;
    private final ConcurrentMap<GlobalSearchScope, Map<String, Optional<PsiClass>>> myClassCache;
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final NotNullLazyValue<JvmFacadeImpl> myJvmFacade;
    private final JvmPsiConversionHelper myConversionHelper;

    public JavaPsiFacadeImpl(@NotNull Project project, @Nullable CoroutineScope coroutineScope) {
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
        this.myClassCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(this.myProject);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myJvmFacade = NotNullLazyValue.atomicLazy(() -> (JvmFacadeImpl)JvmFacade.getInstance(project));
        this.myConversionHelper = JvmPsiConversionHelper.getInstance(this.myProject);
        MessageBus bus = project.getMessageBus();
        (coroutineScope == null ? bus.simpleConnect() : bus.connect(coroutineScope)).subscribe(PsiModificationTracker.TOPIC, () -> {
            this.myClassCache.clear();
            this.myPackageCache.clear();
        });
        DummyHolderFactory.setFactory((HolderFactory)new JavaDummyHolderFactory());
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map map2 = this.myClassCache.computeIfAbsent(scope, scope1 -> CollectionFactory.createConcurrentWeakValueMap());
        Optional<PsiClass> result = (Optional<PsiClass>)map2.get(qualifiedName);
        if (result == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result = Optional.ofNullable(this.doFindClass(qualifiedName, scope));
            if (stamp.mayCacheNow()) {
                map2.put(qualifiedName, result);
            }
        }
        return result.orElse(null);
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes.length != 0) {
                return classes[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        PsiClass bestClass = null;
        for (PsiElementFinder finder : finders) {
            try {
                PsiClass candidateClass = finder.findClass(qualifiedName, scope);
                if (candidateClass == null || classesFilter != null && !classesFilter.test(candidateClass) || bestClass != null && PsiClassUtil.createScopeComparator(scope).compare(candidateClass, bestClass) >= 0) continue;
                bestClass = candidateClass;
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return bestClass;
    }

    private PsiClass @NotNull [] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(7);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(9);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    private boolean hasClassInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg != null) {
            return pkg.hasClassWithShortName(className, scope);
        }
        if (packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses;
            for (PsiClass containingClass : containingClasses = this.findClassesInDumbMode(packageName, scope)) {
                if (!ContainerUtil.exists((Object[])containingClass.getInnerClasses(), innerClass -> className.equals(innerClass.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> allClasses;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        PsiClass[] psiClassArray = (allClasses = this.findClassesWithJvmFacade(qualifiedName, scope)).isEmpty() ? PsiClass.EMPTY_ARRAY : allClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        return psiClassArray;
    }

    @Override
    public boolean hasClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        if (this.shouldUseSlowResolve()) {
            return this.hasClassInDumbMode(qualifiedName, scope);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        if (classesFilter == null) {
            classesFilter = Predicates.alwaysTrue();
        }
        for (PsiElementFinder finder : finders) {
            if (!finder.hasClass(qualifiedName, scope, classesFilter)) continue;
            return true;
        }
        return !((JvmFacadeImpl)this.myJvmFacade.getValue()).findClassesWithoutJavaFacade(qualifiedName, scope).isEmpty();
    }

    @NotNull
    private List<PsiClass> findClassesWithJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<JvmClass> jvmClasses;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(19);
        }
        ArrayList<PsiClass> result = null;
        List<PsiClass> ownClasses = this.findClassesWithoutJvmFacade(qualifiedName, scope);
        if (!ownClasses.isEmpty()) {
            result = new ArrayList<PsiClass>(ownClasses);
        }
        if (!(jvmClasses = ((JvmFacadeImpl)this.myJvmFacade.getValue()).findClassesWithoutJavaFacade(qualifiedName, scope)).isEmpty()) {
            List jvmPsiClasses = ContainerUtil.map(jvmClasses, it -> this.myConversionHelper.convertTypeDeclaration((JvmTypeDeclaration)it));
            if (result == null) {
                result = new ArrayList(jvmPsiClasses);
            } else {
                result.addAll(jvmPsiClasses);
            }
        }
        List<PsiClass> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> findClassesWithoutJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        if (this.shouldUseSlowResolve()) {
            List<PsiClass> list = Arrays.asList(this.findClassesInDumbMode(qualifiedName, scope));
            if (list == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            try {
                PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
                if (finderClasses.length == 0) continue;
                if (result == null) {
                    result = new ArrayList(finderClasses.length);
                }
                JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        List<PsiClass> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    private static Predicate<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope, @NotNull List<? extends PsiElementFinder> finders) {
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        if (finders == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        Predicate<PsiClass> filter = null;
        for (PsiElementFinder psiElementFinder : finders) {
            try {
                Predicate<PsiClass> finderFilter = psiElementFinder.getClassesFilter(scope);
                if (finderFilter == null) continue;
                filter = filter == null ? finderFilter : filter.and(finderFilter);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return filter;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        return dumbService.isAlternativeResolveEnabled();
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        if ((aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                aPackage = finder.findPackage(qualifiedName);
                if (aPackage == null) continue;
                return (PsiPackage)ConcurrencyUtil.cacheOrGet(this.myPackageCache, (Object)qualifiedName, (Object)aPackage);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return null;
    }

    @Override
    public PsiJavaModule findModule(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules;
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        return (modules = this.findModules(moduleName, scope)).size() == 1 ? modules.iterator().next() : null;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        JavaFileManager javaFileManager = JavaFileManager.getInstance(this.myProject);
        if (DumbService.isDumb((Project)this.myProject)) {
            if (DumbUtil.getInstance((Project)this.myProject).mayUseIndices()) {
                Collection<PsiJavaModule> collection = javaFileManager.findModules(moduleName, scope);
                if (collection == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(33);
                }
                return collection;
            }
            List<PsiJavaModule> list = Collections.emptyList();
            if (list == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(34);
            }
            return list;
        }
        Collection collection = (Collection)((Map)((Map)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ConcurrentMap scope2ModulesMap = ConcurrentFactoryMap.create(searchScope -> ConcurrentFactoryMap.create(name -> javaFileManager.findModules((String)name, (GlobalSearchScope)searchScope), () -> CollectionFactory.createConcurrentWeakValueMap()), () -> ContainerUtil.createConcurrentSoftKeySoftValueMap());
            return new CachedValueProvider.Result((Object)scope2ModulesMap, new Object[]{PsiJavaModuleModificationTracker.getInstance(this.myProject), ProjectRootModificationTracker.getInstance((Project)this.myProject)});
        })).get(scope)).get(moduleName);
        if (collection == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        List list = DumbService.getInstance((Project)this.getProject()).filterByDumbAwareness((Collection)PsiElementFinder.EP.getPoint((AreaInstance)this.myProject).getExtensionList());
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(37);
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(38);
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(39);
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(41);
        }
        HashSet<String> result = new HashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                result.addAll(finder.getClassNames(psiPackage, scope));
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(42);
        }
        return hashSet;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(43);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(44);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            try {
                PsiClass[] classes = finder.getClasses(psiPackage, scope);
                if (classes.length == 0) continue;
                if (result == null) {
                    result = new ArrayList(classes.length);
                }
                JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes, result);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        PsiClass[] psiClassArray = result == null ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(45);
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Predicate<? super PsiClass> classesFilter, PsiClass @NotNull [] classes, @NotNull List<? super PsiClass> result) {
        if (result == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(46);
        }
        if (classes == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(47);
        }
        for (PsiClass psiClass : classes) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.test(psiClass)) continue;
            result.add(psiClass);
        }
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(48);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(49);
        }
        Condition filter = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition finderFilter = finder.getPackageFilesFilter(psiPackage, scope);
            if (finderFilter == null) continue;
            if (filter == null) {
                filter = finderFilter;
                continue;
            }
            filter = Conditions.and(filter, finderFilter);
        }
        LinkedHashSet<PsiFile> result = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories = psiPackage.getDirectories(scope);
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (filter != null && !filter.value((Object)file)) continue;
                result.add(file);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                Collections.addAll(result, finder.getPackageFiles(psiPackage, scope));
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        }
        PsiFile[] psiFileArray = result.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(50);
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(51);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(52);
        }
        if (consumer == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(53);
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
                return false;
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return true;
    }

    public void processPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> consumer) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(54);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(55);
        }
        if (consumer == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(56);
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                if (finder.processPackageFiles(psiPackage, scope, consumer)) continue;
                return;
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(57);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(58);
        }
        LinkedHashMap<String, PsiPackage> result = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                PsiPackage[] packages;
                for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope)) {
                    result.putIfAbsent(aPackage.getName(), aPackage);
                }
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        PsiPackage[] psiPackageArray = result.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(59);
        }
        return psiPackageArray;
    }

    private static void handleIndexNotReadyException(@NotNull IndexNotReadyException ex) {
        if (ex == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(60);
        }
        if (Registry.is((String)"ide.dumb.mode.check.awareness")) {
            throw ex;
        }
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(61);
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file;
        if (element == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(62);
        }
        if (aPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(63);
        }
        if ((file = FileContextUtil.getContextFile((PsiElement)element)) instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1;
        if (element1 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(64);
        }
        if (element2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(65);
        }
        if (Comparing.equal((Object)(file1 = FileContextUtil.getContextFile((PsiElement)element1)), (Object)(file2 = FileContextUtil.getContextFile((PsiElement)element2)))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage((PsiElement)other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Objects.equals(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(66);
        }
        return project;
    }

    @Override
    public boolean isConstantExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(67);
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression.accept(visitor2);
        return visitor2.isConstant();
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance(this.myProject);
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(68);
        }
        return psiElementFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 50: 
            case 59: 
            case 66: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 50: 
            case 59: 
            case 66: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 30: 
            case 32: 
            case 41: 
            case 44: 
            case 49: 
            case 52: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 50: 
            case 59: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finders";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 40: 
            case 43: 
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithJvmFacade";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJvmFacade";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantEvaluationHelper";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserFacade";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveHelper";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameHelper";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFindClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 50: 
            case 59: 
            case 66: 
            case 68: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasClassInDumbMode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasClass";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJvmFacade";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJvmFacade";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFilterFromFinders";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "filterClassesAndAppend";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processPackageFiles";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "handleIndexNotReadyException";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfPackagePrefix";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isInPackage";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "arePackagesTheSame";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isConstantExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 50: 
            case 59: 
            case 66: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

