/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private java.lang.ref.SoftReference<PsiAnnotationMemberValue> myCachedDefaultValue;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IElementType)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void dropCached() {
        super.dropCached();
        this.myCachedDefaultValue = null;
    }

    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String text = stub.getDefaultValueText();
            if (StringUtil.isEmpty((String)text)) {
                return null;
            }
            PsiAnnotationMemberValue value = (PsiAnnotationMemberValue)SoftReference.dereference(this.myCachedDefaultValue);
            if (value != null) {
                return value;
            }
            value = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@Foo(" + text + ")", this).findAttributeValue(null);
            this.myCachedDefaultValue = new java.lang.ref.SoftReference<PsiAnnotationMemberValue>(value);
            return value;
        }
        this.myCachedDefaultValue = null;
        boolean expectedDefault = false;
        for (TreeElement childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType type = childNode.getElementType();
            if (type == JavaTokenType.DEFAULT_KEYWORD) {
                expectedDefault = true;
                continue;
            }
            if (!expectedDefault || !ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(type)) continue;
            return (PsiAnnotationMemberValue)childNode.getPsi();
        }
        return null;
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAnnotationMethodImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotationMethod(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "accept"));
    }
}

