/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private static final Key<PsiAnonymousClassImpl> STUB_BASE_CLASS_REFERENCE_HOLDER = Key.create((String)"STUB_BASE_CLASS_REFERENCE_HOLDER");
    private java.lang.ref.SoftReference<PsiClassType> myCachedBaseType;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiElement baseRef = this.getFirstChild();
        assert (baseRef instanceof PsiJavaCodeReferenceElement) : this.getText();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)baseRef;
        if (psiJavaCodeReferenceElement == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(0);
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            PsiClassType psiClassType = this.getTypeByTree();
            if (psiClassType == null) {
                PsiAnonymousClassImpl.$$$reportNull$$$0(1);
            }
            return psiClassType;
        }
        PsiClassType type = (PsiClassType)SoftReference.dereference(this.myCachedBaseType);
        if (type != null) {
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                PsiAnonymousClassImpl.$$$reportNull$$$0(2);
            }
            return psiClassType;
        }
        if (!this.isInQualifiedNew() && !this.isDiamond(stub)) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
            try {
                PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(refText, this);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_NAME_KIND);
                ref.getContainingFile().putUserData(STUB_BASE_CLASS_REFERENCE_HOLDER, (Object)this);
                type = factory.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type = PsiType.getJavaLangObject((PsiManager)this.getManager(), this.getResolveScope());
            }
            this.myCachedBaseType = new java.lang.ref.SoftReference<PsiClassType>(type);
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                PsiAnonymousClassImpl.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = this.getTypeByTree();
        if (psiClassType == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    private boolean isDiamond(@NotNull PsiClassStub<?> stub) {
        String referenceText;
        if (stub == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(5);
        }
        if (PsiUtil.isLanguageLevel9OrHigher(this) && (referenceText = stub.getBaseClassReferenceText()) != null && referenceText.endsWith(">")) {
            return StringUtil.trimEnd((String)referenceText, (String)">").trim().endsWith("<");
        }
        return false;
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getElementFactory(this.getProject()).createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(6);
        }
        return name.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(7);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnonymousClass(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(8);
        }
        if (state == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(9);
        }
        if (place == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(10);
        }
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        if (lastParent != null && this.isBaseClassReference(lastParent)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public boolean isBaseClassReference(@NotNull PsiElement element) {
        if (element == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(11);
        }
        if (element instanceof PsiJavaCodeReferenceElement) {
            PsiElement parent = element.getParent();
            return parent == this && element == this.getBaseClassReference() || this.isBaseClassReferenceHolder(parent);
        }
        return this.isBaseClassReferenceHolder(element);
    }

    private boolean isBaseClassReferenceHolder(@NotNull PsiElement element) {
        if (element == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(12);
        }
        return element instanceof DummyHolder && element.getUserData(STUB_BASE_CLASS_REFERENCE_HOLDER) == this;
    }

    @Override
    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiAnonymousClassImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiAnonymousClassImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDiamond";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBaseClassReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBaseClassReferenceHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

