/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.TypeNullability;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassTypeReference;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.infos.PatternCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaTypeNullabilityUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final ClassReferencePointer myReference;
    private TypeNullability myNullability;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(0);
        }
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, PsiAnnotation @NotNull [] annotations) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(1);
        }
        if (annotations == null) {
            PsiClassReferenceType.$$$reportNull$$$0(2);
        }
        super(level, annotations);
        this.myNullability = null;
        this.myReference = ClassReferencePointer.constant(reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(4);
        }
        this(ClassReferencePointer.constant(reference), level, provider);
    }

    PsiClassReferenceType(@NotNull ClassReferencePointer reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(6);
        }
        this(reference, level, provider, null);
    }

    private PsiClassReferenceType(@NotNull ClassReferencePointer reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider, @Nullable TypeNullability nullability) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(8);
        }
        super(level, provider);
        this.myNullability = null;
        this.myReference = reference;
        this.myNullability = nullability;
    }

    private static PsiAnnotation @NotNull [] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        List result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((PsiAnnotation)child);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(9);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = this.myReference.retrieveReference();
        if (reference != null && reference.isValid()) {
            for (PsiAnnotation annotation : this.getAnnotations(false)) {
                if (annotation.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        PsiJavaCodeReferenceElement reference;
        String name;
        if (text == null) {
            PsiClassReferenceType.$$$reportNull$$$0(10);
        }
        return ((name = (reference = this.getReference()).getReferenceName()) == null || text.contains(name)) && Objects.equals(text, this.getCanonicalText());
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getReference().getResolveScope();
        if (globalSearchScope == null) {
            PsiClassReferenceType.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations(true);
        if (psiAnnotationArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(12);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean hasAnnotations() {
        if (super.hasAnnotations()) {
            return true;
        }
        PsiJavaCodeReferenceElement reference = this.myReference.retrieveReference();
        if (reference != null && reference.isValid() && reference.isQualified()) {
            for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof PsiAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    private PsiAnnotation[] getAnnotations(boolean merge) {
        PsiJavaCodeReferenceElement reference;
        Object[] annotations = super.getAnnotations();
        if (merge && (reference = this.myReference.retrieveReference()) != null && reference.isValid() && reference.isQualified()) {
            Object[] embedded = PsiClassReferenceType.collectAnnotations(reference);
            if (annotations.length > 0 && embedded.length > 0) {
                LinkedHashSet set = new LinkedHashSet();
                ContainerUtil.addAll(set, (Object[])annotations);
                ContainerUtil.addAll(set, (Object[])embedded);
                annotations = set.toArray(PsiAnnotation.EMPTY_ARRAY);
            } else {
                annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])embedded);
            }
        }
        return annotations;
    }

    @Override
    @NotNull
    public TypeNullability getNullability() {
        TypeNullability nullability = this.myNullability;
        if (nullability == null) {
            this.myNullability = nullability = JavaTypeNullabilityUtil.getTypeNullability(this);
        }
        TypeNullability typeNullability = nullability;
        if (typeNullability == null) {
            PsiClassReferenceType.$$$reportNull$$$0(13);
        }
        return typeNullability;
    }

    @Override
    @NotNull
    public PsiClassType annotate(@NotNull TypeAnnotationProvider provider) {
        PsiClassReferenceType annotated;
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(14);
        }
        if ((annotated = (PsiClassReferenceType)super.annotate(provider)) != this) {
            annotated.myNullability = null;
        }
        PsiClassReferenceType psiClassReferenceType = annotated;
        if (psiClassReferenceType == null) {
            PsiClassReferenceType.$$$reportNull$$$0(15);
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiClassType withNullability(@NotNull TypeNullability nullability) {
        if (nullability == null) {
            PsiClassReferenceType.$$$reportNull$$$0(16);
        }
        if (this.myNullability == nullability) {
            PsiClassReferenceType psiClassReferenceType = this;
            if (psiClassReferenceType == null) {
                PsiClassReferenceType.$$$reportNull$$$0(17);
            }
            return psiClassReferenceType;
        }
        return new PsiClassReferenceType(this.myReference, this.myLanguageLevel, this.getAnnotationProvider(), nullability);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                PsiClassReferenceType.$$$reportNull$$$0(18);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.getReference());
        if (languageLevel == null) {
            PsiClassReferenceType.$$$reportNull$$$0(19);
        }
        return languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiClassReferenceType.$$$reportNull$$$0(20);
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            PsiClassReferenceType psiClassReferenceType = this;
            if (psiClassReferenceType == null) {
                PsiClassReferenceType.$$$reportNull$$$0(21);
            }
            return psiClassReferenceType;
        }
        return new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
    }

    @Override
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (!reference.isValid()) {
            if (reference instanceof LightClassTypeReference) {
                PsiUtil.ensureValidType(((LightClassTypeReference)reference).getType());
            }
            throw new PsiInvalidElementAccessException((PsiElement)reference, this.myReference.toString() + "; augmenters=" + PsiAugmentProvider.EP_NAME.getExtensionList());
        }
        JavaResolveResult result = reference.advancedResolve(false);
        return result.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result);
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable(aClass).iterator().hasNext()) {
                PsiClassReferenceType psiClassReferenceType = this;
                if (psiClassReferenceType == null) {
                    PsiClassReferenceType.$$$reportNull$$$0(22);
                }
                return psiClassReferenceType;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(manager.getProject());
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor(aClass);
            return new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider(), null);
        }
        String qualifiedName = reference.getQualifiedName();
        String name = reference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name, qualifiedName, reference.getResolveScope());
        return new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
    }

    @Override
    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    @Override
    public PsiType @NotNull [] getParameters() {
        PsiClassType.ClassResolveResult result;
        PsiClass cls;
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference.getTypeParameterCount() == 0 && reference.getParent() instanceof PsiTypeElement && reference.getParent().getParent() instanceof PsiDeconstructionPattern && (cls = (result = this.resolveGenerics()).getElement()) != null && result.getInferenceError() == null) {
            PsiType[] psiTypeArray = (PsiType[])ContainerUtil.map2Array((Object[])cls.getTypeParameters(), (Object[])PsiType.EMPTY_ARRAY, result.getSubstitutor().getSubstitutionMap()::get);
            if (psiTypeArray == null) {
                PsiClassReferenceType.$$$reportNull$$$0(23);
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = reference.getTypeParameters();
        if (psiTypeArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(24);
        }
        return psiTypeArray;
    }

    @Override
    public int getParameterCount() {
        PsiClassType.ClassResolveResult result;
        PsiClass cls;
        PsiJavaCodeReferenceElement reference = this.getReference();
        int count = reference.getTypeParameterCount();
        if (count == 0 && reference.getParent() instanceof PsiTypeElement && reference.getParent().getParent() instanceof PsiDeconstructionPattern && (cls = (result = this.resolveGenerics()).getElement()) != null && result.getInferenceError() == null) {
            return cls.getTypeParameters().length;
        }
        return count;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiAnnotation[] annotations;
        PsiJavaCodeReferenceElement ref = this.getReference();
        if (!annotated) {
            String string = PsiNameHelper.getPresentableText(ref);
            if (string == null) {
                PsiClassReferenceType.$$$reportNull$$$0(25);
            }
            return string;
        }
        PsiElement qualifier = ref.getQualifier();
        String qualifierInfo = "";
        if (qualifier != null) {
            PsiAnnotation[] qualifierAnnotations = this.getAnnotations(false);
            if (qualifierAnnotations.length > 0 && qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiClass) {
                qualifierInfo = PsiNameHelper.getPresentableText(qualifier.getText(), qualifierAnnotations, ((PsiJavaCodeReferenceElement)qualifier).getTypeParameters()) + ".";
            }
            annotations = (PsiAnnotation[])ObjectUtils.notNull((Object)((PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class)), (Object)PsiAnnotation.EMPTY_ARRAY);
        } else {
            annotations = this.getAnnotations(false);
        }
        String string = qualifierInfo + PsiNameHelper.getPresentableText(ref.getReferenceName(), annotations, ref.getTypeParameters());
        if (string == null) {
            PsiClassReferenceType.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(annotated);
        if (string == null) {
            PsiClassReferenceType.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            PsiClassReferenceType.$$$reportNull$$$0(28);
        }
        return string;
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations = annotated ? this.getAnnotations(false) : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations.length == 0 ? null : annotations);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myReference.retrieveNonNullReference();
        if (psiJavaCodeReferenceElement == null) {
            PsiClassReferenceType.$$$reportNull$$$0(29);
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @Nullable
    public PsiElement getPsiContext() {
        return this.myReference.retrieveReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiClassReferenceType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiClassReferenceType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withNullability";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withNullability";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            if (delegate == null) {
                DelegatingClassResolveResult.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.myDelegate.getSubstitutor();
            if (psiSubstitutor == null) {
                DelegatingClassResolveResult.$$$reportNull$$$0(1);
            }
            return psiSubstitutor;
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        @Override
        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        @Override
        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }

        @Override
        @Nullable
        public String getInferenceError() {
            return this.myDelegate instanceof PatternCandidateInfo ? ((PatternCandidateInfo)this.myDelegate).getInferenceError() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

