/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.ImplicitlyImportedElement;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance(PsiJavaFileBaseImpl.class);
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private final CachedValue<Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>>> myCachedDeclarations;
    private final CachedValue<ImplicitlyImportedElement[]> myCachedImplicitImportedElements;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.createLazyKey((String)"LANGUAGE_LEVEL", file -> file.getLanguageLevelInner());
    private static final Key<String> SHEBANG_SOURCE_LEVEL = Key.create((String)"SHEBANG_SOURCE_LEVEL");

    protected PsiJavaFileBaseImpl(@NotNull IElementType elementType, @NotNull IElementType contentElementType, @NotNull FileViewProvider viewProvider) {
        if (elementType == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(0);
        }
        if (contentElementType == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(1);
        }
        if (viewProvider == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(2);
        }
        super(elementType, contentElementType, viewProvider);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.myManager.getProject());
        this.myResolveCache = cachedValuesManager.createCachedValue((CachedValueProvider)new MyCacheBuilder(this), false);
        this.myCachedDeclarations = cachedValuesManager.createCachedValue(() -> {
            Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> declarations = this.findEnumeratedDeclarations();
            if (!this.isPhysical()) {
                return CachedValueProvider.Result.create(declarations, (Object[])new Object[]{this.getContainingFile(), PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(declarations, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
        this.myCachedImplicitImportedElements = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create((Object)PsiImplUtil.getImplicitImports(this), (Object[])new Object[]{this.getContainingFile()}), false);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        PsiClass[] psiClassArray = (PsiClass[])this.withGreenStubOrAst(stub -> (PsiClass[])stub.getChildrenByType(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY), ast -> (PsiClass[])ast.getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY));
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(3);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        return (PsiPackageStatement)this.withGreenStubOrAst(stub -> {
            StubElement element = stub.findChildStubByElementType(JavaElementType.PACKAGE_STATEMENT);
            return element == null ? null : (PsiPackageStatement)element.getPsi();
        }, file -> {
            ASTNode childNode = file.findChildByType(JavaElementType.PACKAGE_STATEMENT);
            return childNode == null ? null : (PsiPackageStatement)childNode.getPsi();
        });
    }

    @Override
    @NotNull
    public String getPackageName() {
        String string = (String)this.withGreenStubOrAst(PsiJavaFileStub.class, stub -> stub.getPackageName(), ast -> {
            String name = this.myPackageName;
            if (name == null) {
                PsiPackageStatement statement = this.getPackageStatement();
                name = statement == null ? "" : statement.getPackageName();
                this.myPackageName = name;
            }
            return name;
        });
        if (string == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setPackageName(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(5);
        }
        if (PsiUtil.isModuleFile(this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace((PsiElement)factory.createPackageStatement(packageName).getPackageReference());
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.cleanupBrokenPackageKeyword();
            PsiElement anchor = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                String text;
                anchor = this.getImportList();
                assert (anchor != null);
                PsiElement prev = anchor.getPrevSibling();
                if (prev instanceof PsiComment && (text = prev.getText().trim()).startsWith("/*") && !text.endsWith("*/")) {
                    prev.replace((PsiElement)factory.createCommentFromText(text + (StringUtil.containsLineBreak((CharSequence)text) ? "\n*/" : " */"), prev));
                }
            }
            this.addBefore(factory.createPackageStatement(packageName), anchor);
        }
    }

    private void cleanupBrokenPackageKeyword() {
        PsiElement child = this.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiErrorElement) {
            if (child instanceof PsiErrorElement && child.getFirstChild() != null && child.getFirstChild().textMatches((CharSequence)"package")) {
                child.delete();
                break;
            }
            child = child.getNextSibling();
        }
    }

    @Override
    public PsiImportList getImportList() {
        return (PsiImportList)this.withGreenStubOrAst(stub -> {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            assert (nodes.length == 0);
            return null;
        }, ast -> {
            ASTNode node = ast.findChildByType(JavaElementType.IMPORT_LIST);
            return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        });
    }

    @Override
    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(6);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(7);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(9);
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(@NotNull PsiClass aClass) {
        PsiImportList importList;
        if (aClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(10);
        }
        if ((importList = this.getImportList()) != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    @Override
    public String @NotNull [] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(11);
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences((PsiManager)this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(12);
        }
        return psiJavaCodeReferenceElementArray;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        Iterable iterable;
        NameHint nameHint;
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(13);
        }
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(15);
        }
        String name = (nameHint = (NameHint)processor.getHint(NameHint.KEY)) != null ? nameHint.getName(state) : null;
        Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated = this.getEnumeratedDeclarations();
        Iterable iterable2 = iterable = name != null ? explicitlyEnumerated.get(name) : ContainerUtil.concat((Iterable[])explicitlyEnumerated.values().toArray(new Iterable[0]));
        if (iterable != null && !ContainerUtil.process((Iterable)iterable, (Processor)new MyResolveCacheProcessor(state, processor))) {
            return false;
        }
        if (processor instanceof ClassResolverProcessor && (PsiFileEx.isBatchReferenceProcessingEnabled((PsiFile)this) || this.myResolveCache.hasUpToDateValue()) && !PsiUtil.isInsideJavadocComment(place)) {
            MostlySingularMultiMap cache = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(state, processor);
            return name != null ? cache.processForKey((Object)name, (Processor)cacheProcessor) : cache.processAllValues((Processor)cacheProcessor);
        }
        return this.processOnDemandPackages(state, place, processor);
    }

    @NotNull
    private Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> getEnumeratedDeclarations() {
        Map map2 = (Map)this.myCachedDeclarations.getValue();
        if (map2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(16);
        }
        return map2;
    }

    @NotNull
    private Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> findEnumeratedDeclarations() {
        MultiMap ownClasses = MultiMap.create();
        MultiMap typeImports = MultiMap.create();
        MultiMap staticImports = MultiMap.create();
        for (PsiClass psiClass : this.getClasses()) {
            String name;
            if (psiClass instanceof PsiImplicitClass || (name = psiClass.getName()) == null) continue;
            ownClasses.putValue((Object)name, (Object)psiClass);
        }
        for (PsiElement psiElement : this.getImportStatements()) {
            String qName;
            if (psiElement.isOnDemand() || (qName = psiElement.getQualifiedName()) == null) continue;
            typeImports.putValue((Object)StringUtil.getShortName((String)qName), (Object)psiElement);
        }
        List implicitStaticImports = ContainerUtil.filterIsInstance(this.getImplicitImports(), PsiImportStaticStatement.class);
        for (PsiImportStaticStatement staticImport : ContainerUtil.append((List)implicitStaticImports, (Object[])this.getImportStaticStatements())) {
            String string = staticImport.getReferenceName();
            if (string == null) continue;
            staticImports.putValue((Object)string, (Object)staticImport);
        }
        LinkedHashMap<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> result = new LinkedHashMap<String, Iterable<SymbolCollectingProcessor.ResultWithContext>>();
        for (String string : ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{ownClasses.keySet(), typeImports.keySet(), staticImports.keySet()}))) {
            NotNullLazyValue lazy = NotNullLazyValue.volatileLazy(() -> PsiJavaFileBaseImpl.findExplicitDeclarations(name, (MultiMap<String, PsiClass>)ownClasses, (MultiMap<String, PsiImportStatement>)typeImports, (MultiMap<String, PsiImportStaticStatement>)staticImports));
            result.put(string, () -> ((Iterable)lazy.getValue()).iterator());
        }
        LinkedHashMap<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> linkedHashMap = result;
        if (linkedHashMap == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @NotNull
    private static Iterable<SymbolCollectingProcessor.ResultWithContext> findExplicitDeclarations(@NotNull String name, @NotNull MultiMap<String, PsiClass> ownClasses, @NotNull MultiMap<String, PsiImportStatement> typeImports, @NotNull MultiMap<String, PsiImportStaticStatement> staticImports) {
        if (name == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(18);
        }
        if (ownClasses == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(19);
        }
        if (typeImports == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(20);
        }
        if (staticImports == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(21);
        }
        ArrayList<SymbolCollectingProcessor.ResultWithContext> result = new ArrayList<SymbolCollectingProcessor.ResultWithContext>();
        for (PsiClass psiClass : ownClasses.get((Object)name)) {
            result.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)psiClass, null));
        }
        for (PsiImportStatementBase statement : typeImports.get((Object)name)) {
            PsiElement target = statement.resolve();
            if (target != null && !(target instanceof PsiClass)) continue;
            result.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)target, statement));
        }
        for (PsiImportStatementBase statement : staticImports.get((Object)name)) {
            PsiJavaCodeReferenceElement reference = statement.getImportReference();
            if (reference == null) continue;
            JavaResolveResult[] targets = reference.multiResolve(false);
            if (targets.length == 0) {
                result.add(new SymbolCollectingProcessor.ResultWithContext(null, statement));
                continue;
            }
            for (JavaResolveResult target : targets) {
                PsiElement element = target.getElement();
                if (!(element instanceof PsiNamedElement)) continue;
                result.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)element, statement));
            }
        }
        JBIterable jBIterable = JBIterable.from(result).unique(SymbolCollectingProcessor.ResultWithContext::getElement);
        if (jBIterable == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    private boolean processOnDemandPackages(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        ElementClassHint classHint;
        boolean shouldProcessClasses;
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(23);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(25);
        }
        boolean bl = shouldProcessClasses = (classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
        if (shouldProcessClasses && !this.processCurrentPackage(state, place, processor)) {
            return false;
        }
        if (!this.processOnDemandStaticImports(state, new StaticImportFilteringProcessor(this.getEnumeratedDeclarations(), processor))) {
            return false;
        }
        if (shouldProcessClasses && !this.processOnDemandTypeImports(state, place, processor)) {
            return false;
        }
        if (shouldProcessClasses && !this.processModules(state, place, processor)) {
            return false;
        }
        return !shouldProcessClasses || this.processImplicitImports(state, place, processor);
    }

    private boolean processModules(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(26);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(28);
        }
        List implicitModuleImports = ContainerUtil.filterIsInstance(this.getImplicitImports(), PsiImportModuleStatement.class);
        for (PsiImportModuleStatement statement : ContainerUtil.append((List)implicitModuleImports, (Object[])this.getImportModuleStatements())) {
            PsiElement resolved = statement.resolve();
            if (resolved == null) continue;
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement);
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, state, place, processor)) continue;
            return false;
        }
        return true;
    }

    private PsiImportStaticStatement @NotNull [] getImportStaticStatements() {
        PsiImportStaticStatement[] psiImportStaticStatementArray = this.getImportList() != null ? this.getImportList().getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (psiImportStaticStatementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(29);
        }
        return psiImportStaticStatementArray;
    }

    private PsiImportStatement @NotNull [] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = this.getImportList() != null ? this.getImportList().getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
        if (psiImportStatementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(30);
        }
        return psiImportStatementArray;
    }

    private PsiImportModuleStatement @NotNull [] getImportModuleStatements() {
        PsiImportModuleStatement[] psiImportModuleStatementArray = this.getImportList() != null ? this.getImportList().getImportModuleStatements() : PsiImportModuleStatement.EMPTY_ARRAY;
        if (psiImportModuleStatementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(31);
        }
        return psiImportModuleStatementArray;
    }

    private boolean processCurrentPackage(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(32);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(34);
        }
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
        return aPackage == null || PsiJavaFileBaseImpl.processPackageDeclarations(state, place, aPackage, processor);
    }

    private boolean processOnDemandTypeImports(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(35);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(36);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(37);
        }
        for (PsiImportStatement statement : this.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement);
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, state, place, processor)) continue;
            return false;
        }
        return true;
    }

    private boolean processOnDemandStaticImports(@NotNull ResolveState state, @NotNull StaticImportFilteringProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(39);
        }
        List implicitStaticImports = ContainerUtil.filterIsInstance(this.getImplicitImports(), PsiImportStaticStatement.class);
        for (PsiImportStaticStatement importStaticStatement : ContainerUtil.append((List)implicitStaticImports, (Object[])this.getImportStaticStatements())) {
            PsiClass targetElement;
            if (!importStaticStatement.isOnDemand() || (targetElement = importStaticStatement.resolveTargetClass()) == null) continue;
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, importStaticStatement);
            if (PsiClassImplUtil.processAllMembersWithoutSubstitutors(targetElement, (PsiScopeProcessor)processor, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitImports(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(40);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(42);
        }
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        for (PsiJavaCodeReferenceElement aImplicitlyImported : this.getImplicitlyImportedPackageReferences()) {
            PsiElement resolved = aImplicitlyImported.resolve();
            if (resolved == null) continue;
            if (resolved instanceof PsiPackage && "java.lang".equals(((PsiPackage)resolved).getQualifiedName())) {
                LanguageLevel level = PsiUtil.getLanguageLevel(place);
                processor = new JavaLangClassesFilter((PsiScopeProcessor)processor, level);
            }
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, state, place, processor)) continue;
            return false;
        }
        return true;
    }

    private static boolean processPackageDeclarations(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiPackage aPackage, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(43);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(44);
        }
        if (aPackage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(45);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(46);
        }
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor = new DelegatingScopeProcessor((PsiScopeProcessor)processor){

                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)((ElementClassHint)kind -> kind == ElementClassHint.DeclarationKind.CLASS);
                    }
                    return (T)super.getHint(hintKey);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "getHint"));
                }
            };
        }
        return aPackage.processDeclarations((PsiScopeProcessor)processor, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(47);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(containingClass.getProject()).createRawSubstitutor(containingClass);
        if (psiSubstitutor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(48);
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(@NotNull PsiElement target, @NotNull ResolveState substitutor, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (target == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(49);
        }
        if (substitutor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(50);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(52);
        }
        if (target instanceof PsiPackage) {
            return PsiJavaFileBaseImpl.processPackageDeclarations(substitutor, place, (PsiPackage)target, processor);
        }
        if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            if (target instanceof PsiJavaModule) {
                return PsiJavaFileBaseImpl.processModuleDeclaration(substitutor, place, (PsiJavaModule)target, processor);
            }
            LOG.error("Unexpected target type: " + target);
        }
        return true;
    }

    private static boolean processModuleDeclaration(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiJavaModule target, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(53);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(54);
        }
        if (target == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(55);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(56);
        }
        processor = new DelegatingScopeProcessor((PsiScopeProcessor)processor){

            @Nullable
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (hintKey == ElementClassHint.KEY) {
                    return (T)((ElementClassHint)kind -> kind == ElementClassHint.DeclarationKind.CLASS);
                }
                return (T)super.getHint(hintKey);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$2", "getHint"));
            }
        };
        return target.processDeclarations((PsiScopeProcessor)processor, state, null, place);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(57);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile((PsiFile)this);
        }
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(58);
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(59);
        }
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = (LanguageLevel)((Object)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this));
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(60);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull ImplicitlyImportedElement @NotNull [] getImplicitlyImportedElements() {
        ImplicitlyImportedElement[] implicitlyImportedElementArray = (ImplicitlyImportedElement[])this.myCachedImplicitImportedElements.getValue();
        if (implicitlyImportedElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(61);
        }
        return implicitlyImportedElementArray;
    }

    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(62);
        }
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    @NotNull
    private @Unmodifiable List<PsiImportStatementBase> getImplicitImports() {
        List list = ContainerUtil.map((Object[])this.getImplicitlyImportedElements(), element -> element.createImportStatement());
        if (list == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(63);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private LanguageLevel getLanguageLevelInner() {
        ASTNode firstLeaf;
        if (this.myOriginalFile instanceof PsiJavaFile) {
            LanguageLevel languageLevel = ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
            if (languageLevel == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(64);
            }
            return languageLevel;
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)((Object)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY));
        if (forcedLanguageLevel != null) {
            LanguageLevel languageLevel = forcedLanguageLevel;
            if (languageLevel == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(65);
            }
            return languageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = this.getViewProvider().getVirtualFile();
        }
        String sourceLevel = null;
        FileElement treeElement = this.getTreeElement();
        ASTNode aSTNode = firstLeaf = treeElement == null ? null : TreeUtil.findFirstLeaf((ASTNode)treeElement, (boolean)false);
        if (firstLeaf == null || Strings.startsWith((CharSequence)firstLeaf.getChars(), (int)0, (CharSequence)"#!")) {
            block16: {
                LanguageLevel languageLevel;
                try {
                    LanguageLevel sheBangLevel;
                    List params;
                    int srcIdx;
                    CharSequence line;
                    CharSequence contents = this.getViewProvider().getContents();
                    int lineBound = Strings.indexOf((CharSequence)contents, (CharSequence)"\n");
                    CharSequence charSequence = line = lineBound > 0 ? contents.subSequence(0, lineBound) : contents;
                    if (!Strings.startsWith((CharSequence)line, (int)0, (CharSequence)"#!") || (srcIdx = (params = ParametersListUtil.parse((String)line.toString())).indexOf("--source")) <= 0 || srcIdx + 1 >= params.size() || (sheBangLevel = LanguageLevel.parse(sourceLevel = (String)params.get(srcIdx + 1))) == null) break block16;
                    languageLevel = sheBangLevel;
                }
                catch (Throwable file) {
                    if (!Objects.equals(sourceLevel, virtualFile.getUserData(SHEBANG_SOURCE_LEVEL)) && virtualFile.isInLocalFileSystem()) {
                        virtualFile.putUserData(SHEBANG_SOURCE_LEVEL, sourceLevel);
                        VirtualFile file2 = virtualFile;
                        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2}), ModalityState.nonModal(), ApplicationManager.getApplication().getDisposed());
                    }
                    catch (Throwable throwable) {
                        if (!Objects.equals(sourceLevel, virtualFile.getUserData(SHEBANG_SOURCE_LEVEL)) && virtualFile.isInLocalFileSystem()) {
                            virtualFile.putUserData(SHEBANG_SOURCE_LEVEL, sourceLevel);
                            VirtualFile file3 = virtualFile;
                            ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2}), ModalityState.nonModal(), ApplicationManager.getApplication().getDisposed());
                        }
                        throw throwable;
                    }
                }
                if (!Objects.equals(sourceLevel, virtualFile.getUserData(SHEBANG_SOURCE_LEVEL)) && virtualFile.isInLocalFileSystem()) {
                    virtualFile.putUserData(SHEBANG_SOURCE_LEVEL, (Object)sourceLevel);
                    VirtualFile file = virtualFile;
                    ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2}), ModalityState.nonModal(), ApplicationManager.getApplication().getDisposed());
                }
                LanguageLevel languageLevel2 = languageLevel;
                if (languageLevel2 == null) {
                    PsiJavaFileBaseImpl.$$$reportNull$$$0(66);
                }
                return languageLevel2;
            }
            if (!Objects.equals(sourceLevel, virtualFile.getUserData(SHEBANG_SOURCE_LEVEL)) && virtualFile.isInLocalFileSystem()) {
                virtualFile.putUserData(SHEBANG_SOURCE_LEVEL, sourceLevel);
                VirtualFile file = virtualFile;
                ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2}), ModalityState.nonModal(), ApplicationManager.getApplication().getDisposed());
            }
        }
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.getProject()).getEffectiveLanguageLevel(virtualFile);
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(67);
        }
        return languageLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: 
            case 25: 
            case 28: 
            case 34: 
            case 37: 
            case 39: 
            case 42: 
            case 46: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: 
            case 23: 
            case 26: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 24: 
            case 27: 
            case 33: 
            case 36: 
            case 41: 
            case 44: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownClasses";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeImports";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticImports";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumeratedDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findEnumeratedDeclarations";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findExplicitDeclarations";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportModuleStatements";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedElements";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitImports";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPackageName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findImportReferenceTo";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findExplicitDeclarations";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandPackages";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processModules";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processCurrentPackage";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandTypeImports";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandStaticImports";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitImports";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDeclarations";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandTarget";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processModuleDeclaration";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        @NotNull
        private final PsiJavaFileBaseImpl myFile;

        MyCacheBuilder(@NotNull PsiJavaFileBaseImpl file) {
            if (file == null) {
                MyCacheBuilder.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @NotNull
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processOnDemandPackages(ResolveState.initial(), (PsiElement)this.myFile, p);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            CachedValueProvider.Result result = CachedValueProvider.Result.create(results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myFile});
            if (result == null) {
                MyCacheBuilder.$$$reportNull$$$0(1);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$MyCacheBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$MyCacheBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        MyResolveCacheProcessor(@NotNull ResolveState state, @NotNull PsiScopeProcessor processor) {
            if (state == null) {
                MyResolveCacheProcessor.$$$reportNull$$$0(0);
            }
            if (processor == null) {
                MyResolveCacheProcessor.$$$reportNull$$$0(1);
            }
            this.myProcessor = processor;
            this.myState = state;
        }

        public boolean process(@NotNull SymbolCollectingProcessor.ResultWithContext result) {
            PsiClass containingClass;
            if (result == null) {
                MyResolveCacheProcessor.$$$reportNull$$$0(2);
            }
            PsiElement context = result.getFileContext();
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)context);
            PsiNamedElement element = result.getElement();
            if (element == null) {
                return this.myProcessor.executeForUnresolved();
            }
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute((PsiElement)element, this.myState.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute((PsiElement)element, this.myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$MyResolveCacheProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StaticImportFilteringProcessor
    extends DelegatingScopeProcessor {
        private final Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> myExplicitlyEnumerated;
        private final Collection<PsiElement> myCollectedElements;

        StaticImportFilteringProcessor(@NotNull Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated, @NotNull PsiScopeProcessor delegate) {
            if (explicitlyEnumerated == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myCollectedElements = new HashSet<PsiElement>();
            this.myExplicitlyEnumerated = explicitlyEnumerated;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                PsiScopeProcessor delegate = this.getDelegate();
                if (element instanceof PsiNamedElement) {
                    PsiElement currentFileContext;
                    PsiClass containingClass;
                    String name = ((PsiNamedElement)element).getName();
                    Iterable<SymbolCollectingProcessor.ResultWithContext> shadowing = this.myExplicitlyEnumerated.get(name);
                    if (shadowing != null && ContainerUtil.exists(shadowing, rwc -> StaticImportFilteringProcessor.hasSameDeclarationKind(element, (PsiElement)rwc.getElement()))) {
                        return true;
                    }
                    if (delegate instanceof MethodsProcessor && element instanceof PsiMethod && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface() && (currentFileContext = ((MethodsProcessor)delegate).getCurrentFileContext()) instanceof PsiImportStaticStatement && ((PsiImportStaticStatement)currentFileContext).isOnDemand() && !containingClass.isEquivalentTo(((PsiImportStaticStatement)currentFileContext).resolveTargetClass())) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return delegate.execute(element, state);
                }
            }
            return true;
        }

        private static boolean hasSameDeclarationKind(PsiElement e1, PsiElement e2) {
            return e1 instanceof PsiClass ? e2 instanceof PsiClass : (e1 instanceof PsiMethod ? e2 instanceof PsiMethod : e2 instanceof PsiField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "explicitlyEnumerated";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JavaLangClassesFilter
    extends DelegatingScopeProcessor {
        private static final Map<String, LanguageLevel> ourJavaLangClassFeatures = new HashMap<String, LanguageLevel>();
        private final LanguageLevel myLevel;

        JavaLangClassesFilter(@NotNull PsiScopeProcessor processor, LanguageLevel level) {
            if (processor == null) {
                JavaLangClassesFilter.$$$reportNull$$$0(0);
            }
            super(processor);
            this.myLevel = level;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            LanguageLevel classMinLevel;
            if (element == null) {
                JavaLangClassesFilter.$$$reportNull$$$0(1);
            }
            if (state == null) {
                JavaLangClassesFilter.$$$reportNull$$$0(2);
            }
            if (element instanceof PsiClass && (classMinLevel = ourJavaLangClassFeatures.get(((PsiClass)element).getName())) != null && this.myLevel.isLessThan(classMinLevel)) {
                return true;
            }
            return super.execute(element, state);
        }

        static {
            ourJavaLangClassFeatures.put("MatchException", JavaFeature.PATTERNS_IN_SWITCH.getMinimumLevel());
            ourJavaLangClassFeatures.put("Module", JavaFeature.MODULES.getMinimumLevel());
            ourJavaLangClassFeatures.put("ModuleLayer", JavaFeature.MODULES.getMinimumLevel());
            ourJavaLangClassFeatures.put("ProcessHandle", LanguageLevel.JDK_1_9);
            ourJavaLangClassFeatures.put("Record", JavaFeature.RECORDS.getMinimumLevel());
            ourJavaLangClassFeatures.put("ScopedValue", JavaFeature.SCOPED_VALUES.getMinimumLevel());
            ourJavaLangClassFeatures.put("WrongThreadException", LanguageLevel.JDK_19);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$JavaLangClassesFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

