/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression, PsiType t) {
        super(t);
        this.myExpression = expression;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        block18: {
            PsiExpression body2;
            PsiType type2;
            if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
                return true;
            }
            PsiType myT = this.getCurrentType();
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression;
                PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression, myT));
                }
                if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression, myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType(myT)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(myT)));
                return false;
            }
            PsiType groundTargetType = this.myExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT, (PsiLambdaExpression)this.myExpression, false) : FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(groundTargetType);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(myT)));
                return false;
            }
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, PsiUtil.resolveGenericsClassInType(groundTargetType));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                    PsiType type3 = substitutor.substitute(parameter.getType());
                    if (session.isProperType(type3)) continue;
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.parameter.type.is.not.yet.inferred", session.getPresentableText(type3)));
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session.isProperType(type2 = substitutor.substitute(returnType)))) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.return.type.is.not.yet.inferred", session.getPresentableText(type2)));
                return false;
            }
            List expectedThrownTypes = ContainerUtil.map((Object[])interfaceMethod.getThrowsList().getReferencedTypes(), type -> session.substituteWithInferenceVariables(substitutor.substitute((PsiType)type)));
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type3 : expectedThrownTypes) {
                if (session.isProperType(type3)) continue;
                expectedNonProperThrownTypes.add(type3);
            }
            ArrayList thrownTypes = new ArrayList();
            PsiExpression psiExpression = body2 = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body2 != null) {
                List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body2});
                thrownTypes.addAll(ContainerUtil.filter((Collection)exceptions, type -> !ExceptionUtil.isUncheckedException(type)));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType thrownType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, thrownType)) continue;
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.unhandled.exception", session.getPresentableText(thrownType)));
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType thrownType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, thrownType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, thrownType));
                    }
                }
                for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                    InferenceVariable variable = session.getInferenceVariable(expectedNonProperThrownType);
                    if (variable == null) continue;
                    variable.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable(expectedThrownType, thrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression) {
        return new CheckedExceptionCompatibilityConstraint(expression, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<? super InferenceVariable> result) {
        session.collectDependencies(returnType, result);
    }
}

