/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PsiConditionalExpressionImpl
extends ExpressionPsiElement
implements PsiConditionalExpression {
    private static final Logger LOG = Logger.getInstance(PsiConditionalExpressionImpl.class);

    public PsiConditionalExpressionImpl() {
        super(JavaElementType.CONDITIONAL_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression getCondition() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(32);
        if (psiExpression == null) {
            PsiConditionalExpressionImpl.$$$reportNull$$$0(0);
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getThenExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(112);
    }

    @Override
    public PsiExpression getElseExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(113);
    }

    @Override
    public PsiType getType() {
        PsiType type2;
        PsiExpression expr1 = this.getThenExpression();
        PsiExpression expr2 = this.getElseExpression();
        PsiType type1 = expr1 == null ? null : expr1.getType();
        PsiType psiType = type2 = expr2 == null ? null : expr2.getType();
        if (Objects.equals(type1, type2)) {
            return type1 == null ? null : type1.withNullability(type1.getNullability().join(type2.getNullability()));
        }
        if (PsiUtil.isLanguageLevel8OrHigher(this) && PsiPolyExpressionUtil.isPolyExpression(this)) {
            PsiType targetType = InferenceSession.getTargetType(this);
            if (MethodCandidateInfo.isOverloadCheck()) {
                return targetType != null && type1 != null && type2 != null && targetType.isAssignableFrom(type1) && targetType.isAssignableFrom(type2) ? targetType : null;
            }
            if (targetType != null) {
                return targetType;
            }
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        int typeRank1 = TypeConversionUtil.getTypeRank(type1);
        int typeRank2 = TypeConversionUtil.getTypeRank(type2);
        if (type1 instanceof PsiClassType && type2.equals(PsiPrimitiveType.getUnboxedType(type1))) {
            return type2;
        }
        if (type2 instanceof PsiClassType && type1.equals(PsiPrimitiveType.getUnboxedType(type2))) {
            return type1;
        }
        if (TypeConversionUtil.isNumericType(typeRank1) && TypeConversionUtil.isNumericType(typeRank2)) {
            if (typeRank1 == 1 && typeRank2 == 2) {
                return type2 instanceof PsiPrimitiveType ? type2 : PsiPrimitiveType.getUnboxedType(type2);
            }
            if (typeRank1 == 2 && typeRank2 == 1) {
                return type1 instanceof PsiPrimitiveType ? type1 : PsiPrimitiveType.getUnboxedType(type1);
            }
            if (typeRank2 == 4 && (typeRank1 == 1 || typeRank1 == 2 || typeRank1 == 3) && TypeConversionUtil.areTypesAssignmentCompatible(type1, expr2)) {
                return type1;
            }
            if (typeRank1 == 4 && (typeRank2 == 1 || typeRank2 == 2 || typeRank2 == 3) && TypeConversionUtil.areTypesAssignmentCompatible(type2, expr1)) {
                return type2;
            }
            return TypeConversionUtil.binaryNumericPromotion(type1, type2);
        }
        if (TypeConversionUtil.isNullType(type1) && !(type2 instanceof PsiPrimitiveType)) {
            return type2.withNullability(type2.getNullability().join(type1.getNullability()));
        }
        if (TypeConversionUtil.isNullType(type2) && !(type1 instanceof PsiPrimitiveType)) {
            return type1.withNullability(type2.getNullability().join(type1.getNullability()));
        }
        if (TypeConversionUtil.isAssignable(type1, type2, false)) {
            return type1;
        }
        if (TypeConversionUtil.isAssignable(type2, type1, false)) {
            return type2;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(this)) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) && (type1 = ((PsiPrimitiveType)type1).getBoxedType(this)) == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type2) && (type2 = ((PsiPrimitiveType)type2).getBoxedType(this)) == null) {
            return null;
        }
        if (type1 instanceof PsiLambdaParameterType || type2 instanceof PsiLambdaParameterType) {
            return null;
        }
        PsiType leastUpperBound = GenericsUtil.getLeastUpperBound(type1, type2, (PsiManager)this.getManager());
        return leastUpperBound != null ? PsiUtil.captureToplevelWildcards(leastUpperBound, this) : null;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 32: {
                return this.getFirstChildNode();
            }
            case 114: {
                return this.findChildByType(JavaTokenType.QUEST);
            }
            case 112: {
                ASTNode quest = this.findChildByRole(114);
                ASTNode child = quest.getTreeNext();
                while (true) {
                    if (child == null) {
                        return null;
                    }
                    if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) break;
                    child = child.getTreeNext();
                }
                return child;
            }
            case 87: {
                return this.findChildByType(JavaTokenType.COLON);
            }
            case 113: {
                ASTNode colon = this.findChildByRole(87);
                if (colon == null) {
                    return null;
                }
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiConditionalExpressionImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            int role = this.getChildRole(child, 32);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 112);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 113);
            return role;
        }
        if (child.getElementType() == JavaTokenType.QUEST) {
            return 114;
        }
        if (child.getElementType() == JavaTokenType.COLON) {
            return 87;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiConditionalExpressionImpl.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitConditionalExpression(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiConditionalExpressionImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiConditionalExpressionImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            PsiConditionalExpressionImpl.$$$reportNull$$$0(5);
        }
        if (lastParent == null) {
            return true;
        }
        ElementClassHint elementClassHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        PsiExpression condition = this.getCondition();
        if (lastParent == this.getThenExpression()) {
            return condition.processDeclarations(processor, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
        }
        if (lastParent == this.getElseExpression()) {
            return condition.processDeclarations(processor, PatternResolveState.WHEN_FALSE.putInto(state), null, place);
        }
        return true;
    }

    public String toString() {
        return "PsiConditionalExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiConditionalExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCondition";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiConditionalExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

