/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast;

import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u001a.\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u001a \u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a \u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\"\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"getNameElement", "Lcom/intellij/psi/PsiElement;", "uElement", "Lorg/jetbrains/uast/UElement;", "getIdentifierAnnotationOwner", "Lorg/jetbrains/uast/UDeclaration;", "identifier", "getUParentForAnnotationIdentifier", "getContainingUAnnotationEntry", "Lkotlin/Pair;", "Lorg/jetbrains/uast/UAnnotation;", "", "annotationsHint", "", "getContainingAnnotationEntry", "Lcom/intellij/psi/PsiAnnotation;", "isResolvedToAnnotation", "", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "parentAnyway", "getParentAnyway", "(Lorg/jetbrains/uast/UElement;)Lorg/jetbrains/uast/UElement;", "intellij.platform.uast"})
@JvmName(name="UAnnotationUtils")
@SourceDebugExtension(value={"SMAP\nUAnnotationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UAnnotationUtils.kt\norg/jetbrains/uast/UAnnotationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class UAnnotationUtils {
    @Nullable
    public static final PsiElement getNameElement(@Nullable UElement uElement) {
        PsiElement psiElement;
        UElement uElement2 = uElement;
        if (uElement2 instanceof UAnnotation) {
            psiElement = UAnnotationKt.getNamePsiElement((UAnnotation)uElement);
        } else if (uElement2 instanceof USimpleNameReferenceExpression) {
            psiElement = ((USimpleNameReferenceExpression)uElement).getSourcePsi();
        } else if (uElement2 instanceof UCallExpression) {
            UIdentifier uIdentifier = ((UCallExpression)uElement).getMethodIdentifier();
            if (uIdentifier != null && (uIdentifier = uIdentifier.getSourcePsi()) != null) {
                UIdentifier it = uIdentifier;
                boolean bl = false;
                psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)it);
            } else {
                psiElement = null;
            }
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    public static final UDeclaration getIdentifierAnnotationOwner(@NotNull PsiElement identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        UElement uElement = UAnnotationUtils.getUParentForAnnotationIdentifier(identifier);
        return uElement != null ? UDeclarationKt.getContainingDeclaration(uElement) : null;
    }

    @Nullable
    public static final UElement getUParentForAnnotationIdentifier(@NotNull PsiElement identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        UElement uElement = UastUtils.getUParentForIdentifier(identifier);
        if (uElement == null) {
            return null;
        }
        UElement originalParent = uElement;
        UElement uElement2 = originalParent;
        if (uElement2 instanceof UAnnotation) {
            return originalParent;
        }
        if (uElement2 instanceof UCallExpression) {
            return UAnnotationUtils.isResolvedToAnnotation(((UCallExpression)originalParent).getClassReference()) ? originalParent : null;
        }
        if (uElement2 instanceof UReferenceExpression && UAnnotationUtils.isResolvedToAnnotation((UReferenceExpression)originalParent)) {
            UElement uElement3 = UAnnotationUtils.getParentAnyway(originalParent);
            if (uElement3 == null) {
                return null;
            }
            UElement parentAnyway = uElement3;
            UElement uElement4 = (UElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile(UElementKt.getWithContainingElements(parentAnyway), UAnnotationUtils::getUParentForAnnotationIdentifier$lambda$0));
            if (uElement4 == null) {
                return parentAnyway;
            }
            UElement annotationLikeParent = uElement4;
            if (!(annotationLikeParent instanceof UAnnotation) && annotationLikeParent.getUastParent() instanceof UAnnotation) {
                return annotationLikeParent.getUastParent();
            }
            return annotationLikeParent;
        }
        return null;
    }

    @Nullable
    public static final Pair<UAnnotation, String> getContainingUAnnotationEntry(@Nullable UElement uElement, @NotNull Collection<String> annotationsHint) {
        Intrinsics.checkNotNullParameter(annotationsHint, (String)"annotationsHint");
        if (uElement == null) {
            return null;
        }
        PsiElement sourcePsi = uElement.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        Language language2 = sourcePsi.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        UastLanguagePlugin uastLanguagePlugin = UastLanguagePlugin.Companion.byLanguage(language2);
        if (uastLanguagePlugin == null) {
            return null;
        }
        UastLanguagePlugin plugin = uastLanguagePlugin;
        Pair<UAnnotation, String> entry = plugin.getContainingAnnotationEntry(uElement, annotationsHint);
        if (entry != null && !annotationsHint.isEmpty()) {
            String string = ((UAnnotation)entry.getFirst()).getQualifiedName();
            if (string == null) {
                return null;
            }
            String qualifiedName = string;
            if (!annotationsHint.contains(qualifiedName)) {
                return null;
            }
        }
        return entry;
    }

    @Nullable
    public static final Pair<UAnnotation, String> getContainingUAnnotationEntry(@Nullable UElement uElement) {
        return UAnnotationUtils.getContainingUAnnotationEntry(uElement, CollectionsKt.emptyList());
    }

    @Nullable
    public static final Pair<PsiAnnotation, String> getContainingAnnotationEntry(@Nullable UElement uElement) {
        Pair<UAnnotation, String> pair = UAnnotationUtils.getContainingUAnnotationEntry(uElement);
        if (pair == null) {
            return null;
        }
        Pair<UAnnotation, String> pair2 = pair;
        UAnnotation uAnnotation = (UAnnotation)pair2.component1();
        String name = (String)pair2.component2();
        PsiAnnotation psiAnnotation = uAnnotation.getJavaPsi();
        if (psiAnnotation == null) {
            return null;
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        return TuplesKt.to((Object)psiAnnotation2, (Object)name);
    }

    private static final boolean isResolvedToAnnotation(UReferenceExpression reference) {
        UReferenceExpression uReferenceExpression = reference;
        PsiElement psiElement = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        return psiClass != null ? psiClass.isAnnotationType() : false;
    }

    private static final UElement getParentAnyway(UElement $this$parentAnyway) {
        UElement uElement = $this$parentAnyway.getUastParent();
        if (uElement == null) {
            PsiElement psiElement = $this$parentAnyway.getSourcePsi();
            uElement = (UElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)(psiElement != null ? psiElement.getParent() : null), UAnnotationUtils::_get_parentAnyway_$lambda$0), UAnnotationUtils::_get_parentAnyway_$lambda$1));
        }
        return uElement;
    }

    private static final boolean getUParentForAnnotationIdentifier$lambda$0(UElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UTypeReferenceExpression || it instanceof UReferenceExpression;
    }

    private static final PsiElement _get_parentAnyway_$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final UElement _get_parentAnyway_$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastContextKt.toUElement(it);
    }
}

