/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.analysis;

import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/uast/analysis/KotlinExtensionConstants;", "", "<init>", "()V", "STANDARD_CLASS", "", "LET_METHOD", "ALSO_METHOD", "RUN_METHOD", "APPLY_METHOD", "LAMBDA_THIS_PARAMETER_NAME", "isExtensionWithSideEffect", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "isLetOrRunCall", "isAlsoOrApplyCall", "isExtensionFunctionToIgnore", "intellij.platform.uast"})
@SourceDebugExtension(value={"SMAP\nKotlinExtensionConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtensionConstants.kt\norg/jetbrains/uast/analysis/KotlinExtensionConstants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class KotlinExtensionConstants {
    @NotNull
    public static final KotlinExtensionConstants INSTANCE = new KotlinExtensionConstants();
    @NotNull
    public static final String STANDARD_CLASS = "kotlin.StandardKt__StandardKt";
    @NotNull
    public static final String LET_METHOD = "let";
    @NotNull
    public static final String ALSO_METHOD = "also";
    @NotNull
    public static final String RUN_METHOD = "run";
    @NotNull
    public static final String APPLY_METHOD = "apply";
    @NotNull
    public static final String LAMBDA_THIS_PARAMETER_NAME = "<this>";

    private KotlinExtensionConstants() {
    }

    public final boolean isExtensionWithSideEffect(@NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return Intrinsics.areEqual((Object)call.getMethodName(), (Object)ALSO_METHOD) || Intrinsics.areEqual((Object)call.getMethodName(), (Object)APPLY_METHOD);
    }

    public final boolean isLetOrRunCall(@NotNull UCallExpression call) {
        PsiClass psiClass;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Object object = call;
        UCallExpression it = object;
        boolean bl = false;
        UCallExpression uCallExpression = Intrinsics.areEqual((Object)it.getMethodName(), (Object)LET_METHOD) || Intrinsics.areEqual((Object)it.getMethodName(), (Object)RUN_METHOD) ? object : null;
        return Intrinsics.areEqual(uCallExpression != null && (object = uCallExpression.resolve()) != null && (psiClass = object.getContainingClass()) != null ? psiClass.getQualifiedName() : null, (Object)STANDARD_CLASS);
    }

    public final boolean isAlsoOrApplyCall(@NotNull UCallExpression call) {
        PsiClass psiClass;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Object object = call;
        UCallExpression it = object;
        boolean bl = false;
        UCallExpression uCallExpression = Intrinsics.areEqual((Object)it.getMethodName(), (Object)ALSO_METHOD) || Intrinsics.areEqual((Object)it.getMethodName(), (Object)APPLY_METHOD) ? object : null;
        return Intrinsics.areEqual(uCallExpression != null && (object = uCallExpression.resolve()) != null && (psiClass = object.getContainingClass()) != null ? psiClass.getQualifiedName() : null, (Object)STANDARD_CLASS);
    }

    public final boolean isExtensionFunctionToIgnore(@NotNull UCallExpression call) {
        PsiClass psiClass;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Object object = call;
        UCallExpression it = object;
        boolean bl = false;
        UCallExpression uCallExpression = Intrinsics.areEqual((Object)it.getMethodName(), (Object)LET_METHOD) || Intrinsics.areEqual((Object)it.getMethodName(), (Object)ALSO_METHOD) || Intrinsics.areEqual((Object)it.getMethodName(), (Object)RUN_METHOD) || Intrinsics.areEqual((Object)it.getMethodName(), (Object)APPLY_METHOD) ? object : null;
        return Intrinsics.areEqual(uCallExpression != null && (object = uCallExpression.resolve()) != null && (psiClass = object.getContainingClass()) != null ? psiClass.getQualifiedName() : null, (Object)STANDARD_CLASS);
    }
}

