/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.performancePlugin;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.performanceTesting.vcs.VcsTestUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiJavaDirectoryFactory;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/java/performancePlugin/CreateJavaFileCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.java.performancePlugin"})
@SourceDebugExtension(value={"SMAP\nCreateJavaFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateJavaFileCommand.kt\ncom/intellij/java/performancePlugin/CreateJavaFileCommand\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,60:1\n27#2:61\n87#2,2:62\n28#2,3:64\n98#2:67\n90#2,6:68\n*S KotlinDebug\n*F\n+ 1 CreateJavaFileCommand.kt\ncom/intellij/java/performancePlugin/CreateJavaFileCommand\n*L\n52#1:61\n52#1:62,2\n52#1:64,3\n52#1:67\n52#1:68,6\n*E\n"})
public final class CreateJavaFileCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "createJavaFile";
    @NotNull
    public static final String PREFIX = "%createJavaFile";
    @NotNull
    private static final Map<String, String> POSSIBLE_FILE_TYPES;

    public CreateJavaFileCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String string = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
        String[] stringArray = new String[]{","};
        List list = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)string, (String)"\\s", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String fileName = (String)list.get(0);
        String filePath = (String)list.get(1);
        String fileType = (String)list.get(2);
        PsiDirectoryFactory psiDirectoryFactory = PsiJavaDirectoryFactory.getInstance((Project)context.getProject());
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            throw new RuntimeException("Root of the project was not found");
        }
        VirtualFile virtualFile2 = VirtualFileUtil.findDirectory((VirtualFile)virtualFile, (String)filePath);
        if (virtualFile2 == null) {
            throw new RuntimeException("Can't find file " + filePath);
        }
        PsiDirectory psiDirectory = psiDirectoryFactory.createDirectory(virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"createDirectory(...)");
        PsiDirectory directory = psiDirectory;
        String string2 = fileType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String templateName = POSSIBLE_FILE_TYPES.get(string2);
        if (templateName == null) {
            throw new RuntimeException("File type must be one of '" + POSSIBLE_FILE_TYPES.keySet() + "'");
        }
        Project project2 = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        VcsTestUtil.INSTANCE.provisionVcsAddFileConfirmation(project2, VcsTestUtil.VcsAddFileConfirmation.DO_NOTHING);
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> CreateJavaFileCommand.doExecute$lambda$0(directory, fileName, templateName)));
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doExecute$lambda$0(PsiDirectory $directory, String $fileName, String $templateName) {
        SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(NAME);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Unit unit;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                JavaDirectoryService.getInstance().createClass($directory, $fileName, $templateName, true);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit2 = unit;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    static {
        Pair[] pairArray = new Pair[5];
        String string = JavaPsiBundle.message((String)"node.class.tooltip", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        pairArray[0] = new Pair((Object)string2, (Object)JavaPsiBundle.message((String)"node.class.tooltip", (Object[])new Object[0]));
        String string3 = JavaPsiBundle.message((String)"node.record.tooltip", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        pairArray[1] = new Pair((Object)string4, (Object)JavaPsiBundle.message((String)"node.record.tooltip", (Object[])new Object[0]));
        String string5 = JavaPsiBundle.message((String)"node.interface.tooltip", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        String string6 = string5.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        pairArray[2] = new Pair((Object)string6, (Object)JavaPsiBundle.message((String)"node.interface.tooltip", (Object[])new Object[0]));
        String string7 = JavaPsiBundle.message((String)"node.annotation.tooltip", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        String string8 = string7.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        pairArray[3] = new Pair((Object)string8, (Object)JavaPsiBundle.message((String)"node.annotation.tooltip", (Object[])new Object[0]));
        String string9 = JavaPsiBundle.message((String)"node.enum.tooltip", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
        String string10 = string9.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
        pairArray[4] = new Pair((Object)string10, (Object)JavaPsiBundle.message((String)"node.enum.tooltip", (Object[])new Object[0]));
        POSSIBLE_FILE_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/java/performancePlugin/CreateJavaFileCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "POSSIBLE_FILE_TYPES", "", "Lorg/jetbrains/annotations/Nls;", "getPOSSIBLE_FILE_TYPES", "()Ljava/util/Map;", "intellij.java.performancePlugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getPOSSIBLE_FILE_TYPES() {
            return POSSIBLE_FILE_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

