/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.jam.JamService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.cloud.stream.SpringCloudStreamBundle;
import com.intellij.spring.boot.cloud.stream.icons.SpringBootCloudStreamIcons;
import com.intellij.spring.boot.cloud.stream.library.SpringCloudStreamLibraryUtil;
import com.intellij.spring.boot.cloud.stream.model.SpringCloudStreamBindingService;
import com.intellij.spring.boot.cloud.stream.model.jam.Input;
import com.intellij.spring.boot.cloud.stream.model.jam.MessageChannel;
import com.intellij.spring.boot.cloud.stream.model.jam.Output;
import com.intellij.spring.boot.cloud.stream.model.jam.SpringCloudStreamEndpoint;
import com.intellij.spring.boot.cloud.stream.model.jam.StreamEmitter;
import com.intellij.spring.boot.cloud.stream.model.jam.StreamListener;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.integration.constants.SpringIntegrationAnnotationsConstants;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

final class MessageHandlerLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>> GOTO_RELATED_ITEM_PROVIDER = psiElement -> Collections.singletonList(new GotoRelatedItem(psiElement, SpringCloudStreamBundle.message("spring.cloud.stream.gutter.bound.message.handlers.goto.group", new Object[0])));

    MessageHandlerLineMarkerProvider() {
    }

    public String getId() {
        return "MessageHandlerLineMarkerProvider";
    }

    public String getName() {
        return SpringCloudStreamBundle.message("spring.cloud.stream.gutter.name", new Object[0]);
    }

    public Icon getIcon() {
        return SpringBootCloudStreamIcons.SpringCloudStream;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        if (!SpringCloudStreamLibraryUtil.hasSpringCloudStream(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement))) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UDeclaration elementToProcess;
        if (psiElement == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (!((elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)psiElement)) instanceof UMethod)) {
            return;
        }
        PsiMethod psiMethod = ((UMethod)elementToProcess).getJavaPsi();
        if (psiMethod.isConstructor()) {
            return;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        SemService semService = SemService.getSemService((Project)psiMethod.getProject());
        SpringCloudStreamEndpoint streamEndpoint = (SpringCloudStreamEndpoint)semService.getSemElement(SpringCloudStreamEndpoint.STREAM_ENDPOINT_JAM_KEY, (PsiElement)psiMethod);
        if (streamEndpoint != null) {
            MessageHandlerLineMarkerProvider.annotateEndpoint(psiElement, psiClass, streamEndpoint, result);
        } else {
            List endpoints = semService.getSemElements(SpringIntegrationJamMethodEndpoint.ENDPOINT_JAM_KEY, (PsiElement)psiMethod);
            for (SpringIntegrationJamMethodEndpoint endpoint : endpoints) {
                MessageHandlerLineMarkerProvider.annotateEndpoint(psiElement, psiClass, endpoint, result);
            }
        }
    }

    private static void annotateEndpoint(@NotNull PsiElement nameIdentifier, @NotNull PsiClass psiClass, @NotNull SpringIntegrationJamMethodEndpoint endpoint, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiElement psiAnnotationIdentifier;
        if (nameIdentifier == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (psiClass == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (endpoint == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (result == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if ((psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)endpoint.getAnnotation()))) != nameIdentifier) {
            return;
        }
        MessageHandlerLineMarkerProvider.annotateEndpoint(nameIdentifier, psiClass, endpoint.getInboundChannelNames(), false, result);
        MessageHandlerLineMarkerProvider.annotateEndpoint(nameIdentifier, psiClass, endpoint.getOutboundChannelNames(), true, result);
    }

    private static void annotateEndpoint(@NotNull PsiElement nameIdentifier, @NotNull PsiClass psiClass, @NotNull Set<String> channelNames, boolean matchConsumers, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (nameIdentifier == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (channelNames == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (result == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(11);
        }
        if (channelNames.isEmpty()) {
            return;
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)(matchConsumers ? AllIcons.Gutter.ReadAccess : AllIcons.Gutter.WriteAccess), ContainerUtil::createMaybeSingletonList, GOTO_RELATED_ITEM_PROVIDER);
        builder.setPopupTitle(SpringCloudStreamBundle.message("spring.cloud.stream.gutter.bound.message.handlers.title", new Object[0])).setTooltipText(SpringCloudStreamBundle.message("spring.cloud.stream.gutter.bound.message.handlers.tooltip", new Object[0])).setEmptyPopupText(SpringCloudStreamBundle.message("spring.cloud.stream.gutter.bound.message.handlers.empty.title", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> MessageHandlerLineMarkerProvider.findHandlers(nameIdentifier, psiClass, channelNames, matchConsumers)));
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(nameIdentifier));
    }

    @NotNull
    private static Collection<? extends PsiElement> findHandlers(@NotNull PsiElement nameIdentifier, @NotNull PsiClass psiClass, @NotNull Set<String> channelNames, boolean matchConsumers) {
        if (nameIdentifier == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (psiClass == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(13);
        }
        if (channelNames == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(14);
        }
        if (!nameIdentifier.isValid()) {
            Set set = Collections.emptySet();
            if (set == null) {
                MessageHandlerLineMarkerProvider.$$$reportNull$$$0(15);
            }
            return set;
        }
        Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)nameIdentifier);
        if (moduleForPsiElement == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                MessageHandlerLineMarkerProvider.$$$reportNull$$$0(16);
            }
            return set;
        }
        SpringModelUtils springModelUtils = SpringModelUtils.getInstance();
        Set activeProfilesForPsiElement = springModelUtils.getPsiClassSpringModel(psiClass).getActiveProfiles();
        SpringCloudStreamBindingService bindingService = SpringCloudStreamBindingService.getInstance(moduleForPsiElement.getProject());
        Set destinations = channelNames.stream().flatMap(channelName -> bindingService.getDestinations((String)channelName, moduleForPsiElement, activeProfilesForPsiElement).stream()).filter(destination -> !destination.isEmpty()).collect(Collectors.toSet());
        if (destinations.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                MessageHandlerLineMarkerProvider.$$$reportNull$$$0(17);
            }
            return set;
        }
        LinkedHashSet<PsiModifierListOwner> result = new LinkedHashSet<PsiModifierListOwner>();
        JamService jamService = JamService.getJamService((Project)moduleForPsiElement.getProject());
        for (Module module : ModuleManager.getInstance((Project)moduleForPsiElement.getProject()).getModules()) {
            if (!SpringCloudStreamLibraryUtil.hasSpringCloudStream(module)) continue;
            Set activeProfiles = SpringManager.getInstance((Project)moduleForPsiElement.getProject()).getCombinedModel(module).getActiveProfiles();
            Set boundChannelNames = destinations.stream().flatMap(destination -> bindingService.getChannels((String)destination, module, activeProfiles).stream()).collect(Collectors.toSet());
            for (String destination2 : destinations) {
                if (boundChannelNames.contains(destination2) || !bindingService.getDestinations(destination2, module, activeProfiles).contains(destination2) || !MessageHandlerLineMarkerProvider.findModuleMessageChannelNames(module).contains(destination2)) continue;
                boundChannelNames.add(destination2);
            }
            if (boundChannelNames.isEmpty()) continue;
            GlobalSearchScope scope = module.getModuleScope();
            ArrayList candidates = new ArrayList(jamService.getJamMethodElements(StreamListener.JAM_KEY, "org.springframework.cloud.stream.annotation.StreamListener", scope));
            if (!matchConsumers) {
                candidates.addAll(jamService.getJamMethodElements(StreamEmitter.JAM_KEY, "org.springframework.cloud.stream.reactive.StreamEmitter", scope));
            }
            for (String siAnno : matchConsumers ? SpringIntegrationAnnotationsConstants.MESSAGE_CONSUMERS : SpringIntegrationAnnotationsConstants.MESSAGE_PRODUCERS) {
                candidates.addAll(jamService.getJamMethodElements(SpringIntegrationJamMethodEndpoint.ENDPOINT_JAM_KEY, siAnno, scope));
            }
            for (SpringIntegrationJamMethodEndpoint candidate : candidates) {
                Set candidateChannels = matchConsumers ? candidate.getInboundChannelNames() : candidate.getOutboundChannelNames();
                if (!ContainerUtil.intersects((Collection)candidateChannels, boundChannelNames)) continue;
                result.add((PsiModifierListOwner)candidate.getPsiElement());
            }
        }
        LinkedHashSet<PsiModifierListOwner> linkedHashSet = result;
        if (linkedHashSet == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(18);
        }
        return linkedHashSet;
    }

    private static List<String> findModuleMessageChannelNames(@NotNull Module module) {
        if (module == null) {
            MessageHandlerLineMarkerProvider.$$$reportNull$$$0(19);
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            JamService jamService = JamService.getJamService((Project)module.getProject());
            GlobalSearchScope runtimeScope = module.getModuleRuntimeScope(false);
            ArrayList messageChannels = new ArrayList(jamService.getJamMethodElements(Input.INPUT_JAM_KEY, "org.springframework.cloud.stream.annotation.Input", runtimeScope));
            messageChannels.addAll(jamService.getJamMethodElements(Output.OUTPUT_JAM_KEY, "org.springframework.cloud.stream.annotation.Output", runtimeScope));
            return CachedValueProvider.Result.create((Object)ContainerUtil.map(messageChannels, MessageChannel::getBeanName), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelNames";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/stream/gutter/MessageHandlerLineMarkerProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/stream/gutter/MessageHandlerLineMarkerProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotateEndpoint";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findHandlers";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findModuleMessageChannelNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

