/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000bJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH&J\b\u0010\u001e\u001a\u00020\u001fH&J\b\u0010 \u001a\u00020\u001fH&J\u001a\u0010!\u001a\u00020\n2\b\b\u0001\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H&J\u001e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000bJ\u0018\u0010'\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\u0018\u0010!\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H&J\u0010\u0010)\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H&J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH&J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u001fH\u0007J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.H&J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\nH&J\u001a\u00100\u001a\u00020#2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u00101\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u0006J\u0014\u00103\u001a\u0004\u0018\u00010\n2\b\u0010\"\u001a\u0004\u0018\u00010#H&J\u0012\u00104\u001a\u0004\u0018\u00010\n2\u0006\u00102\u001a\u00020\u0006H&J\u0018\u00105\u001a\u0004\u0018\u00010\n2\u0006\u00106\u001a\u00020#2\u0006\u0010\"\u001a\u00020#J\u0018\u00105\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#J\u0012\u00107\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nH&J\u0012\u00108\u001a\u00020\u00172\b\u00109\u001a\u0004\u0018\u00010\nH&J\u0010\u0010:\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u0006H'R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006<"}, d2={"Lcom/intellij/execution/RunManager;", "", "<init>", "()V", "getConfigurationsList", "", "Lcom/intellij/execution/configurations/RunConfiguration;", "type", "Lcom/intellij/execution/configurations/ConfigurationType;", "getConfigurationSettingsList", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "Ljava/lang/Class;", "getAllConfigurations", "", "()[Lcom/intellij/execution/configurations/RunConfiguration;", "allConfigurationsList", "getAllConfigurationsList", "()Ljava/util/List;", "allSettings", "getAllSettings", "tempConfigurationsList", "getTempConfigurationsList", "makeStable", "", "settings", "selectedConfiguration", "getSelectedConfiguration", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "setSelectedConfiguration", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "shouldSetRunConfigurationFromContext", "", "isRiderRunWidgetActive", "createConfiguration", "name", "", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "typeClass", "createRunConfiguration", "runConfiguration", "getConfigurationTemplate", "addConfiguration", "storeInDotIdeaFolder", "refreshUsagesList", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "hasSettings", "suggestUniqueName", "setUniqueNameIfNeeded", "configuration", "findConfigurationByName", "findSettings", "findConfigurationByTypeAndName", "typeId", "removeConfiguration", "setTemporaryConfiguration", "tempConfiguration", "isTemplate", "Companion", "intellij.platform.execution"})
@SourceDebugExtension(value={"SMAP\nRunManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunManager.kt\ncom/intellij/execution/RunManager\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,248:1\n37#2,2:249\n1586#3:251\n1661#3,3:252\n296#3,2:256\n296#3,2:258\n1#4:255\n13#5:260\n*S KotlinDebug\n*F\n+ 1 RunManager.kt\ncom/intellij/execution/RunManager\n*L\n93#1:249,2\n196#1:251\n196#1:252,3\n227#1:256,2\n229#1:258,2\n39#1:260\n*E\n"})
public abstract class RunManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String UNNAMED = "Unnamed";
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> IS_RUN_MANAGER_INITIALIZED;
    @NotNull
    private static final Logger LOG;
    private static final Pattern UNIQUE_NAME_PATTERN;
    @NotNull
    public static final String CONFIGURATION_TYPE_FEATURE_ID = "com.intellij.configurationType";

    @NotNull
    public abstract List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType var1);

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType var1);

    @NotNull
    public final List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull Class<? extends ConfigurationType> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.getConfigurationSettingsList(ConfigurationTypeUtil.findConfigurationType(type));
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="allConfigurationsList", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final RunConfiguration[] getAllConfigurations() {
        Collection $this$toTypedArray$iv = this.getAllConfigurationsList();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new RunConfiguration[0]);
    }

    @NotNull
    public abstract List<RunConfiguration> getAllConfigurationsList();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getAllSettings();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getTempConfigurationsList();

    public abstract void makeStable(@NotNull RunnerAndConfigurationSettings var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings getSelectedConfiguration();

    public abstract void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    public abstract boolean shouldSetRunConfigurationFromContext();

    public abstract boolean isRiderRunWidgetActive();

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NlsSafe @NotNull String var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public final RunnerAndConfigurationSettings createConfiguration(@NotNull String name, @NotNull Class<? extends ConfigurationType> typeClass) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(typeClass, (String)"typeClass");
        ConfigurationFactory[] configurationFactoryArray = ConfigurationTypeUtil.findConfigurationType(typeClass).getConfigurationFactories();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
        Object object = ArraysKt.first((Object[])configurationFactoryArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return this.createConfiguration(name, (ConfigurationFactory)object);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="createConfiguration(name, factory)", imports={}))
    @NotNull
    public final RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        return this.createConfiguration(name, factory);
    }

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public abstract RunnerAndConfigurationSettings getConfigurationTemplate(@NotNull ConfigurationFactory var1);

    public abstract void addConfiguration(@NotNull RunnerAndConfigurationSettings var1);

    @Deprecated(message="There are different ways of storing run configuration in a file. Clients should use RunManager.addConfiguration(RunnerAndConfigurationSettings) and before that, if needed, RunnerAndConfigurationSettings.storeInDotIdeaFolder(), storeInArbitraryFileInProject(String) or storeInLocalWorkspace().")
    public final void addConfiguration(@NotNull RunnerAndConfigurationSettings settings, boolean storeInDotIdeaFolder) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (storeInDotIdeaFolder) {
            settings.storeInDotIdeaFolder();
        } else {
            settings.storeInLocalWorkspace();
        }
        this.addConfiguration(settings);
    }

    public abstract void refreshUsagesList(@NotNull RunProfile var1);

    public abstract boolean hasSettings(@NotNull RunnerAndConfigurationSettings var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String suggestUniqueName(@Nullable String name, @Nullable ConfigurationType type) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConfigurationType configurationType = type;
        List<RunnerAndConfigurationSettings> settingsList = configurationType == null ? this.getAllSettings() : this.getConfigurationSettingsList(configurationType);
        String string = StringKt.nullize$default((String)name, (boolean)false, (int)1, null);
        if (string == null) {
            string = UNNAMED;
        }
        Iterable iterable = settingsList;
        String string2 = string;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        return companion.suggestUniqueName(string2, collection);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setUniqueNameIfNeeded(@NotNull RunnerAndConfigurationSettings settings) {
        void it;
        String oldName;
        String string;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String string2 = settings.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string = (oldName = string2);
        RunManager runManager = this;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
        String string4 = bl2 ? string : null;
        if (string4 == null) {
            string4 = UNNAMED;
        }
        runnerAndConfigurationSettings.setName(runManager.suggestUniqueName(string4, settings.getType()));
        return !Intrinsics.areEqual((Object)oldName, (Object)settings.getName());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setUniqueNameIfNeeded(@NotNull RunConfiguration configuration) {
        void it;
        String oldName;
        String string;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string2 = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string = (oldName = string2);
        RunManager runManager = this;
        RunConfiguration runConfiguration = configuration;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
        String string4 = bl2 ? string : null;
        if (string4 == null) {
            string4 = UNNAMED;
        }
        runConfiguration.setName(runManager.suggestUniqueName(string4, configuration.getType()));
        return !Intrinsics.areEqual((Object)oldName, (Object)configuration.getName());
    }

    @Nullable
    public abstract RunnerAndConfigurationSettings findConfigurationByName(@Nullable String var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings findSettings(@NotNull RunConfiguration var1);

    @Nullable
    public final RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull String typeId, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)typeId, (Object)it.getType().getId()) && Intrinsics.areEqual((Object)name, (Object)it.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull ConfigurationType type, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(type == it.getType() && Intrinsics.areEqual((Object)name, (Object)it.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public abstract void removeConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    public abstract void setTemporaryConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    @ApiStatus.Internal
    public abstract boolean isTemplate(@NotNull RunConfiguration var1);

    @JvmStatic
    @NotNull
    public static final RunManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final RunManager getInstanceIfCreated(@NotNull Project project) {
        return Companion.getInstanceIfCreated(project);
    }

    @JvmStatic
    @NotNull
    public static final String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
        return Companion.suggestUniqueName(str, currentNames);
    }

    @JvmStatic
    @NotNull
    public static final String extractBaseName(@NotNull String uniqueName) {
        return Companion.extractBaseName(uniqueName);
    }

    static {
        Key key = Key.create((String)"RunManagerInitialized");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_RUN_MANAGER_INITIALIZED = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RunManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        UNIQUE_NAME_PATTERN = Pattern.compile("(.*?)\\s*\\(\\d+\\)");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0007J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/RunManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/execution/RunManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "UNNAMED", "", "IS_RUN_MANAGER_INITIALIZED", "Lcom/intellij/openapi/util/Key;", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "suggestUniqueName", "str", "currentNames", "", "UNIQUE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "extractBaseName", "uniqueName", "CONFIGURATION_TYPE_FEATURE_ID", "intellij.platform.execution"})
    @SourceDebugExtension(value={"SMAP\nRunManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunManager.kt\ncom/intellij/execution/RunManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,248:1\n58#2:249\n*S KotlinDebug\n*F\n+ 1 RunManager.kt\ncom/intellij/execution/RunManager$Companion\n*L\n31#1:249\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RunManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!Intrinsics.areEqual((Object)IS_RUN_MANAGER_INITIALIZED.get((UserDataHolder)project), (Object)true) && !project.isDefault()) {
                LOG.warn("Must be not called before project components initialized");
            }
            Object object = project.getService(RunManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RunManager)object;
        }

        @JvmStatic
        @Nullable
        public final RunManager getInstanceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            return (RunManager)$this$serviceIfCreated$iv.getServiceIfCreated(RunManager.class);
        }

        @JvmStatic
        @NotNull
        public final String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter(currentNames, (String)"currentNames");
            if (!currentNames.contains(str)) {
                return str;
            }
            String originalName = this.extractBaseName(str);
            int i = 1;
            while (true) {
                String newName;
                String string = "%s (%d)";
                Object[] objectArray = new Object[]{originalName, i};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                if (!currentNames.contains(newName)) {
                    return newName;
                }
                ++i;
            }
        }

        @JvmStatic
        @NotNull
        public final String extractBaseName(@NotNull String uniqueName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
            Matcher matcher = UNIQUE_NAME_PATTERN.matcher(uniqueName);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            } else {
                string = uniqueName;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

