/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.product.serialization.impl;

import com.intellij.platform.runtime.product.RuntimeModuleLoadingRule;
import com.intellij.platform.runtime.product.serialization.RawIncludedFromData;
import com.intellij.platform.runtime.product.serialization.RawIncludedRuntimeModule;
import com.intellij.platform.runtime.product.serialization.RawProductModules;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.NotNull;

public final class ProductModulesXmlSerializer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static RawProductModules parseModuleXml(@NotNull InputStream inputStream) throws XMLStreamException {
        if (inputStream == null) {
            ProductModulesXmlSerializer.$$$reportNull$$$0(0);
        }
        XMLStreamReader reader = XMLInputFactory.newDefaultFactory().createXMLStreamReader(inputStream);
        int level = 0;
        RuntimeModuleLoadingRule loadingRule = null;
        String moduleName = null;
        ArrayList<RawIncludedRuntimeModule> rootMainGroupModules = new ArrayList<RawIncludedRuntimeModule>();
        ArrayList<RuntimeModuleId> bundledPluginMainModules = new ArrayList<RuntimeModuleId>();
        ArrayList<RawIncludedFromData> includedFrom = new ArrayList<RawIncludedFromData>();
        RuntimeModuleId includedFromModule = null;
        LinkedHashSet<Object> withoutModules = new LinkedHashSet<RuntimeModuleId>();
        String secondLevelTag = null;
        String thirdLevelTag = null;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                String tagName = reader.getLocalName();
                if (++level == 2) {
                    secondLevelTag = tagName;
                    continue;
                }
                if (level != 3) continue;
                thirdLevelTag = tagName;
                if (!tagName.equals("module")) continue;
                if (reader.getAttributeCount() > 0) {
                    String loadingRuleString;
                    String attributeName = reader.getAttributeLocalName(0);
                    if (!"loading".equals(attributeName)) {
                        throw new XMLStreamException("Unexpected attribute '" + attributeName + "'");
                    }
                    switch (loadingRuleString = reader.getAttributeValue(0)) {
                        case "optional": {
                            loadingRule = RuntimeModuleLoadingRule.OPTIONAL;
                            break;
                        }
                        case "required": {
                            loadingRule = RuntimeModuleLoadingRule.REQUIRED;
                            break;
                        }
                        case "embedded": {
                            loadingRule = RuntimeModuleLoadingRule.EMBEDDED;
                            break;
                        }
                        case "on-demand": {
                            loadingRule = RuntimeModuleLoadingRule.ON_DEMAND;
                            break;
                        }
                        default: {
                            throw new XMLStreamException("Unknown loading rule '" + loadingRuleString + "'");
                        }
                    }
                    continue;
                }
                loadingRule = RuntimeModuleLoadingRule.REQUIRED;
                continue;
            }
            if (event == 4) {
                if (level != 3) continue;
                moduleName = reader.getText().trim();
                continue;
            }
            if (event != 2) continue;
            if (--level == 2) {
                if (moduleName == null || moduleName.isEmpty()) {
                    throw new XMLStreamException("Module name is not specified");
                }
                RuntimeModuleId moduleId = RuntimeModuleId.raw((String)moduleName);
                if ("main-root-modules".equals(secondLevelTag)) {
                    assert (loadingRule != null);
                    rootMainGroupModules.add(new RawIncludedRuntimeModule(moduleId, loadingRule));
                } else if ("bundled-plugins".equals(secondLevelTag)) {
                    bundledPluginMainModules.add(moduleId);
                } else {
                    if (!"include".equals(secondLevelTag)) throw new XMLStreamException("Unexpected second-level tag " + secondLevelTag);
                    if ("from-module".equals(thirdLevelTag)) {
                        includedFromModule = moduleId;
                    } else {
                        if (!"without-module".equals(thirdLevelTag)) throw new XMLStreamException("Unexpected sub tag in 'include': " + secondLevelTag);
                        withoutModules.add(moduleId);
                    }
                }
                moduleName = null;
                loadingRule = null;
            } else if (level == 1 && "include".equals(secondLevelTag)) {
                if (includedFromModule == null) {
                    throw new XMLStreamException("'from-module' tag for 'include' is not specified");
                }
                includedFrom.add(new RawIncludedFromData(includedFromModule, withoutModules));
                includedFromModule = null;
                withoutModules = new LinkedHashSet();
            }
            if (level != 0) continue;
            break;
        }
        reader.close();
        return new RawProductModules(rootMainGroupModules, bundledPluginMainModules, includedFrom);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/platform/runtime/product/serialization/impl/ProductModulesXmlSerializer", "parseModuleXml"));
    }
}

