/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.intellij.openapi.util.BuildNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/remoteDev/util/ClientVersionUtil;", "", "<init>", "()V", "separateConfigSupportedSince", "Lcom/intellij/openapi/util/BuildNumber;", "getSeparateConfigSupportedSince", "()Lcom/intellij/openapi/util/BuildNumber;", "separateConfigSupportedSince232", "getSeparateConfigSupportedSince232", "separateConfigEnabledByDefaultSince", "getSeparateConfigEnabledByDefaultSince", "separateConfigEnabledByDefaultSince232", "getSeparateConfigEnabledByDefaultSince232", "sameDefaultPathsAsLocalIdesUsedSince", "getSameDefaultPathsAsLocalIdesUsedSince", "isSeparateConfigSupported", "", "clientBuild", "isClientUsesTheSamePathsAsLocalIde", "clientVersion", "", "computeSeparateConfigEnvVariableValue", "intellij.remoteDev.util"})
@ApiStatus.Internal
public final class ClientVersionUtil {
    @NotNull
    public static final ClientVersionUtil INSTANCE = new ClientVersionUtil();

    private ClientVersionUtil() {
    }

    private final BuildNumber getSeparateConfigSupportedSince() {
        return new BuildNumber("", 233, 173);
    }

    private final BuildNumber getSeparateConfigSupportedSince232() {
        return new BuildNumber("", 232, 8661);
    }

    private final BuildNumber getSeparateConfigEnabledByDefaultSince() {
        return new BuildNumber("", 233, 2350);
    }

    private final BuildNumber getSeparateConfigEnabledByDefaultSince232() {
        return new BuildNumber("", 232, 9552);
    }

    private final BuildNumber getSameDefaultPathsAsLocalIdesUsedSince() {
        return new BuildNumber("", 242, 13718);
    }

    public final boolean isSeparateConfigSupported(@NotNull BuildNumber clientBuild) {
        Intrinsics.checkNotNullParameter((Object)clientBuild, (String)"clientBuild");
        return clientBuild.compareTo(this.getSeparateConfigSupportedSince()) >= 0 || clientBuild.getBaselineVersion() == 232 && clientBuild.compareTo(this.getSeparateConfigSupportedSince232()) >= 0;
    }

    public final boolean isClientUsesTheSamePathsAsLocalIde(@NotNull String clientVersion) {
        Intrinsics.checkNotNullParameter((Object)clientVersion, (String)"clientVersion");
        BuildNumber clientBuild = BuildNumber.fromString((String)clientVersion);
        return clientBuild != null && clientBuild.compareTo(this.getSameDefaultPathsAsLocalIdesUsedSince()) >= 0;
    }

    @Nullable
    public final String computeSeparateConfigEnvVariableValue(@NotNull BuildNumber clientBuild) {
        Intrinsics.checkNotNullParameter((Object)clientBuild, (String)"clientBuild");
        if (this.isSeparateConfigSupported(clientBuild) && clientBuild.compareTo(this.getSeparateConfigEnabledByDefaultSince()) < 0 && (clientBuild.getBaselineVersion() != 232 || clientBuild.compareTo(this.getSeparateConfigEnabledByDefaultSince232()) < 0)) {
            return "true";
        }
        return null;
    }
}

