/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.ExecutionException;
import com.intellij.idea.AppMode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0007H\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/HelperFilesLocator;", "", "<init>", "()V", "pathToResourceRoot", "", "findBundledHelpersDir", "Ljava/nio/file/Path;", "resourceRoot", "findFileRelativeToHelpersDir", "Ljava/io/File;", "relativePath", "helpersDir", "getFileRelativeToHelpersDir", "resourcePath", "resolvePathOrThrowExecutionExecution", "resolvePathForExecution", "getBundledHelpersDir", "intellij.javascript.backend"})
public final class HelperFilesLocator {
    @NotNull
    public static final HelperFilesLocator INSTANCE = new HelperFilesLocator();

    private HelperFilesLocator() {
    }

    private final String pathToResourceRoot() {
        return AppMode.isRunningFromDevBuild() ? "javascript-plugin" : "JavaScriptLanguage/resources";
    }

    private final Path findBundledHelpersDir(String resourceRoot) {
        return JSPluginPathManager.getPluginResource(HelperFilesLocator.class, (String)"helpers", (String)resourceRoot);
    }

    @JvmStatic
    private static final File findFileRelativeToHelpersDir(String relativePath, Path helpersDir) throws IOException {
        String string = FileUtil.toSystemDependentName((String)relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String systemDependentRelativePath = string;
        Path file = helpersDir.resolve(systemDependentRelativePath).normalize();
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IOException("Cannot find " + relativePath + ", no such file or directory " + file.toFile());
        }
        File file2 = file.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    @JvmStatic
    @NotNull
    public static final File getFileRelativeToHelpersDir(@NotNull String relativePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return HelperFilesLocator.getFileRelativeToHelpersDir(relativePath, INSTANCE.pathToResourceRoot());
    }

    @JvmStatic
    @NotNull
    public static final File getFileRelativeToHelpersDir(@NotNull String relativePath, @NotNull String resourcePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Path helpersDir = INSTANCE.findBundledHelpersDir(resourcePath);
        return HelperFilesLocator.findFileRelativeToHelpersDir(relativePath, helpersDir);
    }

    @JvmStatic
    @NotNull
    public static final Path resolvePathOrThrowExecutionExecution(@NotNull String relativePath) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return HelperFilesLocator.resolvePathOrThrowExecutionExecution(relativePath, INSTANCE.pathToResourceRoot());
    }

    @JvmStatic
    @NotNull
    public static final Path resolvePathOrThrowExecutionExecution(@NotNull String relativePath, @NotNull String resourcePath) throws ExecutionException {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        try {
            File file = HelperFilesLocator.getFileRelativeToHelpersDir(relativePath, resourcePath);
            path2 = file.toPath();
            Intrinsics.checkNotNull((Object)path2);
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof IOException || exception instanceof InvalidPathException) {
                Object[] objectArray = new Object[]{relativePath};
                throw new ExecutionException(JavaScriptBundle.message((String)"dialog.message.cannot.find.file", (Object[])objectArray), (Throwable)e);
            }
            throw e;
        }
        return path2;
    }

    @JvmStatic
    @NotNull
    public static final String resolvePathForExecution(@NotNull String relativePath) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return HelperFilesLocator.resolvePathForExecution(relativePath, INSTANCE.pathToResourceRoot());
    }

    @JvmStatic
    @NotNull
    public static final String resolvePathForExecution(@NotNull String relativePath, @NotNull String resourcePath) throws ExecutionException {
        String string;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        try {
            File file = HelperFilesLocator.getFileRelativeToHelpersDir(relativePath, resourcePath);
            string = file.getAbsolutePath();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{relativePath};
            throw new ExecutionException(JavaScriptBundle.message((String)"dialog.message.cannot.find.file", (Object[])objectArray), (Throwable)e);
        }
        return string;
    }

    @Deprecated(message="Use resolvePathOrThrowExecutionExecution(\".\") instead", replaceWith=@ReplaceWith(expression="resolvePathOrThrowExecutionExecution()", imports={"com.intellij.javascript.HelperFilesLocator.resolvePathOrThrowExecutionExecution"}))
    @JvmStatic
    @NotNull
    public static final File getBundledHelpersDir() {
        File file = INSTANCE.findBundledHelpersDir(INSTANCE.pathToResourceRoot()).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }
}

