/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.workspaceModel;

import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntity;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntityBuilder;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntityManager;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntityManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "packageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sync", "", "createPackageJsonEntity", "Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonEntityBuilder;", "packageJson", "areEntitiesOutdated", "", "actualEntities", "getWorkspaceModelEntities", "Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonEntity;", "getEntities", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "updateEntities", "PackageJsonEntityWrapper", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nPackageJsonEntityStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonEntityStartupActivity.kt\ncom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,85:1\n1642#2,10:86\n1915#2:96\n1916#2:98\n1652#2:99\n1586#2:100\n1661#2,3:101\n1661#2,3:104\n1661#2,3:107\n1586#2:110\n1661#2,3:111\n1#3:97\n30#4,2:114\n*S KotlinDebug\n*F\n+ 1 PackageJsonEntityStartupActivity.kt\ncom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer\n*L\n29#1:86,10\n29#1:96\n29#1:98\n29#1:99\n36#1:100\n36#1:101,3\n51#1:104,3\n52#1:107,3\n73#1:110\n73#1:111,3\n29#1:97\n77#1:114,2\n*E\n"})
final class PackageJsonModelSynchronizer {
    @NotNull
    private final Project project;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final VirtualFileUrlManager virtualFileUrlManager;
    @NotNull
    private final List<VirtualFile> packageJsonFiles;

    public PackageJsonModelSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.project);
        this.virtualFileUrlManager = this.workspaceModel.getVirtualFileUrlManager();
        Set<VirtualFile> set = PackageJsonFileManager.getInstance(this.project).getValidPackageJsonFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
        this.packageJsonFiles = CollectionsKt.toList((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    public final void sync() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.packageJsonFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            PackageJsonEntityBuilder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (this.createPackageJsonEntity(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actualEntities = (List)destination$iv$iv;
        if (this.areEntitiesOutdated(actualEntities)) {
            this.updateEntities(actualEntities);
        } else if (PackageJsonEntityManagerKt.getLOG().isDebugEnabled()) {
            Collection<VirtualFileUrl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$mapNotNull$iv = actualEntities;
            int n = actualEntities.size();
            Logger logger = PackageJsonEntityManagerKt.getLOG();
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (PackageJsonEntityBuilder)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPackageJsonParentDirUrl());
            }
            collection = (List)destination$iv$iv;
            logger.debug("Entities are up-to-date (" + n + "): " + (List)collection);
        }
    }

    private final PackageJsonEntityBuilder createPackageJsonEntity(VirtualFile packageJson) {
        VirtualFile virtualFile = packageJson.getParent();
        if (virtualFile == null) {
            PackageJsonModelSynchronizer $this$createPackageJsonEntity_u24lambda_u240 = this;
            boolean bl = false;
            PackageJsonEntityManagerKt.getLOG().error("package.json file without parent: " + packageJson);
            return null;
        }
        VirtualFile packageJsonParentDir = virtualFile;
        return PackageJsonEntityManagerKt.createPackageJsonEntity$default(VirtualFileUrls.toVirtualFileUrl((VirtualFile)packageJsonParentDir, (VirtualFileUrlManager)this.virtualFileUrlManager), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areEntitiesOutdated(List<? extends PackageJsonEntityBuilder> actualEntities) {
        void $this$mapTo$iv;
        Collection collection;
        void $this$mapTo$iv2;
        List<PackageJsonEntity> workspaceModelEntities = this.getWorkspaceModelEntities(this.workspaceModel);
        if (workspaceModelEntities.size() != actualEntities.size()) {
            return true;
        }
        Iterable iterable = workspaceModelEntities;
        Iterable destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            PackageJsonEntity packageJsonEntity = (PackageJsonEntity)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new PackageJsonEntityWrapper(it.getPackageJsonParentDirUrl()));
        }
        HashSet wrappedWorkspaceModelEntities = (HashSet)destination$iv;
        destination$iv = actualEntities;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageJsonEntityBuilder bl = (PackageJsonEntityBuilder)item$iv;
            collection = destination$iv2;
            boolean bl2 = false;
            collection.add(new PackageJsonEntityWrapper(it.getPackageJsonParentDirUrl()));
        }
        HashSet wrappedActualEntities = (HashSet)destination$iv2;
        return !Intrinsics.areEqual((Object)wrappedWorkspaceModelEntities, (Object)wrappedActualEntities);
    }

    private final List<PackageJsonEntity> getWorkspaceModelEntities(WorkspaceModel workspaceModel) {
        return this.getEntities(workspaceModel, PackageJsonEntity.class, PackageJsonEntity.MyEntitySource.INSTANCE);
    }

    private final <T extends WorkspaceEntity> List<T> getEntities(WorkspaceModel workspaceModel, Class<T> entityClass, EntitySource entitySource) {
        Sequence entities = workspaceModel.getCurrentSnapshot().entitiesBySource(arg_0 -> PackageJsonModelSynchronizer.getEntities$lambda$0(entitySource, arg_0));
        Sequence list = SequencesKt.filter((Sequence)entities, arg_0 -> PackageJsonModelSynchronizer.getEntities$lambda$1(entityClass, arg_0));
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)list, arg_0 -> PackageJsonModelSynchronizer.getEntities$lambda$2(entityClass, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEntities(List<? extends PackageJsonEntityBuilder> actualEntities) {
        String string;
        MutableEntityStorage actualEntitiesStorage = PackageJsonEntityManagerKt.createStorageFrom(actualEntities);
        if (PackageJsonEntityManagerKt.getLOG().isDebugEnabled()) {
            Collection<VirtualFileUrl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = actualEntities;
            int n = actualEntities.size();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PackageJsonEntityBuilder packageJsonEntityBuilder = (PackageJsonEntityBuilder)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPackageJsonParentDirUrl());
            }
            collection = (List)destination$iv$iv;
            string = "Syncing outdated entities, actual entities (" + n + "): " + (List)collection;
        } else {
            string = "Syncing outdated entities, actual entities: " + actualEntities.size();
        }
        String description = string;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PackageJsonEntityManager> serviceClass$iv = PackageJsonEntityManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PackageJsonEntityManager)object).updateWorkspaceModel$intellij_javascript_backend(description, (Function1<? super MutableEntityStorage, Unit>)((Function1)arg_0 -> PackageJsonModelSynchronizer.updateEntities$lambda$1(actualEntitiesStorage, arg_0)));
    }

    private static final boolean getEntities$lambda$0(EntitySource $entitySource, EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == $entitySource;
    }

    private static final boolean getEntities$lambda$1(Class $entityClass, WorkspaceEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $entityClass.isInstance(it);
    }

    private static final WorkspaceEntity getEntities$lambda$2(Class $entityClass, WorkspaceEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (WorkspaceEntity)$entityClass.cast(it);
    }

    private static final boolean updateEntities$lambda$1$0(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == PackageJsonEntity.MyEntitySource.INSTANCE;
    }

    private static final Unit updateEntities$lambda$1(MutableEntityStorage $actualEntitiesStorage, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        storage.replaceBySource(PackageJsonModelSynchronizer::updateEntities$lambda$1$0, (EntityStorage)$actualEntitiesStorage);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer$PackageJsonEntityWrapper;", "", "packageJsonParentDirUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "getPackageJsonParentDirUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.backend"})
    private static final class PackageJsonEntityWrapper {
        @NotNull
        private final VirtualFileUrl packageJsonParentDirUrl;

        public PackageJsonEntityWrapper(@NotNull VirtualFileUrl packageJsonParentDirUrl) {
            Intrinsics.checkNotNullParameter((Object)packageJsonParentDirUrl, (String)"packageJsonParentDirUrl");
            this.packageJsonParentDirUrl = packageJsonParentDirUrl;
        }

        @NotNull
        public final VirtualFileUrl getPackageJsonParentDirUrl() {
            return this.packageJsonParentDirUrl;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.packageJsonParentDirUrl;
        }

        @NotNull
        public final PackageJsonEntityWrapper copy(@NotNull VirtualFileUrl packageJsonParentDirUrl) {
            Intrinsics.checkNotNullParameter((Object)packageJsonParentDirUrl, (String)"packageJsonParentDirUrl");
            return new PackageJsonEntityWrapper(packageJsonParentDirUrl);
        }

        public static /* synthetic */ PackageJsonEntityWrapper copy$default(PackageJsonEntityWrapper packageJsonEntityWrapper, VirtualFileUrl virtualFileUrl, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFileUrl = packageJsonEntityWrapper.packageJsonParentDirUrl;
            }
            return packageJsonEntityWrapper.copy(virtualFileUrl);
        }

        @NotNull
        public String toString() {
            return "PackageJsonEntityWrapper(packageJsonParentDirUrl=" + this.packageJsonParentDirUrl + ")";
        }

        public int hashCode() {
            return this.packageJsonParentDirUrl.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageJsonEntityWrapper)) {
                return false;
            }
            PackageJsonEntityWrapper packageJsonEntityWrapper = (PackageJsonEntityWrapper)other;
            return Intrinsics.areEqual((Object)this.packageJsonParentDirUrl, (Object)packageJsonEntityWrapper.packageJsonParentDirUrl);
        }
    }
}

